/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.impl;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.netbeans.core.network.proxy.pac.PacHelperMethods;
import org.netbeans.core.network.proxy.pac.PacJsEntryFunction;
import org.netbeans.core.network.proxy.pac.PacParsingException;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluator;
import org.netbeans.core.network.proxy.pac.PacUtils;
import org.netbeans.core.network.proxy.pac.PacValidationException;
import org.netbeans.core.network.proxy.pac.impl.ClassFilterPacHelpers;
import org.netbeans.core.network.proxy.pac.impl.HelperScriptFactory;
import org.netbeans.core.network.proxy.pac.impl.NbPacHelperMethods;
import org.netbeans.core.network.utils.SimpleObjCache;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class NbPacScriptEvaluator
implements PacScriptEvaluator {
    private static final Logger LOGGER = Logger.getLogger(NbPacScriptEvaluator.class.getName());
    private static final String JS_HELPER_METHODS_INSTANCE_NAME = "jsPacHelpers";
    private final boolean canUseURLCaching;
    private final PacScriptEngine scriptEngine;
    private final SimpleObjCache<URI, List<Proxy>> resultCache;
    private static final String PAC_PROXY = "PROXY";
    private static final String PAC_DIRECT = "DIRECT";
    private static final String PAC_SOCKS = "SOCKS";
    private static final String PAC_SOCKS4_FFEXT = "SOCKS4";
    private static final String PAC_SOCKS5_FFEXT = "SOCKS5";
    private static final String PAC_HTTP_FFEXT = "HTTP";
    private static final String PAC_HTTPS_FFEXT = "HTTPS";
    private final boolean nashornJava8u40Available;
    private final String pacScriptSource;

    public NbPacScriptEvaluator(String pacSourceCocde) throws PacParsingException {
        this.pacScriptSource = pacSourceCocde;
        this.nashornJava8u40Available = this.getNashornJava8u40Available();
        this.scriptEngine = this.getScriptEngine(pacSourceCocde);
        this.canUseURLCaching = !NbPacScriptEvaluator.usesTimeDateFunctions(pacSourceCocde);
        this.resultCache = this.canUseURLCaching ? new SimpleObjCache(100) : null;
    }

    @Override
    public List<Proxy> findProxyForURL(URI uri) throws PacValidationException {
        List<Proxy> jsResultAnalyzed;
        if (this.resultCache != null && (jsResultAnalyzed = this.resultCache.get(uri)) != null) {
            return jsResultAnalyzed;
        }
        try {
            Object jsResult = this.scriptEngine.findProxyForURL(PacUtils.toStrippedURLStr(uri), uri.getHost());
            jsResultAnalyzed = this.analyzeResult(uri, jsResult);
            if (this.canUseURLCaching && this.resultCache != null) {
                this.resultCache.put(uri, jsResultAnalyzed);
            }
            return jsResultAnalyzed;
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        catch (ScriptException ex) {
            LOGGER.log(Level.WARNING, "Error when executing PAC script function " + this.scriptEngine.getJsMainFunction().getJsFunctionName() + " : ", ex);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause() instanceof ClassNotFoundException) {
                LOGGER.log(Level.WARNING, "The downloaded PAC script is attempting to access Java class ''{0}'' which may be a sign of maliciousness. You should investigate this with your network administrator.", ex.getCause().getMessage());
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            LOGGER.log(Level.WARNING, "Error when executing PAC script function " + this.scriptEngine.getJsMainFunction().getJsFunctionName() + " : ", ex);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
    }

    @Override
    public boolean usesCaching() {
        return this.canUseURLCaching && this.resultCache != null;
    }

    @Override
    public String getJsEntryFunction() {
        return this.scriptEngine.getJsMainFunction().getJsFunctionName();
    }

    @Override
    public String getEngineInfo() {
        ScriptEngineFactory factory = this.scriptEngine.getScriptEngine().getFactory();
        return factory.getEngineName() + " version " + factory.getEngineVersion();
    }

    @Override
    public String getPacScriptSource() {
        return this.pacScriptSource;
    }

    private PacScriptEngine getScriptEngine(String pacSource) throws PacParsingException {
        try {
            String helperJSScript = this.getHelperJsScriptSource();
            LOGGER.log(Level.FINER, "PAC Helper JavaScript :\n{0}", helperJSScript);
            ScriptEngine engine = this.nashornJava8u40Available ? this.getNashornJSScriptEngine() : this.getGenericJSScriptEngine();
            LOGGER.log(Level.FINE, "PAC script evaluator using:  {0}", this.getEngineInfo(engine));
            PacHelperMethods pacHelpers = (PacHelperMethods)Lookup.getDefault().lookup(PacHelperMethods.class);
            if (pacHelpers == null) {
                pacHelpers = new NbPacHelperMethods();
            }
            Bindings b = engine.createBindings();
            b.put(JS_HELPER_METHODS_INSTANCE_NAME, (Object)pacHelpers);
            engine.setBindings(b, 100);
            engine.eval(pacSource);
            engine.eval(helperJSScript);
            PacJsEntryFunction jsMainFunction = this.nashornJava8u40Available ? this.testScriptEngine(engine, true) : this.testScriptEngine(engine, false);
            return new PacScriptEngine(engine, jsMainFunction);
        }
        catch (ScriptException ex) {
            throw new PacParsingException(ex);
        }
    }

    private boolean getNashornJava8u40Available() {
        try {
            Class<?> clazz = Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    private ScriptEngine getNashornJSScriptEngine() {
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        return factory.getScriptEngine((ClassFilter)new ClassFilterPacHelpers());
    }

    private ScriptEngine getGenericJSScriptEngine() {
        ScriptEngineManager factory = new ScriptEngineManager();
        return factory.getEngineByName("JavaScript");
    }

    private PacJsEntryFunction testScriptEngine(ScriptEngine eng, boolean doDeepTest) throws PacParsingException {
        if (this.isJsFunctionAvailable(eng, PacJsEntryFunction.IPV6_AWARE.getJsFunctionName(), doDeepTest)) {
            return PacJsEntryFunction.IPV6_AWARE;
        }
        if (this.isJsFunctionAvailable(eng, PacJsEntryFunction.STANDARD.getJsFunctionName(), doDeepTest)) {
            return PacJsEntryFunction.STANDARD;
        }
        throw new PacParsingException("Function " + PacJsEntryFunction.STANDARD.getJsFunctionName() + " or " + PacJsEntryFunction.IPV6_AWARE.getJsFunctionName() + " not found in PAC Script.");
    }

    private boolean isJsFunctionAvailable(ScriptEngine eng, String functionName, boolean doDeepTest) {
        ScriptObjectMirror som;
        Object obj = eng.get(functionName);
        if (!doDeepTest && obj != null) {
            return true;
        }
        return doDeepTest && obj != null && obj instanceof ScriptObjectMirror && (som = (ScriptObjectMirror)obj).isFunction();
    }

    private String getHelperJsScriptSource() throws PacParsingException {
        return HelperScriptFactory.getPacHelperSource(JS_HELPER_METHODS_INSTANCE_NAME);
    }

    private static boolean usesTimeDateFunctions(String pacScriptSource) {
        Pattern pattern = Pattern.compile(".*(timeRange\\s*\\(|dateRange\\s*\\(|weekdayRange\\s*\\().*", 32);
        Matcher matcher = pattern.matcher(pacScriptSource);
        return matcher.matches();
    }

    private String getEngineInfo(ScriptEngine engine) {
        StringBuilder sb = new StringBuilder();
        ScriptEngineFactory f = engine.getFactory();
        sb.append("LanguageName=");
        sb.append("\"").append(f.getLanguageName()).append("\"");
        sb.append(" ");
        sb.append("LanguageVersion=");
        sb.append("\"").append(f.getLanguageVersion()).append("\"");
        sb.append(" ");
        sb.append("EngineName=");
        sb.append("\"").append(f.getEngineName()).append("\"");
        sb.append(" ");
        sb.append("EngineNameAliases=");
        sb.append(Arrays.toString(f.getNames().toArray(new String[f.getNames().size()])));
        sb.append(" ");
        sb.append("EngineVersion=");
        sb.append("\"").append(f.getEngineVersion()).append("\"");
        return sb.toString();
    }

    private List<Proxy> analyzeResult(URI uri, Object proxiesString) throws PacValidationException {
        if (proxiesString == null) {
            LOGGER.log(Level.FINE, "Null result for {0}", uri);
            return null;
        }
        StringTokenizer st = new StringTokenizer(proxiesString.toString(), ";");
        LinkedList<Proxy> proxies = new LinkedList<Proxy>();
        while (st.hasMoreTokens()) {
            String proxySpec = st.nextToken().trim();
            proxies.add(NbPacScriptEvaluator.getProxy(proxySpec));
        }
        return proxies;
    }

    private static Proxy getProxy(String proxySpec) throws PacValidationException {
        Proxy.Type proxyType;
        if (proxySpec.equals(PAC_DIRECT)) {
            return Proxy.NO_PROXY;
        }
        String[] ele = proxySpec.split(" +");
        if (ele.length != 2) {
            throw new PacValidationException("The value \"" + proxySpec + "\" has incorrect format");
        }
        switch (ele[0]) {
            case "PROXY": 
            case "HTTP": 
            case "HTTPS": {
                proxyType = Proxy.Type.HTTP;
                break;
            }
            case "SOCKS": 
            case "SOCKS4": 
            case "SOCKS5": {
                proxyType = Proxy.Type.SOCKS;
                break;
            }
            default: {
                throw new PacValidationException("The value \"" + ele[0] + "\" is an unknown proxy type");
            }
        }
        String hostAndPortNo = ele[1];
        int i = hostAndPortNo.lastIndexOf(":");
        if (i <= 0 || i == hostAndPortNo.length() - 1) {
            throw new PacValidationException("The string \"" + ele[1] + "\" has no port number");
        }
        String host = hostAndPortNo.substring(0, i);
        String portStr = hostAndPortNo.substring(i + 1);
        int portNo = -1;
        try {
            portNo = Integer.parseInt(portStr);
        }
        catch (NumberFormatException ex) {
            throw new PacValidationException("The portno value \"" + portStr + "\" cannot be converted to an integer");
        }
        return new Proxy(proxyType, new InetSocketAddress(host, portNo));
    }

    private static class PacScriptEngine {
        private final ScriptEngine scriptEngine;
        private final PacJsEntryFunction jsMainFunction;
        private final Invocable invocable;

        public PacScriptEngine(ScriptEngine scriptEngine, PacJsEntryFunction jsMainFunction) {
            this.scriptEngine = scriptEngine;
            this.jsMainFunction = jsMainFunction;
            this.invocable = (Invocable)((Object)scriptEngine);
        }

        public PacJsEntryFunction getJsMainFunction() {
            return this.jsMainFunction;
        }

        public ScriptEngine getScriptEngine() {
            return this.scriptEngine;
        }

        public Invocable getInvocable() {
            return this.invocable;
        }

        public Object findProxyForURL(String url, String host) throws ScriptException, NoSuchMethodException {
            return this.invocable.invokeFunction(this.jsMainFunction.getJsFunctionName(), url, host);
        }
    }
}

