/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.DefaultScannerListener;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.QueryCreator;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.ContextMemberProvider;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.MergedIndexingContext;
import org.apache.maven.index.context.StaticContextMemberProvider;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.util.IndexCreatorSorter;
import org.codehaus.plexus.util.FileUtils;

@Deprecated
@Singleton
@Named
public class DefaultNexusIndexer
implements NexusIndexer {
    private final Indexer indexer;
    private final Scanner scanner;
    private final IndexerEngine indexerEngine;
    private final QueryCreator queryCreator;
    private final Map<String, IndexingContext> indexingContexts = new ConcurrentHashMap<String, IndexingContext>();

    @Inject
    public DefaultNexusIndexer(Indexer indexer, Scanner scanner, IndexerEngine indexerEngine, QueryCreator queryCreator) {
        this.indexer = indexer;
        this.scanner = scanner;
        this.indexerEngine = indexerEngine;
        this.queryCreator = queryCreator;
    }

    @Override
    public void addIndexingContext(IndexingContext context) {
        this.indexingContexts.put(context.getId(), context);
    }

    @Override
    public IndexingContext addIndexingContext(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException, UnsupportedExistingLuceneIndexException {
        try {
            IndexingContext context = this.indexer.createIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, true, false, indexers);
            this.indexingContexts.put(context.getId(), context);
            return context;
        }
        catch (ExistingLuceneIndexMismatchException e) {
            throw new UnsupportedExistingLuceneIndexException(e.getMessage(), e);
        }
    }

    @Override
    public IndexingContext addIndexingContextForced(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException {
        IndexingContext context = this.indexer.createIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, true, true, indexers);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addIndexingContext(String id, String repositoryId, File repository, Directory directory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException, UnsupportedExistingLuceneIndexException {
        try {
            DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, directory, repositoryUrl, indexUpdateUrl, IndexCreatorSorter.sort(indexers), false);
            this.indexingContexts.put(context.getId(), context);
            return context;
        }
        catch (ExistingLuceneIndexMismatchException e) {
            throw new UnsupportedExistingLuceneIndexException(e.getMessage(), e);
        }
    }

    @Override
    public IndexingContext addIndexingContextForced(String id, String repositoryId, File repository, Directory directory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, directory, repositoryUrl, indexUpdateUrl, IndexCreatorSorter.sort(indexers), true);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addMergedIndexingContext(String id, String repositoryId, File repository, File indexDirectory, boolean searchable, Collection<IndexingContext> contexts) throws IOException {
        return this.addMergedIndexingContext(id, repositoryId, repository, indexDirectory, searchable, (ContextMemberProvider)new StaticContextMemberProvider(contexts));
    }

    @Override
    public IndexingContext addMergedIndexingContext(String id, String repositoryId, File repository, File indexDirectory, boolean searchable, ContextMemberProvider membersProvider) throws IOException {
        IndexingContext context = this.indexer.createMergedIndexingContext(id, repositoryId, repository, indexDirectory, searchable, membersProvider);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addMergedIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, boolean searchable, Collection<IndexingContext> contexts) throws IOException {
        MergedIndexingContext context = new MergedIndexingContext(id, repositoryId, repository, indexDirectory, searchable, (ContextMemberProvider)new StaticContextMemberProvider(contexts));
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addMergedIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, boolean searchable, ContextMemberProvider membersProvider) throws IOException {
        MergedIndexingContext context = new MergedIndexingContext(id, repositoryId, repository, indexDirectory, searchable, membersProvider);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public void removeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        if (this.indexingContexts.containsKey(context.getId())) {
            this.indexingContexts.remove(context.getId());
            this.indexer.closeIndexingContext(context, deleteFiles);
        }
    }

    @Override
    public Map<String, IndexingContext> getIndexingContexts() {
        return Collections.unmodifiableMap(this.indexingContexts);
    }

    @Override
    public void scan(IndexingContext context) throws IOException {
        this.scan(context, null);
    }

    @Override
    public void scan(IndexingContext context, boolean update) throws IOException {
        this.scan(context, null, update);
    }

    @Override
    public void scan(IndexingContext context, ArtifactScanningListener listener) throws IOException {
        this.scan(context, listener, false);
    }

    @Override
    public void scan(IndexingContext context, ArtifactScanningListener listener, boolean update) throws IOException {
        this.scan(context, null, listener, update);
    }

    @Override
    public void scan(IndexingContext context, String fromPath, ArtifactScanningListener listener, boolean update) throws IOException {
        File repositoryDirectory = context.getRepository();
        if (repositoryDirectory == null) {
            return;
        }
        if (!repositoryDirectory.exists()) {
            throw new IOException("Repository directory " + repositoryDirectory + " does not exist");
        }
        File tmpFile = File.createTempFile(context.getId() + "-tmp", "");
        File tmpDir = new File(tmpFile.getParentFile(), tmpFile.getName() + ".dir");
        if (!tmpDir.mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + tmpDir);
        }
        IndexingContext tmpContext = null;
        try {
            FSDirectory directory = FSDirectory.open((Path)tmpDir.toPath());
            if (update) {
                IndexUtils.copyDirectory(context.getIndexDirectory(), (Directory)directory);
            }
            tmpContext = new DefaultIndexingContext(context.getId() + "-tmp", context.getRepositoryId(), context.getRepository(), (Directory)directory, context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators(), true);
            this.scanner.scan(new ScanningRequest(tmpContext, new DefaultScannerListener(tmpContext, this.indexerEngine, update, listener), fromPath));
            tmpContext.updateTimestamp(true);
            context.replace(tmpContext.getIndexDirectory());
        }
        catch (Exception ex) {
            throw (IOException)new IOException("Error scanning context " + context.getId() + ": " + ex).initCause(ex);
        }
        finally {
            if (tmpContext != null) {
                tmpContext.close(true);
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }

    @Override
    public void artifactDiscovered(ArtifactContext ac, IndexingContext context) throws IOException {
        if (ac != null) {
            this.indexerEngine.index(context, ac);
        }
    }

    @Override
    public void addArtifactToIndex(ArtifactContext ac, IndexingContext context) throws IOException {
        this.indexer.addArtifactsToIndex(Collections.singleton(ac), context);
    }

    @Override
    public void addArtifactsToIndex(Collection<ArtifactContext> acs, IndexingContext context) throws IOException {
        this.indexer.addArtifactsToIndex(acs, context);
    }

    @Override
    public void deleteArtifactFromIndex(ArtifactContext ac, IndexingContext context) throws IOException {
        this.indexer.deleteArtifactsFromIndex(Collections.singleton(ac), context);
    }

    @Override
    public void deleteArtifactsFromIndex(Collection<ArtifactContext> acs, IndexingContext context) throws IOException {
        this.indexer.deleteArtifactsFromIndex(acs, context);
    }

    @Override
    public FlatSearchResponse searchFlat(FlatSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            request.getContexts().addAll(this.getIndexingContexts().values());
        }
        return this.indexer.searchFlat(request);
    }

    @Override
    public IteratorSearchResponse searchIterator(IteratorSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            request.getContexts().addAll(this.getIndexingContexts().values());
        }
        return this.indexer.searchIterator(request);
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            request.getContexts().addAll(this.getIndexingContexts().values());
        }
        return this.indexer.searchGrouped(request);
    }

    @Override
    @Deprecated
    public Query constructQuery(Field field, String query, SearchType type) throws IllegalArgumentException {
        try {
            return this.queryCreator.constructQuery(field, query, type);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Query constructQuery(Field field, SearchExpression expression) throws IllegalArgumentException {
        return this.indexer.constructQuery(field, expression);
    }

    @Override
    public Collection<ArtifactInfo> identify(Field field, String query) throws IllegalArgumentException, IOException {
        return this.identify(this.constructQuery(field, query, SearchType.EXACT));
    }

    @Override
    public Collection<ArtifactInfo> identify(File artifact) throws IOException {
        return this.identify(artifact, this.indexingContexts.values());
    }

    @Override
    public Collection<ArtifactInfo> identify(File artifact, Collection<IndexingContext> contexts) throws IOException {
        return this.indexer.identify(artifact, contexts);
    }

    @Override
    public Collection<ArtifactInfo> identify(Query query) throws IOException {
        return this.identify(query, this.indexingContexts.values());
    }

    @Override
    public Collection<ArtifactInfo> identify(Query query, Collection<IndexingContext> contexts) throws IOException {
        return this.indexer.identify(query, contexts);
    }
}

