/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.module.graph;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.module.graph.DependencyEdge;
import org.netbeans.modules.java.module.graph.ModuleNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

final class DependencyCalculator {
    private final FileObject moduleInfo;
    private Collection<? extends ModuleNode> nodes;
    private Collection<DependencyEdge> edges;

    public DependencyCalculator(@NonNull FileObject moduleInfo) {
        Parameters.notNull((CharSequence)"moduleInfo", (Object)moduleInfo);
        this.moduleInfo = moduleInfo;
    }

    @NonNull
    Collection<? extends ModuleNode> getNodes() {
        this.init();
        assert (this.nodes != null);
        return this.nodes;
    }

    @NonNull
    Collection<DependencyEdge> getEdges() {
        this.init();
        assert (this.edges != null);
        return this.edges;
    }

    private void init() {
        if (this.nodes == null) {
            assert (this.edges == null);
            this.nodes = Collections.emptyList();
            this.edges = Collections.emptyList();
            JavaSource js = JavaSource.forFileObject((FileObject)this.moduleInfo);
            if (js != null) {
                try {
                    js.runUserActionTask(cc -> {
                        ModuleElement me;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> decls = cc.getCompilationUnit().getTypeDecls();
                        ModuleElement moduleElement = me = !decls.isEmpty() && decls.get(0).getKind() == Tree.Kind.MODULE ? (ModuleElement)cc.getTrees().getElement(TreePath.getPath(cc.getCompilationUnit(), decls.get(0))) : null;
                        if (me != null) {
                            LinkedHashMap<String, ModuleNode> mods = new LinkedHashMap<String, ModuleNode>();
                            HashSet<DependencyEdge> deps = new HashSet<DependencyEdge>();
                            String name = me.getQualifiedName().toString();
                            ClasspathInfo classpathInfo = cc.getClasspathInfo();
                            ModuleNode node = new ModuleNode(name, me.isUnnamed(), this.isJDK(me, classpathInfo), this.moduleInfo);
                            mods.put(name, node);
                            this.collect(node, me, mods, deps, classpathInfo);
                            this.nodes = mods.values();
                            this.edges = deps;
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    private void collect(@NonNull ModuleNode meNode, @NonNull ModuleElement me, @NonNull Map<String, ModuleNode> mods, @NonNull Collection<DependencyEdge> deps, ClasspathInfo classpathInfo) {
        for (Dependency d : this.collect(me, mods, deps, classpathInfo)) {
            meNode.addChild(d.node);
            d.node.setParent(meNode);
            deps.add(new DependencyEdge(meNode, d.node, d.reqD.isTransitive(), false));
        }
        deps.addAll(this.collectTransitiveDependencies(new HashSet<DependencyEdge>(deps)));
    }

    private Collection<Dependency> collect(@NonNull ModuleElement me, @NonNull Map<String, ModuleNode> mods, @NonNull Collection<DependencyEdge> deps, ClasspathInfo classpathInfo) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (!me.isUnnamed()) {
            for (ModuleElement.Directive directive : me.getDirectives()) {
                boolean unseen;
                if (directive.getKind() != ModuleElement.DirectiveKind.REQUIRES) continue;
                ModuleElement.RequiresDirective reqD = (ModuleElement.RequiresDirective)directive;
                ModuleElement reqMod = reqD.getDependency();
                String name = reqMod.getQualifiedName().toString();
                ModuleNode n = mods.get(name);
                if (n == null) {
                    n = new ModuleNode(name, reqMod.isUnnamed(), this.isJDK(reqMod, classpathInfo), this.moduleInfo);
                    mods.put(name, n);
                    unseen = true;
                } else {
                    unseen = false;
                }
                dependencies.add(new Dependency(n, reqD, unseen));
            }
            for (Dependency dependency : dependencies) {
                if (!dependency.unseen) continue;
                this.collect(dependency.node, dependency.reqD.getDependency(), mods, deps, classpathInfo);
            }
        }
        return dependencies;
    }

    private boolean isJDK(ModuleElement me, ClasspathInfo cpinfo) {
        JavaFileObject cf;
        boolean isJDK = false;
        Symbol.ClassSymbol mi = ((Symbol.ModuleSymbol)me).module_info;
        JavaFileObject javaFileObject = cf = mi != null ? mi.classfile : null;
        if (cf != null) {
            URI uri = cf.toUri();
            ClassPath cp = cpinfo.getClassPath(ClasspathInfo.PathKind.BOOT);
            try {
                isJDK = cp.findOwnerRoot(URLMapper.findFileObject((URL)uri.toURL())) != null;
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return isJDK;
    }

    Collection<DependencyEdge> collectTransitiveDependencies(Collection<DependencyEdge> deps) {
        Map<ModuleNode, List<ModuleNode>> publicEdges = deps.stream().filter(e -> e.isPublic()).collect(Collectors.groupingBy(DependencyEdge::getSource, Collectors.mapping(DependencyEdge::getTarget, Collectors.toList())));
        HashSet<DependencyEdge> transitiveEdges = new HashSet<DependencyEdge>();
        for (DependencyEdge dep : deps) {
            List<ModuleNode> targets = publicEdges.get(dep.getTarget());
            if (targets == null) continue;
            ModuleNode source = dep.getSource();
            transitiveEdges.addAll(DependencyCalculator.toDependencyEdges(source, targets));
            HashSet<ModuleNode> transTargets = new HashSet<ModuleNode>();
            this.collectTransTargets(targets, publicEdges, transTargets);
            transitiveEdges.addAll(DependencyCalculator.toDependencyEdges(source, transTargets));
        }
        return transitiveEdges;
    }

    private void collectTransTargets(List<ModuleNode> sources, Map<ModuleNode, List<ModuleNode>> publicEdges, Collection<ModuleNode> transTargets) {
        for (ModuleNode source : sources) {
            List<ModuleNode> targets = publicEdges.get(source);
            if (targets == null) continue;
            LinkedList<ModuleNode> ts = new LinkedList<ModuleNode>();
            for (ModuleNode target : targets) {
                if (transTargets.contains(target)) continue;
                ts.add(target);
            }
            transTargets.addAll(ts);
            this.collectTransTargets(ts, publicEdges, transTargets);
        }
    }

    private static Collection<DependencyEdge> toDependencyEdges(ModuleNode source, Collection<ModuleNode> targets) {
        return targets.stream().map(target -> new DependencyEdge(source, (ModuleNode)target, false, true)).collect(Collectors.toList());
    }

    private static class Dependency {
        final ModuleNode node;
        final boolean unseen;
        final ModuleElement.RequiresDirective reqD;

        public Dependency(ModuleNode node, ModuleElement.RequiresDirective reqD, boolean unseen) {
            this.node = node;
            this.unseen = unseen;
            this.reqD = reqD;
        }

        public String toString() {
            return String.valueOf(this.reqD);
        }
    }
}

