/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.preprocessorbridge.spi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public interface CompileOnSaveAction {
    public Boolean performAction(@NonNull Context var1) throws IOException;

    public boolean isEnabled();

    public boolean isUpdateResources();

    public boolean isUpdateClasses();

    public void addChangeListener(@NonNull ChangeListener var1);

    public void removeChangeListener(@NonNull ChangeListener var1);

    public static interface Provider {
        public CompileOnSaveAction forRoot(@NonNull URL var1);
    }

    public static final class Context {
        private final Operation operation;
        private final URL srcRoot;
        private final boolean isCopyResources;
        private final boolean isKeepResourcesUpToDate;
        private final File cacheRoot;
        private final Iterable<? extends File> updated;
        private final Iterable<? extends File> deleted;
        private final Object owner;
        private final Consumer<Iterable<File>> firer;

        private Context(@NonNull Operation operation, @NonNull URL srcRoot, boolean isCopyResources, boolean isKeepResourcesUpToDate, @NullAllowed File cacheRoot, @NullAllowed Iterable<? extends File> updated, @NullAllowed Iterable<? extends File> deleted, @NullAllowed Object owner, @NullAllowed Consumer<Iterable<File>> firer) {
            this.operation = operation;
            this.srcRoot = srcRoot;
            this.isCopyResources = isCopyResources;
            this.isKeepResourcesUpToDate = isKeepResourcesUpToDate;
            this.cacheRoot = cacheRoot;
            this.updated = updated;
            this.deleted = deleted;
            this.owner = owner;
            this.firer = firer;
        }

        @NonNull
        public Operation getOperation() {
            return this.operation;
        }

        @NonNull
        public Iterable<? extends File> getUpdated() {
            if (this.operation != Operation.UPDATE) {
                throw new IllegalStateException();
            }
            return this.updated;
        }

        @NonNull
        public Iterable<? extends File> getDeleted() {
            if (this.operation != Operation.UPDATE) {
                throw new IllegalStateException();
            }
            return this.deleted;
        }

        public boolean isCopyResources() {
            if (this.operation == Operation.CLEAN) {
                throw new IllegalStateException();
            }
            return this.isCopyResources;
        }

        public boolean isKeepResourcesUpToDate() {
            if (this.operation != Operation.SYNC) {
                throw new IllegalStateException();
            }
            return this.isKeepResourcesUpToDate;
        }

        @NonNull
        public URL getSourceRoot() {
            return this.srcRoot;
        }

        @NonNull
        public File getCacheRoot() {
            if (this.operation != Operation.UPDATE) {
                throw new IllegalStateException();
            }
            return this.cacheRoot;
        }

        @CheckForNull
        public File getTarget() {
            return Context.getTarget(this.srcRoot);
        }

        @CheckForNull
        public URL getTargetURL() {
            return Context.getTargetURL(this.srcRoot);
        }

        @NonNull
        public Object getOwner() {
            if (this.operation != Operation.SYNC) {
                throw new IllegalStateException();
            }
            return this.owner;
        }

        public void filesUpdated(@NonNull Iterable<File> updatedFiles) {
            if (this.firer != null) {
                this.firer.accept(updatedFiles);
            }
        }

        @NonNull
        public static Context clean(@NonNull URL srcRoot) {
            Parameters.notNull((CharSequence)"srcRoot", (Object)srcRoot);
            return new Context(Operation.CLEAN, srcRoot, false, false, null, null, null, null, null);
        }

        @NonNull
        public static Context update(@NonNull URL srcRoot, boolean isCopyResources, @NonNull File cacheRoot, @NonNull Iterable<? extends File> updated, @NonNull Iterable<? extends File> deleted, @NullAllowed Consumer<Iterable<File>> firer) {
            Parameters.notNull((CharSequence)"srcRoot", (Object)srcRoot);
            Parameters.notNull((CharSequence)"cacheRoot", (Object)cacheRoot);
            Parameters.notNull((CharSequence)"updated", updated);
            Parameters.notNull((CharSequence)"deleted", deleted);
            return new Context(Operation.UPDATE, srcRoot, isCopyResources, false, cacheRoot, updated, deleted, null, firer);
        }

        @NonNull
        public static Context sync(@NonNull URL srcRoot, boolean isCopyResources, boolean isKeepResourcesUpToDate, @NonNull Object owner) {
            Parameters.notNull((CharSequence)"srcRoot", (Object)srcRoot);
            Parameters.notNull((CharSequence)"owner", (Object)owner);
            return new Context(Operation.SYNC, srcRoot, isCopyResources, isKeepResourcesUpToDate, null, null, null, owner, null);
        }

        @CheckForNull
        public static File getTarget(@NonNull URL srcRoot) {
            BinaryForSourceQuery.Result binaryRoots = BinaryForSourceQuery.findBinaryRoots((URL)srcRoot);
            File result = null;
            for (URL u : binaryRoots.getRoots()) {
                assert (u != null) : "Null in BinaryForSourceQuery.Result.roots: " + binaryRoots;
                if (u == null) continue;
                File f = FileUtil.archiveOrDirForURL((URL)u);
                try {
                    if (FileUtil.isArchiveFile((URL)BaseUtilities.toURI((File)f).toURL())) continue;
                    if (f != null && result != null) {
                        Logger.getLogger(CompileOnSaveAction.class.getName()).log(Level.WARNING, "More than one binary directory for root: {0}", srcRoot.toExternalForm());
                        return null;
                    }
                    result = f;
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return result;
        }

        @CheckForNull
        public static URL getTargetURL(@NonNull URL srcRoot) {
            BinaryForSourceQuery.Result binaryRoots = BinaryForSourceQuery.findBinaryRoots((URL)srcRoot);
            URL result = null;
            for (URL u : binaryRoots.getRoots()) {
                assert (u != null) : "Null in BinaryForSourceQuery.Result.roots: " + binaryRoots;
                if (u == null || !"file".equals(u.getProtocol())) continue;
                if (result != null) {
                    Logger.getLogger(CompileOnSaveAction.class.getName()).log(Level.WARNING, "More than one binary directory for root: {0}", srcRoot.toExternalForm());
                    return null;
                }
                result = u;
            }
            return result;
        }
    }

    public static enum Operation {
        CLEAN,
        UPDATE,
        SYNC;

    }
}

