/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.input;

import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.input.RobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;

public class MouseRobotDriver
extends RobotDriver
implements MouseDriver {
    public MouseRobotDriver(Timeout autoDelay) {
        super(autoDelay);
    }

    public MouseRobotDriver(Timeout autoDelay, boolean smooth) {
        super(autoDelay, smooth);
    }

    public MouseRobotDriver(Timeout autoDelay, String[] supported) {
        super(autoDelay, supported);
    }

    public MouseRobotDriver(Timeout autoDelay, String[] supported, boolean smooth) {
        super(autoDelay, supported, smooth);
    }

    @Override
    public void pressMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
        this.pressMouse(mouseButton, modifiers);
    }

    @Override
    public void releaseMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
        this.releaseMouse(mouseButton, modifiers);
    }

    @Override
    public void moveMouse(ComponentOperator oper, int x, int y) {
        this.moveMouse(this.getAbsoluteX(oper, x), this.getAbsoluteY(oper, y));
    }

    @Override
    public void clickMouse(ComponentOperator oper, int x, int y, int clickCount, int mouseButton, int modifiers, Timeout mouseClick) {
        this.clickMouse(this.getAbsoluteX(oper, x), this.getAbsoluteY(oper, y), clickCount, mouseButton, modifiers, mouseClick);
    }

    @Override
    public void dragMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
        this.moveMouse(this.getAbsoluteX(oper, x), this.getAbsoluteY(oper, y));
    }

    @Override
    public void dragNDrop(ComponentOperator oper, int start_x, int start_y, int end_x, int end_y, int mouseButton, int modifiers, Timeout before, Timeout after) {
        this.dragNDrop(this.getAbsoluteX(oper, start_x), this.getAbsoluteY(oper, start_y), this.getAbsoluteX(oper, end_x), this.getAbsoluteY(oper, end_y), mouseButton, modifiers, before, after);
    }

    @Override
    public void enterMouse(ComponentOperator oper) {
        this.moveMouse(oper, oper.getCenterXForClick(), oper.getCenterYForClick());
    }

    @Override
    public void exitMouse(ComponentOperator oper) {
    }

    protected int getAbsoluteX(ComponentOperator oper, int x) {
        return oper.getSource().getLocationOnScreen().x + x;
    }

    protected int getAbsoluteY(ComponentOperator oper, int y) {
        return oper.getSource().getLocationOnScreen().y + y;
    }
}

