/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.htmlui;

import java.awt.EventQueue;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import org.netbeans.modules.maven.htmlui.ArchetypeData;
import org.netbeans.modules.maven.htmlui.Bundle;
import org.netbeans.modules.maven.htmlui.Device;
import org.netbeans.modules.maven.htmlui.DeviceType;
import org.netbeans.modules.maven.htmlui.MavenUtilities;
import org.netbeans.modules.maven.htmlui.WizardData;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.RequestProcessor;

public class DukeScriptWizard {
    private static final RequestProcessor DEVICES = new RequestProcessor("List iOS Devices");

    public static WizardData javafxWebViewAppWizard() {
        WizardData data = new WizardData();
        data.init(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        return data;
    }

    static void init(WizardData data, Boolean android, Boolean ios, Boolean web, Boolean netbeans) {
        File nbHome = new File(System.getProperty("netbeans.home"));
        data.setNbhome(nbHome.getParent());
        ArchetypeData koArch = new ArchetypeData("knockout4j-archetype", "com.dukescript.archetype", true, "0.20", "Basic DukeScript Template", "Default skeletal application", null, new String[0]);
        data.setArchetype(koArch);
        data.getArchetypes().add(koArch);
        ArchetypeData crudArch = new ArchetypeData("crud4j-archetype", "com.dukescript.archetype", false, "0.20", "DukeScript CRUD Template", "Client-Server Application demonstrating communication and reuse of DataModels", null, new String[0]);
        data.getArchetypes().add(crudArch);
        data.setIosMoe(true);
        String srvPath = Boolean.getBoolean("staging.archetypes") ? "stage" : "archetypes";
        data.loadArchetypes(srvPath);
        data.setAndroidSdkPath(MavenUtilities.getDefault().readAndroidSdkPath());
    }

    static String archetypeGroupId(ArchetypeData archetype) {
        return archetype == null ? null : archetype.getGroupId();
    }

    static String archetypeArtifactId(ArchetypeData archetype) {
        return archetype == null ? null : archetype.getArtifactId();
    }

    static String archetypeVersion(ArchetypeData archetype) {
        return archetype == null ? null : archetype.getVersion();
    }

    static String archetypeOpen(ArchetypeData archetype) {
        StringBuilder sb = new StringBuilder();
        if (archetype != null) {
            for (String item : archetype.getOpen()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(item);
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    static String webpath(boolean web) {
        return web ? "client-web" : null;
    }

    static String androidpath(boolean android) {
        return android ? "client-android" : null;
    }

    static String iospath(boolean iosRoboVM) {
        return iosRoboVM ? "client-ios" : null;
    }

    static String moepath(boolean iosMoe) {
        return iosMoe ? "client-moe" : null;
    }

    static String netbeanspath(boolean netbeans) {
        return netbeans ? "client-netbeans" : null;
    }

    static String example(boolean installExample) {
        return Boolean.toString(installExample);
    }

    static int errorCode(String current, boolean android, String androidSdkPath, boolean netbeans, boolean nbInstallationDefined, boolean ios, boolean iosMoe, boolean iosRoboVM, Device selectedSimulator, String warning) {
        if (android && "platforms".equals(current)) {
            if (androidSdkPath == null) {
                return 7;
            }
            if (!DukeScriptWizard.isValidAndroidSdk(new File(androidSdkPath))) {
                return 7;
            }
        }
        if (netbeans && "platforms".equals(current) && !nbInstallationDefined) {
            return 8;
        }
        if (warning != null) {
            return 6;
        }
        if (ios) {
            if (!iosMoe && !iosRoboVM) {
                return 3;
            }
            if (selectedSimulator == null || MavenUtilities.getDefault().readMoeDevice() == null) {
                return 4;
            }
        }
        return 0;
    }

    static void cleanWarning(WizardData data) {
        data.setWarning(null);
    }

    static void chooseAndroidSDK(final WizardData data) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser fc;
                int res;
                FileChooserBuilder b = new FileChooserBuilder(WizardData.class).setSelectionApprover(new FileChooserBuilder.SelectionApprover(){

                    public boolean approve(File[] files) {
                        if (files.length != 1) {
                            return false;
                        }
                        return DukeScriptWizard.isValidAndroidSdk(files[0]);
                    }
                }).setDirectoriesOnly(true);
                if (data.getAndroidSdkPath() != null) {
                    b.setDefaultWorkingDirectory(new File(data.getAndroidSdkPath()));
                }
                if ((res = (fc = b.createFileChooser()).showOpenDialog(null)) == 0) {
                    data.setAndroidSdkPath(fc.getSelectedFile().getPath());
                    MavenUtilities.getDefault().writeAndroidSdkPath(fc.getSelectedFile().getPath());
                }
            }
        });
    }

    private static boolean isValidAndroidSdk(File dir) {
        return new File(new File(dir, "platform-tools"), "adb.exe").exists() || new File(new File(dir, "platform-tools"), "adb").exists();
    }

    static void verifyNbInstallationDefined(WizardData data) {
        boolean ok = !data.isNetbeans() || MavenUtilities.getDefault().readNetBeansInstallation() != null;
        data.setNbInstallationDefined(ok);
    }

    static void deviceSelected(WizardData data) {
        if (data.getSelectedSimulator() != null) {
            MavenUtilities.getDefault().writeMoeDevice(data.getSelectedSimulator().getId());
            String name = data.getSelectedSimulator().getName().replaceAll("\\(.*\\)", "").trim();
            MavenUtilities.getDefault().writeRobovmDeviceName(name);
        }
    }

    static void verifySimulator(WizardData data) {
        List<Device> arr = data.getAvailableSimulators();
        DEVICES.post(() -> {
            DeviceType.listDevices(arr);
            String selectedDevice = MavenUtilities.getDefault().readMoeDevice();
            Iterator it = arr.iterator();
            while (it.hasNext()) {
                Device d = (Device)it.next();
                if (d.getType() != DeviceType.SIMULATOR) {
                    if (d.getType() == null) {
                        data.setWarning(d.getInfo());
                    }
                    it.remove();
                    continue;
                }
                if (selectedDevice == null || !selectedDevice.equals(d.getId())) continue;
                data.setSelectedSimulator(d);
            }
        });
    }

    static void defineNbInstallation(final WizardData data) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChooserBuilder b = new FileChooserBuilder(WizardData.class).setSelectionApprover(new FileChooserBuilder.SelectionApprover(){

                    public boolean approve(File[] files) {
                        if (files.length != 1) {
                            return false;
                        }
                        File platform = new File(files[0], "platform");
                        File lib = new File(platform, "lib");
                        File bootJar = new File(lib, "boot.jar");
                        return bootJar.exists();
                    }
                }).setDirectoriesOnly(true);
                JFileChooser fc = b.createFileChooser();
                File f = new File(System.getProperty("netbeans.home"));
                fc.setCurrentDirectory(f);
                int res = fc.showOpenDialog(null);
                if (res == 0) {
                    MavenUtilities.getDefault().writeNetBeansInstallation(f.getParent());
                    if (MavenUtilities.getDefault().readNetBeansInstallation() != null) {
                        data.setNbInstallationDefined(true);
                    }
                }
            }
        });
    }

    static void loadArchetypes(WizardData model, List<ArchetypeData> found) {
        if (!found.isEmpty()) {
            ArchetypeData first = found.get(0);
            if (first == null || first.getName() == null) {
                model.setWarning(Bundle.ERR_NoData());
                return;
            }
            model.getArchetypes().clear();
            model.getArchetypes().addAll(found);
            model.setArchetype(first);
        }
    }

    static void loadError(WizardData model, Throwable t) {
        model.setWarning(Bundle.ERR_NoNetwork(t.getLocalizedMessage()));
    }

    static class ArchetypeViewModel {
        ArchetypeViewModel() {
        }
    }
}

