/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.ModuleLogicalView;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SourcesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        NbModuleProject prj = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
        return new SourceNL(prj);
    }

    private static class SourceNL
    implements NodeList<SourceGroup>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private static final String[] SOURCE_GROUP_TYPES = new String[]{"java", "javahelp"};
        private final NbModuleProject project;

        SourceNL(NbModuleProject prj) {
            this.project = prj;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public void addNotify() {
            ProjectUtils.getSources((Project)this.project).addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            ProjectUtils.getSources((Project)this.project).removeChangeListener((ChangeListener)this);
        }

        public Node node(SourceGroup key) {
            return PackageView.createPackageView((SourceGroup)key);
        }

        public List<SourceGroup> keys() {
            ArrayList<SourceGroup> l = new ArrayList<SourceGroup>();
            Sources s = ProjectUtils.getSources((Project)this.project);
            for (int i = 0; i < SOURCE_GROUP_TYPES.length; ++i) {
                SourceGroup[] groups = s.getSourceGroups(SOURCE_GROUP_TYPES[i]);
                l.addAll(Arrays.asList(groups));
            }
            SourceGroup javadocDocfiles = this.makeJavadocDocfilesSourceGroup();
            if (javadocDocfiles != null) {
                l.add(javadocDocfiles);
            }
            return l;
        }

        private SourceGroup makeJavadocDocfilesSourceGroup() {
            String propname = "javadoc.docfiles";
            FileObject root = this.resolveFileObjectFromProperty(propname);
            if (root == null) {
                return null;
            }
            return GenericSources.group((Project)this.project, (FileObject)root, (String)propname, (String)NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_extra_javadoc_files"), null, null);
        }

        private FileObject resolveFileObjectFromProperty(String property) {
            String filename = this.project.evaluator().getProperty(property);
            if (filename == null) {
                return null;
            }
            return this.project.getHelper().resolveFileObject(filename);
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            this.changeSupport.fireChange();
        }
    }
}

