/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.ExecProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.Bundle;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.Lookups;

public final class ModuleActions
implements ActionProvider,
ExecProject {
    private static final String RUN_ARGS_IDE = "run.args.ide";
    private static final String COMMAND_NBM = "nbm";
    private static final String MODULE_ACTIONS_TYPE = "org-netbeans-modules-apisupport-project";
    private static final String MODULE_ACTIONS_PATH = "Projects/org-netbeans-modules-apisupport-project/Actions";
    private static final RequestProcessor RP = new RequestProcessor(ModuleActions.class);
    private final NbModuleProject project;
    private final Map<String, String[]> globalCommands = new HashMap<String, String[]>();
    private String[] supportedActions = null;
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";
    private static final String SUBSTNG = "NGTest.java";
    private static final String SYSTEM_PROPERTY_PREFIX = "test-unit-sys-prop.";

    public Task execute(String ... args) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String r : args) {
            sb.append(r).append(' ');
        }
        Properties p = new Properties();
        p.setProperty("run.args", sb.substring(0, sb.length() - 1));
        return ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(this.project), (String[])new String[]{"run"}, (Properties)p);
    }

    static Action[] getProjectActions(NbModuleProject project) {
        return CommonProjectActions.forType((String)MODULE_ACTIONS_TYPE);
    }

    public ModuleActions(NbModuleProject project) {
        this.project = project;
        this.refresh();
    }

    public void refresh() {
        HashSet<String> supportedActionsSet = new HashSet<String>();
        this.globalCommands.put("build", new String[]{"netbeans"});
        this.globalCommands.put("clean", new String[]{"clean"});
        if ("mkleint".equals(System.getProperty("user.name"))) {
            this.globalCommands.put("rebuild", new String[]{"clean", "netbeans", "do-test-build"});
        } else {
            this.globalCommands.put("rebuild", new String[]{"clean", "netbeans"});
        }
        this.globalCommands.put("run", new String[]{"run"});
        this.globalCommands.put("debug", new String[]{"debug"});
        this.globalCommands.put("profile", new String[]{"profile"});
        this.globalCommands.put("javadoc", new String[]{"javadoc-nb"});
        this.globalCommands.put("test", new String[]{"test-unit"});
        this.globalCommands.put(COMMAND_NBM, new String[]{COMMAND_NBM});
        supportedActionsSet.addAll(this.globalCommands.keySet());
        supportedActionsSet.add("compile.single");
        supportedActionsSet.add("debug.fix");
        if (!this.project.supportedTestTypes().isEmpty()) {
            supportedActionsSet.add("test.single");
            supportedActionsSet.add("debug.test.single");
            supportedActionsSet.add("profile.test.single");
            supportedActionsSet.add("run.single");
            supportedActionsSet.add("debug.single");
            supportedActionsSet.add("profile.single");
            supportedActionsSet.add("run.single.method");
            supportedActionsSet.add("debug.single.method");
        }
        supportedActionsSet.add("rename");
        supportedActionsSet.add("move");
        supportedActionsSet.add("copy");
        supportedActionsSet.add("delete");
        this.supportedActions = supportedActionsSet.toArray(new String[supportedActionsSet.size()]);
    }

    public String[] getSupportedActions() {
        return this.supportedActions;
    }

    private static FileObject findBuildXml(NbModuleProject project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if ("delete".equals(command) || "rename".equals(command) || "move".equals(command) || "copy".equals(command)) {
            return true;
        }
        if (ModuleActions.findBuildXml(this.project) == null) {
            return false;
        }
        if (command.equals("compile.single")) {
            return this.findSources(context) != null || this.findTestSources(context, true) != null;
        }
        if (command.equals("test")) {
            return this.project.supportedTestTypes().contains("unit");
        }
        if (command.equals("test.single")) {
            return this.findTestSourcesForSources(context) != null || this.findTestSources(context, true) != null || this.findTestSourcesForFiles(context) != null;
        }
        if (command.equals("debug.test.single")) {
            TestSources testSources = this.findTestSourcesForSources(context);
            if (testSources == null) {
                testSources = this.findTestSources(context, false);
            }
            return testSources != null && testSources.isSingle();
        }
        if (command.equals("profile.test.single")) {
            TestSources testSources = this.findTestSourcesForSources(context);
            if (testSources == null) {
                testSources = this.findTestSources(context, false);
            }
            return testSources != null && testSources.isSingle();
        }
        if (command.equals("run.single")) {
            return this.findTestSources(context, false) != null;
        }
        if (command.equals("debug.single")) {
            TestSources testSources = this.findTestSources(context, false);
            return testSources != null && testSources.isSingle();
        }
        if (command.equals("profile.single")) {
            TestSources testSources = this.findTestSources(context, false);
            return testSources != null && testSources.isSingle();
        }
        if (command.equals("run.single.method") || command.equals("debug.single.method")) {
            NbPlatform plaf = this.project.getPlatform(false);
            if (plaf == null || plaf.getHarnessVersion().compareTo(HarnessVersion.V70) < 0) {
                return false;
            }
            return this.findTestMethodSources(context) != null;
        }
        if (command.equals("debug.fix")) {
            FileObject[] files = this.findSources(context);
            if (files != null && files.length == 1) {
                return true;
            }
            TestSources testSources = this.findTestSources(context, false);
            return testSources != null && testSources.isSingle();
        }
        return true;
    }

    private FileObject[] findSources(Lookup context) {
        return this.findSources(context, false, true);
    }

    private FileObject[] findSources(Lookup context, boolean findInPackages, boolean strict) {
        FileObject srcDir = this.project.getSourceDirectory();
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)(findInPackages ? null : ".java"), (boolean)strict);
            return files;
        }
        return null;
    }

    @CheckForNull
    TestSources findTestSources(@NonNull Lookup context, boolean allowFolders) {
        block0: for (String testType : this.project.supportedTestTypes()) {
            FileObject[] files;
            FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
            if (testSrcDir == null || (files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcDir, null, (boolean)true)) == null) continue;
            for (FileObject file : files) {
                if (!file.hasExt("java") && (!allowFolders || !file.isFolder())) break block0;
            }
            return new TestSources(files, testType, testSrcDir, null);
        }
        return null;
    }

    @CheckForNull
    private FileObject[] findTestSourcesFOs(@NonNull Lookup context, boolean allowFolders, boolean strict) {
        block0: for (String testType : this.project.supportedTestTypes()) {
            FileObject[] files;
            FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
            if (testSrcDir == null || (files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcDir, null, (boolean)strict)) == null) continue;
            for (FileObject file : files) {
                if (!file.hasExt("java") && (!allowFolders || !file.isFolder())) break block0;
            }
            return files;
        }
        return null;
    }

    @CheckForNull
    private TestSources findTestMethodSources(@NonNull Lookup context) {
        SingleMethod meth = (SingleMethod)context.lookup(SingleMethod.class);
        if (meth != null) {
            FileObject file = meth.getFile();
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null || !FileUtil.isParentOf((FileObject)testSrcDir, (FileObject)file)) continue;
                return new TestSources(new FileObject[]{file}, testType, testSrcDir, meth.getMethodName());
            }
        }
        return null;
    }

    private String getMainClass(Lookup context) {
        FileObject f;
        Collection mcs;
        FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, null, (String)".java", (boolean)true);
        if (files.length == 1 && (mcs = SourceUtils.getMainClasses((FileObject)(f = files[0]))).size() > 0) {
            ElementHandle h = (ElementHandle)mcs.iterator().next();
            String qname = h.getQualifiedName();
            return qname;
        }
        return null;
    }

    TestSources findTestSourcesForSources(Lookup context) {
        String testType = "unit";
        FileObject[] sourceFiles = this.findSources(context);
        if (sourceFiles == null && (sourceFiles = this.findSources(context, true, true)) == null) {
            return null;
        }
        FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
        if (testSrcDir == null) {
            return null;
        }
        FileObject srcDir = this.project.getSourceDirectory();
        FileObject[] matches = ActionUtils.regexpMapFiles((FileObject[])sourceFiles, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcDir, (String)SUBST, (boolean)true);
        if (matches != null) {
            return new TestSources(matches, testType, testSrcDir, null);
        }
        matches = ActionUtils.regexpMapFiles((FileObject[])sourceFiles, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcDir, (String)SUBSTNG, (boolean)true);
        if (matches != null) {
            return new TestSources(matches, testType, testSrcDir, null);
        }
        ArrayList<FileObject> testFOs = new ArrayList<FileObject>();
        for (FileObject file : sourceFiles) {
            FileObject testFO;
            String relativePath;
            if (!file.isFolder() || (relativePath = FileUtil.getRelativePath((FileObject)srcDir, (FileObject)file)) == null || relativePath.isEmpty() || (testFO = FileUtil.toFileObject((File)new File(FileUtil.toFile((FileObject)testSrcDir).getPath().concat(File.separator).concat(relativePath)))) == null || testFO.getChildren().length == 0) continue;
            testFOs.add(testFO);
        }
        if (testFOs.isEmpty()) {
            return null;
        }
        return new TestSources(testFOs.toArray(new FileObject[testFOs.size()]), testType, testSrcDir, null);
    }

    @CheckForNull
    TestSources findTestSourcesForFiles(Lookup context) {
        FileObject[] files2NG;
        String testType = "unit";
        FileObject[] sourcesFOs = this.findSources(context, false, false);
        FileObject[] testSourcesFOs = this.findTestSourcesFOs(context, false, false);
        HashSet<FileObject> testFiles = new HashSet<FileObject>();
        FileObject testRoot = this.project.getTestSourceDirectory(testType);
        if (testRoot == null) {
            return null;
        }
        if (testSourcesFOs == null) {
            return this.findTestSources(context, true);
        }
        if (sourcesFOs == null) {
            return this.findTestSources(context, false);
        }
        testFiles.addAll(Arrays.asList(testSourcesFOs));
        FileObject srcRoot = this.project.getSourceDirectory();
        FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])sourcesFOs, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testRoot, (String)SUBST, (boolean)true);
        if (files2 != null) {
            for (FileObject fo : files2) {
                if (testFiles.contains(fo)) continue;
                testFiles.add(fo);
            }
        }
        if ((files2NG = ActionUtils.regexpMapFiles((FileObject[])sourcesFOs, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testRoot, (String)SUBSTNG, (boolean)true)) != null) {
            for (FileObject fo : files2NG) {
                if (testFiles.contains(fo)) continue;
                testFiles.add(fo);
            }
        }
        return testFiles.isEmpty() ? null : new TestSources(testFiles.toArray(new FileObject[testFiles.size()]), testType, testRoot, null);
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if (!ModuleActions.canRunNoLock(command, this.project.getTestUserDirLockFile())) {
            return;
        }
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if (!ModuleActions.verifySufficientlyNewHarness(this.project)) {
            return;
        }
        final ActionProgress listener = ActionProgress.start((Lookup)context);
        Runnable runnable = new Runnable(){
            ExecutorTask task;

            @Override
            public void run() {
                block5: {
                    block4: {
                        try {
                            this.doRun();
                            if (this.task == null) break block4;
                        }
                        catch (Throwable throwable) {
                            if (this.task != null) {
                                this.task.addTaskListener(new TaskListener(){

                                    public void taskFinished(Task _) {
                                        listener.finished(task.result() == 0);
                                    }
                                });
                            } else {
                                listener.finished(false);
                            }
                            throw throwable;
                        }
                        this.task.addTaskListener(new /* invalid duplicate definition of identical inner class */);
                        break block5;
                    }
                    listener.finished(false);
                }
            }

            void doRun() {
                TestSources testSources;
                String[] targetNames;
                FileObject[] files;
                Properties p = new Properties();
                if (command.equals("compile.single")) {
                    files = ModuleActions.this.findSources(context);
                    if (files != null) {
                        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)ModuleActions.this.project.getSourceDirectory()));
                        targetNames = new String[]{"compile-single"};
                    } else {
                        TestSources testSources2 = ModuleActions.this.findTestSources(context, true);
                        p.setProperty("javac.includes", testSources2.includes());
                        p.setProperty("test.type", testSources2.testType);
                        targetNames = new String[]{"compile-test-single"};
                    }
                } else if (command.equals("test.single")) {
                    testSources = ModuleActions.this.findTestSourcesForSources(context);
                    if (testSources == null && (testSources = ModuleActions.this.findTestSources(context, true)) == null) {
                        testSources = ModuleActions.this.findTestSourcesForFiles(context);
                    }
                    p.setProperty("continue.after.failing.tests", "true");
                    targetNames = ModuleActions.this.setupTestSingle(p, testSources);
                } else if (command.equals("debug.test.single")) {
                    testSources = ModuleActions.this.findTestSourcesForSources(context);
                    if (testSources == null) {
                        testSources = ModuleActions.this.findTestSources(context, false);
                    }
                    targetNames = ModuleActions.this.setupDebugTestSingle(p, testSources);
                } else if (command.equals("profile.test.single")) {
                    testSources = ModuleActions.this.findTestSourcesForSources(context);
                    if (testSources == null) {
                        testSources = ModuleActions.this.findTestSources(context, false);
                    }
                    targetNames = ModuleActions.this.setupProfileTestSingle(p, testSources);
                } else if (command.equals("run.single")) {
                    testSources = ModuleActions.this.findTestSources(context, false);
                    String clazz = ModuleActions.this.getMainClass(context);
                    if (clazz != null) {
                        targetNames = ModuleActions.this.setupRunMain(p, testSources, context, clazz);
                    } else {
                        p.setProperty("continue.after.failing.tests", "true");
                        targetNames = ModuleActions.this.setupTestSingle(p, testSources);
                    }
                } else if (command.equals("debug.single")) {
                    testSources = ModuleActions.this.findTestSources(context, false);
                    String clazz = ModuleActions.this.getMainClass(context);
                    targetNames = clazz != null ? ModuleActions.this.setupDebugMain(p, testSources, context, clazz) : ModuleActions.this.setupDebugTestSingle(p, testSources);
                } else if (command.equals("profile.single")) {
                    testSources = ModuleActions.this.findTestSources(context, false);
                    String clazz = ModuleActions.this.getMainClass(context);
                    targetNames = clazz != null ? ModuleActions.this.setupProfileMain(p, testSources, context, clazz) : ModuleActions.this.setupProfileTestSingle(p, testSources);
                } else if (command.equals("run.single.method")) {
                    testSources = ModuleActions.this.findTestMethodSources(context);
                    p.setProperty("test.class", ModuleActions.this.testClassName(testSources));
                    p.setProperty("test.type", testSources.testType);
                    p.setProperty("test.methods", testSources.method);
                    p.setProperty("continue.after.failing.tests", "true");
                    targetNames = new String[]{"test-method"};
                } else if (command.equals("debug.single.method")) {
                    testSources = ModuleActions.this.findTestMethodSources(context);
                    p.setProperty("test.class", ModuleActions.this.testClassName(testSources));
                    p.setProperty("test.type", testSources.testType);
                    p.setProperty("test.methods", testSources.method);
                    targetNames = new String[]{"debug-test-single-nb"};
                } else if (command.equals("debug.fix")) {
                    files = ModuleActions.this.findSources(context);
                    String path = null;
                    if (files != null) {
                        path = FileUtil.getRelativePath((FileObject)ModuleActions.this.project.getSourceDirectory(), (FileObject)files[0]);
                        assert (path != null);
                        assert (path.endsWith(".java"));
                        targetNames = new String[]{"debug-fix-nb"};
                    } else {
                        TestSources testSources3 = ModuleActions.this.findTestSources(context, false);
                        if (testSources3 == null) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.MSG_no_source());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            return;
                        }
                        p.setProperty("test.type", testSources3.testType);
                        path = testSources3.includes();
                        assert (path.endsWith(".java"));
                        targetNames = new String[]{"debug-fix-test-nb"};
                    }
                    String clazzSlash = path.substring(0, path.length() - 5);
                    p.setProperty("fix.class", clazzSlash);
                } else {
                    if (command.equals("javadoc") && !ModuleActions.this.project.supportsJavadoc()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ModuleActions.this.promptForPublicPackagesToDocument();
                            }
                        });
                        return;
                    }
                    if (command.equals("rebuild")) {
                        p.setProperty("do.not.clean.module.config.xml", "true");
                    }
                    p.setProperty("continue.after.failing.tests", "true");
                    targetNames = (String[])ModuleActions.this.globalCommands.get(command);
                    if (targetNames == null) {
                        throw new IllegalArgumentException(command);
                    }
                }
                try {
                    ModuleActions.setRunArgsIde(ModuleActions.this.project, ModuleActions.this.project.evaluator(), command, p);
                    this.task = ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(ModuleActions.this.project), (String[])targetNames, (Properties)p);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
        RP.post(runnable);
    }

    static boolean canRunNoLock(String command, File lock) {
        if (command.equals("run") || command.equals("debug") || command.equals("profile")) {
            if (ModuleActions.isLocked(lock)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_module_already_running()));
                return false;
            }
        } else if (("delete".equals(command) || "rename".equals(command) || "move".equals(command) || "copy".equals(command)) && ModuleActions.isLocked(lock)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_ModuleIsBeingRun()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isLocked(File file) {
        if (!file.exists()) {
            return false;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            FileLock lock = raf.getChannel().tryLock();
            if (lock == null) {
                boolean bl = true;
                return bl;
            }
            lock.release();
            boolean bl = false;
            return bl;
        }
        catch (IOException x) {
            return true;
        }
        catch (OverlappingFileLockException x) {
            return true;
        }
    }

    private String[] setupProfileTestSingle(Properties p, TestSources testSources) {
        p.setProperty("test.includes", testSources.includes().replace("**", "**/*Test.java"));
        p.setProperty("test.type", testSources.testType);
        return new String[]{"profile-test-single-nb"};
    }

    static void setRunArgsIde(Project project, PropertyEvaluator eval, String command, Properties p) {
        boolean isTest;
        StringBuilder runArgsIde = new StringBuilder();
        boolean isOsgi = command.equals("profile-osgi");
        Object mode = command.equals("run") || command.equals("run.single") ? StartupExtender.StartMode.NORMAL : (command.equals("debug") || command.equals("debug.single") || command.equals("debug.stepinto") ? StartupExtender.StartMode.DEBUG : (command.equals("profile") || command.equals("profile.single") || command.equals("profile-osgi") ? StartupExtender.StartMode.PROFILE : (command.equals("test") || command.equals("test.single") ? StartupExtender.StartMode.TEST_NORMAL : (command.equals("debug.test.single") ? StartupExtender.StartMode.TEST_DEBUG : (command.equals("profile.test.single") ? StartupExtender.StartMode.TEST_PROFILE : null)))));
        boolean bl = isTest = EnumSet.of(StartupExtender.StartMode.TEST_PROFILE, StartupExtender.StartMode.TEST_NORMAL, StartupExtender.StartMode.TEST_DEBUG).contains(mode) || command.equals("profile.single");
        if (mode != null) {
            JavaPlatform plaf = ModuleProperties.getJavaPlatform(eval);
            Lookup context = Lookups.fixed((Object[])new Object[]{project, plaf != null ? plaf : JavaPlatformManager.getDefault().getDefaultPlatform()});
            for (StartupExtender group : StartupExtender.getExtenders((Lookup)context, (StartupExtender.StartMode)mode)) {
                for (String arg : group.getArguments()) {
                    runArgsIde.append(isTest | isOsgi ? "" : "-J").append(arg).append(' ');
                }
            }
        }
        if (runArgsIde.length() > 0) {
            p.setProperty(RUN_ARGS_IDE, runArgsIde.toString());
        }
    }

    private void promptForPublicPackagesToDocument() {
        if (ApisupportAntUIUtils.showAcceptCancelDialog(Bundle.TITLE_javadoc_disabled(), Bundle.ERR_javadoc_disabled(), Bundle.LBL_configure_pubpkg(), null, 2)) {
            CustomizerProviderImpl cpi = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            cpi.showCustomizer("Versioning", "publicPackages");
        }
    }

    private boolean hasTestUnitDataDir() {
        String dataDir = this.project.evaluator().getProperty("test.unit.data.dir");
        return dataDir != null && this.project.getHelper().resolveFileObject(dataDir) != null;
    }

    private void prepareSystemProperties(Map<String, Object> properties) {
        Map evaluated = this.project.evaluator().getProperties();
        if (evaluated == null) {
            return;
        }
        for (Map.Entry e : evaluated.entrySet()) {
            if (!((String)e.getKey()).startsWith(SYSTEM_PROPERTY_PREFIX) || e.getValue() == null) continue;
            LinkedList<String> systemProperties = (LinkedList<String>)properties.get("run.jvmargs");
            if (systemProperties == null) {
                systemProperties = new LinkedList<String>();
                properties.put("run.jvmargs", systemProperties);
            }
            systemProperties.add("-D" + ((String)e.getKey()).substring(SYSTEM_PROPERTY_PREFIX.length()) + "=" + (String)e.getValue());
        }
    }

    private static boolean verifySufficientlyNewHarness(NbModuleProject project) {
        NbPlatform plaf = project.getPlatform(false);
        if (plaf != null && plaf.getHarnessVersion() != HarnessVersion.UNKNOWN && plaf.getHarnessVersion().compareTo(project.getMinimumHarnessVersion()) < 0) {
            ModuleActions.promptForNewerHarness();
            return false;
        }
        return true;
    }

    static void promptForNewerHarness() {
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)Bundle.ERR_harness_too_old(), 0);
        d.setTitle(Bundle.TITLE_harness_too_old());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private String[] setupTestSingle(Properties p, TestSources testSources) {
        p.setProperty("test.includes", testSources.includes().replace("**", "**/*Test.java"));
        p.setProperty("test.type", testSources.testType);
        return new String[]{"test-single"};
    }

    private String[] setupRunMain(Properties p, TestSources testSources, Lookup context, String mainClass) {
        p.setProperty("main.class", mainClass);
        p.setProperty("test.type", testSources.testType);
        return new String[]{"run-test-main"};
    }

    private String[] setupDebugMain(Properties p, TestSources testSources, Lookup context, String mainClass) {
        p.setProperty("main.class", mainClass);
        p.setProperty("test.type", testSources.testType);
        return new String[]{"debug-test-main-nb"};
    }

    private String[] setupProfileMain(Properties p, TestSources testSources, Lookup context, String mainClass) {
        p.setProperty("main.class", mainClass);
        p.setProperty("test.type", testSources.testType);
        return new String[]{"profile-test-main-nb"};
    }

    private String testClassName(TestSources testSources) {
        String path = testSources.includes();
        assert (path.endsWith(".java") && !path.contains(",")) : path;
        return path.substring(0, path.length() - 5).replace('/', '.');
    }

    private String[] setupDebugTestSingle(Properties p, TestSources testSources) {
        p.setProperty("test.class", this.testClassName(testSources));
        p.setProperty("test.type", testSources.testType);
        return new String[]{"debug-test-single-nb"};
    }

    private boolean bypassAntBuildScript(String command, FileObject[] files, AtomicReference<ExecutorTask> task) throws IllegalArgumentException {
        FileObject toRun = null;
        if ("run.single".equals(command) || "debug.single".equals(command) || "profile.single".equals(command)) {
            toRun = files[0];
        }
        if (toRun != null) {
            String commandToExecute;
            String string = "run.single".equals(command) ? "junit" : (commandToExecute = "debug.single".equals(command) ? "junit-debug" : "junit-profile");
            if (!JavaRunner.isSupported((String)commandToExecute, Collections.singletonMap("execute.file", toRun))) {
                return false;
            }
            try {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                this.prepareSystemProperties(properties);
                properties.put("execute.file", toRun);
                task.set(JavaRunner.execute((String)commandToExecute, properties));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }
        return false;
    }

    public static Action reload() {
        return ModuleActions.reload(false);
    }

    public static Action reloadInIde() {
        return ModuleActions.reload(true);
    }

    private static Action reload(final boolean inIDE) {
        return ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)new ProjectActionPerformer(){

            public boolean enable(Project _project) {
                if (!(_project instanceof NbModuleProject)) {
                    return false;
                }
                NbModuleProject project = (NbModuleProject)_project;
                if (ModuleActions.findBuildXml(project) == null) {
                    return false;
                }
                if (!inIDE) {
                    return project.getTestUserDirLockFile().isFile();
                }
                if (Boolean.parseBoolean(project.evaluator().getProperty("is.autoload")) || Boolean.parseBoolean(project.evaluator().getProperty("is.eager"))) {
                    return false;
                }
                NbModuleType type = project.getModuleType();
                if (type == NbModuleType.NETBEANS_ORG) {
                    return true;
                }
                if (type == NbModuleType.STANDALONE) {
                    NbPlatform p = project.getPlatform(false);
                    return p != null && p.isDefault();
                }
                assert (type == NbModuleType.SUITE_COMPONENT) : type;
                try {
                    SuiteProject suite = SuiteUtils.findSuite(project);
                    if (suite == null) {
                        return false;
                    }
                    NbPlatform p = suite.getPlatform(false);
                    if (p == null || !p.isDefault()) {
                        return false;
                    }
                    return SuiteProperties.getArrayProperty(suite.getEvaluator(), "enabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.modules").length == 0;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                    return false;
                }
            }

            public void perform(Project p) {
                NbModuleProject project = (NbModuleProject)p;
                if (!ModuleActions.verifySufficientlyNewHarness(project)) {
                    return;
                }
                if (inIDE && ModuleUISettings.getDefault().getConfirmReloadInIDE()) {
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)Bundle.LBL_reload_in_ide_confirm(), Bundle.LBL_reload_in_ide_confirm_title(), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                        return;
                    }
                    ModuleUISettings.getDefault().setConfirmReloadInIDE(false);
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])new String[]{inIDE ? "reload-in-ide" : "reload"}, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        }, (String)(inIDE ? Bundle.ACTION_reload_in_ide() : Bundle.ACTION_reload()), null);
    }

    public static Action createNbm() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_NBM, (String)Bundle.ACTION_nbm(), null);
    }

    public static Action arch() {
        return ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)new ProjectActionPerformer(){

            public boolean enable(Project p) {
                if (!(p instanceof NbModuleProject)) {
                    return false;
                }
                NbModuleProject project = (NbModuleProject)p;
                return ModuleActions.findBuildXml(project) != null;
            }

            public void perform(Project p) {
                final NbModuleProject project = (NbModuleProject)p;
                if (!ModuleActions.verifySufficientlyNewHarness(project)) {
                    return;
                }
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        String prop = "javadoc.arch";
                        if (project.evaluator().getProperty(prop) == null) {
                            EditableProperties props = project.getHelper().getProperties("nbproject/project.properties");
                            props.setProperty(prop, "${basedir}/arch.xml");
                            project.getHelper().putProperties("nbproject/project.properties", props);
                            try {
                                ProjectManager.getDefault().saveProject((Project)project);
                            }
                            catch (IOException e) {
                                Util.err.notify((Throwable)e);
                            }
                        }
                        return null;
                    }
                });
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])new String[]{"arch-nb"}, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        }, (String)Bundle.ACTION_arch(), null);
    }

    static class TestSources {
        @NonNull
        private final FileObject[] sources;
        @NonNull
        final String testType;
        @NonNull
        private final FileObject sourceDirectory;
        @NullAllowed
        final String method;

        TestSources(@NonNull FileObject[] sources, @NonNull String testType, @NonNull FileObject sourceDirectory, String method) {
            this.sources = sources;
            this.testType = testType;
            this.sourceDirectory = sourceDirectory;
            this.method = method;
        }

        boolean isSingle() {
            return this.sources.length == 1;
        }

        @NonNull
        String includes() {
            return ActionUtils.antIncludesList((FileObject[])this.sources, (FileObject)this.sourceDirectory);
        }

        public String toString() {
            return this.testType + ":" + this.includes() + (this.method != null ? "#" + this.method : "");
        }
    }
}

