/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.RequiresTree;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ModuleElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.modules.java.preprocessorbridge.api.ModuleUtilities;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class ModuleClassPaths {
    private static final Logger LOG = Logger.getLogger(ModuleClassPaths.class.getName());
    private static final RequestProcessor CLASS_INDEX_FIRER = new RequestProcessor(ModuleClassPaths.class);
    private static final String MODULE_INFO_JAVA = "module-info.java";

    private ModuleClassPaths() {
        throw new IllegalArgumentException("No instance allowed.");
    }

    @NonNull
    static ClassPathImplementation createModuleInfoBasedPath(@NonNull ClassPath base, @NonNull ClassPath sourceRoots, @NonNull ClassPath systemModules, @NonNull ClassPath userModules, @NullAllowed ClassPath legacyClassPath, @NullAllowed Function<URL, Boolean> filter) {
        Parameters.notNull((CharSequence)"base", (Object)base);
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
        Parameters.notNull((CharSequence)"systemModules", (Object)systemModules);
        Parameters.notNull((CharSequence)"userModules", (Object)userModules);
        if (base != systemModules && base != userModules) {
            throw new IllegalArgumentException("The base must be either systemModules or userModules");
        }
        return new ModuleInfoClassPathImplementation(base, sourceRoots, systemModules, userModules, legacyClassPath != null ? legacyClassPath : ClassPath.EMPTY, filter);
    }

    @NonNull
    static ClassPathImplementation createPlatformModulePath(@NonNull PropertyEvaluator eval, @NonNull String platformType) {
        return new PlatformModulePath(eval, platformType);
    }

    @NonNull
    static ClassPathImplementation createPropertyBasedModulePath(@NonNull File projectDir, @NonNull PropertyEvaluator eval, @NullAllowed Function<URL, Boolean> filter, String ... props) {
        return new PropertyModulePath(projectDir, eval, filter, props);
    }

    @NonNull
    static ClassPathImplementation createMultiModuleBinariesPath(@NonNull MultiModule model, boolean archives, boolean requiresModuleInfo) {
        return new MultiModuleBinaries(model, archives, requiresModuleInfo);
    }

    private static abstract class BaseClassPathImplementation
    implements ClassPathImplementation {
        private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
        private List<PathResourceImplementation> cache;

        BaseClassPathImplementation() {
            this(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BaseClassPathImplementation(List<PathResourceImplementation> initialValue) {
            BaseClassPathImplementation baseClassPathImplementation = this;
            synchronized (baseClassPathImplementation) {
                this.cache = initialValue;
            }
        }

        public final void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.addPropertyChangeListener(listener);
        }

        public final void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removePropertyChangeListener(listener);
        }

        @CheckForNull
        final synchronized List<PathResourceImplementation> getCache() {
            return this.cache;
        }

        final synchronized void setCache(@NullAllowed List<PathResourceImplementation> cache) {
            this.cache = cache;
        }

        final void resetCache(String ... propNames) {
            this.resetCache((List<PathResourceImplementation>)null, propNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void resetCache(@NullAllowed List<PathResourceImplementation> update, String ... propNames) {
            BaseClassPathImplementation baseClassPathImplementation = this;
            synchronized (baseClassPathImplementation) {
                this.cache = update;
            }
            this.fire(propNames);
        }

        final void fire(String ... propNames) {
            for (String pn : propNames) {
                this.listeners.firePropertyChange(pn, null, null);
            }
        }
    }

    private static final class ModuleInfoClassPathImplementation
    extends BaseClassPathImplementation
    implements FlaggedClassPathImplementation,
    PropertyChangeListener,
    ChangeListener,
    FileChangeListener,
    ClassIndexListener {
        private static final String MOD_JAVA_BASE = "java.base";
        private static final String MOD_JAVA_SE = "java.se";
        private static final String MOD_ALL_UNNAMED = "ALL-UNNAMED";
        private static final String JAVA_ = "java.";
        private static final List<PathResourceImplementation> TOMBSTONE = Collections.unmodifiableList(new ArrayList());
        private static final Predicate<ModuleElement> NON_JAVA_PUBEXP = e -> !e.getQualifiedName().toString().startsWith(JAVA_) && e.getDirectives().stream().filter(d -> d.getKind() == ModuleElement.DirectiveKind.EXPORTS).anyMatch(d -> ((ModuleElement.ExportsDirective)d).getTargetModules() == null);
        private final ClassPath base;
        private final ClassPath sources;
        private final ClassPath systemModules;
        private final ClassPath userModules;
        private final ClassPath legacyClassPath;
        private final Function<URL, Boolean> filter;
        private final ThreadLocal<Object[]> selfRes;
        private final AtomicReference<CompilerOptionsQuery.Result> compilerOptions;
        private ClasspathInfo activeProjectSourceRoots;
        private volatile boolean rootsChanging;
        private Collection<File> moduleInfos;
        private volatile boolean incomplete;

        ModuleInfoClassPathImplementation(@NonNull ClassPath base, @NonNull ClassPath sources, @NonNull ClassPath systemModules, @NonNull ClassPath userModules, @NonNull ClassPath legacyClassPath, @NullAllowed Function<URL, Boolean> filter) {
            super(null);
            Parameters.notNull((CharSequence)"base", (Object)base);
            Parameters.notNull((CharSequence)"sources", (Object)sources);
            Parameters.notNull((CharSequence)"systemModules", (Object)systemModules);
            Parameters.notNull((CharSequence)"userModules", (Object)userModules);
            Parameters.notNull((CharSequence)"legacyClassPath", (Object)legacyClassPath);
            this.base = base;
            this.sources = sources;
            this.systemModules = systemModules;
            this.userModules = userModules;
            this.legacyClassPath = legacyClassPath;
            this.filter = filter == null ? url -> null : filter;
            this.selfRes = new ThreadLocal();
            this.compilerOptions = new AtomicReference();
            this.moduleInfos = Collections.emptyList();
            this.sources.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.sources));
            this.systemModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.systemModules));
            this.userModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.base));
            this.legacyClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.legacyClassPath));
        }

        public Set<ClassPath.Flag> getFlags() {
            this.getResources();
            return this.incomplete ? EnumSet.of(ClassPath.Flag.INCOMPLETE) : Collections.emptySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<? extends PathResourceImplementation> getResources() {
            boolean incompleteVote;
            ArrayDeque<File> newModuleInfos;
            boolean needToFire;
            List<Object> res;
            block36: {
                block32: {
                    block31: {
                        res = this.getCache();
                        needToFire = false;
                        if (res == TOMBSTONE) {
                            needToFire = true;
                            res = null;
                        }
                        if (res != null) {
                            return res;
                        }
                        Object[] bestSoFar = this.selfRes.get();
                        if (bestSoFar != null) {
                            bestSoFar[1] = Boolean.TRUE;
                            return (List)bestSoFar[0];
                        }
                        newModuleInfos = new ArrayDeque<File>();
                        ArrayList newActiveProjectSourceRoots = new ArrayList();
                        ModuleInfoClassPathImplementation.collectProjectSourceRoots(this.systemModules, newActiveProjectSourceRoots);
                        ModuleInfoClassPathImplementation.collectProjectSourceRoots(this.userModules, newActiveProjectSourceRoots);
                        newActiveProjectSourceRoots.addAll(this.sources.entries().stream().map(e -> e.getURL()).collect(Collectors.toList()));
                        ProjectManager.mutex().readAccess(() -> {
                            ModuleInfoClassPathImplementation moduleInfoClassPathImplementation = this;
                            synchronized (moduleInfoClassPathImplementation) {
                                if (this.activeProjectSourceRoots != null) {
                                    this.activeProjectSourceRoots.getClassIndex().removeClassIndexListener((ClassIndexListener)this);
                                    this.activeProjectSourceRoots = null;
                                }
                                if (!newActiveProjectSourceRoots.isEmpty()) {
                                    this.activeProjectSourceRoots = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((URL[])newActiveProjectSourceRoots.toArray(new URL[newActiveProjectSourceRoots.size()])));
                                    this.activeProjectSourceRoots.getClassIndex().addClassIndexListener((ClassIndexListener)this);
                                    LOG.log(Level.FINER, "{0} for {1} listening on: {2}", new Object[]{this.getClass().getSimpleName(), this.base, newActiveProjectSourceRoots});
                                }
                            }
                        });
                        incompleteVote = false;
                        if (!ModuleInfoClassPathImplementation.supportsModules(this.systemModules, this.userModules, this.sources)) break block32;
                        Map<String, List<URL>> modulesPatches = this.getPatches();
                        String xmodule = this.getXModule();
                        String patchedModule = null;
                        HashMap<URL, List<Object>> sourcePatches = new HashMap<URL, List<Object>>();
                        HashMap mpBmn = new HashMap();
                        modulesPatches.entrySet().forEach(e -> ((List)e.getValue()).forEach(url -> {
                            String cfr_ignored_0 = (String)mpBmn.put(url, e.getKey());
                        }));
                        for (ClassPath.Entry e2 : this.sources.entries()) {
                            URL url2 = e2.getURL();
                            String mn = (String)mpBmn.get(url2);
                            if (mn == null) continue;
                            if (patchedModule == null) {
                                patchedModule = mn;
                            }
                            sourcePatches.put(url2, Collections.emptyList());
                        }
                        for (Object pRoot : mpBmn.keySet()) {
                            URL[] bin;
                            if (sourcePatches.containsKey(pRoot) || (bin = BinaryForSourceQuery.findBinaryRoots((URL)pRoot).getRoots()).length <= 0) continue;
                            sourcePatches.put((URL)pRoot, (List<Object>)Arrays.asList(bin));
                        }
                        Function<URL, Stream<URL>> patchRootTransformer = u -> {
                            List transformation = (List)sourcePatches.get(u);
                            return transformation == null ? Stream.of(u) : transformation.stream();
                        };
                        if (xmodule == null) {
                            xmodule = patchedModule;
                        }
                        Map<String, List<URL>> modulesByName = ModuleInfoClassPathImplementation.getModulesByName(this.base, modulesPatches, patchRootTransformer);
                        res = modulesByName.values().stream().flatMap(urls -> urls.stream()).map(url -> ClassPathSupport.createResource((URL)url)).collect(Collectors.toList());
                        List<Object> selfResResources = this.base == this.systemModules ? ModuleInfoClassPathImplementation.findJavaBase(modulesByName) : Collections.emptyList();
                        LOG.log(Level.FINER, "{0} for {1} self resources: {2}", new Object[]{ModuleInfoClassPathImplementation.class.getSimpleName(), this.base, selfResResources});
                        LOG.log(Level.FINEST, "{0} for {1} systemModules: {2}, userModules: {4}", new Object[]{ModuleInfoClassPathImplementation.class.getSimpleName(), this.base, this.systemModules, this.userModules});
                        this.selfRes.set(new Object[]{selfResResources, needToFire});
                        try {
                            boolean dependsOnUnnamed;
                            block30: {
                                Predicate<ModuleElement> rootModulesPredicate;
                                Set<String> additionalModules;
                                JavaSource src;
                                FileObject found = null;
                                for (ClassPath.Entry cpe : this.sources.entries()) {
                                    URL root = cpe.getURL();
                                    try {
                                        File moduleInfo = FileUtil.normalizeFile((File)new File(BaseUtilities.toFile((URI)root.toURI()), ModuleClassPaths.MODULE_INFO_JAVA));
                                        newModuleInfos.add(moduleInfo);
                                        if (found != null) continue;
                                        found = FileUtil.toFileObject((File)moduleInfo);
                                    }
                                    catch (URISyntaxException e3) {
                                        LOG.log(Level.WARNING, "Invalid URL: {0}, reason: {1}", new Object[]{root, e3.getMessage()});
                                    }
                                }
                                List<Object> bcprs = this.base == this.systemModules ? selfResResources : ModuleInfoClassPathImplementation.findJavaBase(ModuleInfoClassPathImplementation.getModulesByName(this.systemModules, modulesPatches, patchRootTransformer));
                                ClassPath bootCp = ClassPathSupport.createClassPath(bcprs);
                                if (found != null) {
                                    src = JavaSource.create((ClasspathInfo)new ClasspathInfo.Builder(bootCp).setModuleBootPath(this.systemModules).setModuleCompilePath(this.userModules).setSourcePath(this.sources).build(), (FileObject[])new FileObject[]{found});
                                    additionalModules = this.getAddMods();
                                    additionalModules.remove(MOD_ALL_UNNAMED);
                                    rootModulesPredicate = ModuleNames.create(additionalModules);
                                } else {
                                    src = JavaSource.create((ClasspathInfo)new ClasspathInfo.Builder(bootCp).setModuleBootPath(this.systemModules).setModuleCompilePath(this.userModules).setSourcePath(this.sources).build(), (FileObject[])new FileObject[0]);
                                    additionalModules = this.getAddMods();
                                    additionalModules.remove(MOD_ALL_UNNAMED);
                                    if (this.base == this.systemModules) {
                                        additionalModules.add(MOD_JAVA_SE);
                                        rootModulesPredicate = ModuleNames.create(additionalModules).or(NON_JAVA_PUBEXP);
                                    } else {
                                        rootModulesPredicate = ModuleNames.create(additionalModules);
                                    }
                                }
                                dependsOnUnnamed = false;
                                if (src == null) break block30;
                                try {
                                    HashSet<URL> requires;
                                    block35: {
                                        ModuleUtilities mu;
                                        block33: {
                                            block34: {
                                                ModuleElement myModule;
                                                ModuleTree myModuleTree;
                                                mu = ModuleUtilities.get((Object)src);
                                                if (mu == null) break block30;
                                                requires = new HashSet<URL>();
                                                if (found == null && xmodule == null) break block33;
                                                if (found != null) {
                                                    myModuleTree = mu.parseModule();
                                                    ModuleElement moduleElement = myModule = myModuleTree != null ? mu.resolveModule(myModuleTree) : null;
                                                    if (xmodule != null && LOG.isLoggable(Level.WARNING) && !xmodule.equals(Optional.ofNullable(myModuleTree).map(mt -> mt.getName().toString()).orElse(xmodule))) {
                                                        LOG.log(Level.WARNING, "Xmodule: {0} combined with module-info: {1}, ignoring xmodule.", new Object[]{xmodule, FileUtil.getFileDisplayName((FileObject)found)});
                                                    }
                                                } else {
                                                    List<URL> xmoduleLocs = modulesByName.get(xmodule);
                                                    myModuleTree = null;
                                                    myModule = mu.resolveModule(xmodule);
                                                    if (xmoduleLocs != null) {
                                                        requires.addAll(xmoduleLocs);
                                                    }
                                                    boolean bl = incompleteVote = myModule == null;
                                                }
                                                if (myModule == null) break block34;
                                                dependsOnUnnamed = ModuleInfoClassPathImplementation.dependsOnUnnamed(myModule, true);
                                                requires.addAll(ModuleInfoClassPathImplementation.collectRequiredModules(myModule, myModuleTree, true, false, modulesByName));
                                                break block35;
                                            }
                                            if (this.base != this.systemModules) break block35;
                                            Optional.ofNullable(modulesByName.get(MOD_JAVA_BASE)).ifPresent(requires::addAll);
                                            break block35;
                                        }
                                        dependsOnUnnamed = true;
                                        for (String moduleName : modulesByName.keySet()) {
                                            Optional.ofNullable(mu.resolveModule(moduleName)).filter(rootModulesPredicate).map(m -> ModuleInfoClassPathImplementation.collectRequiredModules(m, null, true, true, modulesByName)).ifPresent(requires::addAll);
                                        }
                                    }
                                    res = ModuleInfoClassPathImplementation.filterModules(res, requires, this.filter);
                                }
                                catch (IOException ioe) {
                                    Exceptions.printStackTrace((Throwable)ioe);
                                }
                            }
                            if (!dependsOnUnnamed) break block31;
                            List legacyEntires = this.legacyClassPath.entries();
                            ArrayList<Object> tmp = new ArrayList<Object>(res.size() + legacyEntires.size());
                            legacyEntires.stream().map(e -> ClassPathSupport.createResource((URL)e.getURL())).forEach(tmp::add);
                            tmp.addAll(res);
                            res = tmp;
                        }
                        catch (Throwable throwable) {
                            needToFire = this.selfRes.get()[1] == Boolean.TRUE;
                            this.selfRes.remove();
                            throw throwable;
                        }
                    }
                    needToFire = this.selfRes.get()[1] == Boolean.TRUE;
                    this.selfRes.remove();
                    break block36;
                }
                res = Collections.emptyList();
            }
            ModuleInfoClassPathImplementation moduleInfoClassPathImplementation = this;
            synchronized (moduleInfoClassPathImplementation) {
                assert (res != null);
                List<PathResourceImplementation> ccv = this.getCache();
                if (ccv == null || ccv == TOMBSTONE) {
                    LOG.log(Level.FINE, "{0} for {1} setting results: {2}, listening on: {3}", new Object[]{this.getClass().getSimpleName(), this.base, res, newModuleInfos});
                    this.setCache(res);
                    ArrayList added = new ArrayList(newModuleInfos);
                    added.removeAll(this.moduleInfos);
                    ArrayList<File> removed = new ArrayList<File>(this.moduleInfos);
                    removed.removeAll(newModuleInfos);
                    removed.stream().forEach(f -> FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f));
                    added.stream().forEach(f -> FileUtil.addFileChangeListener((FileChangeListener)this, (File)f));
                    this.moduleInfos = newModuleInfos;
                    this.incomplete = incompleteVote;
                } else {
                    res = ccv;
                }
            }
            if (needToFire) {
                this.fire("resources");
            }
            return res;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || "entries".equals(propName)) {
                this.resetOutsideWriteAccess(null, "resources");
            }
        }

        @Override
        public void stateChanged(@NonNull ChangeEvent evt) {
            this.resetOutsideWriteAccess(null, "flags", "resources");
        }

        public void fileDataCreated(FileEvent fe) {
            this.resetOutsideWriteAccess(fe.getFile(), "resources");
        }

        public void fileChanged(FileEvent fe) {
            this.resetOutsideWriteAccess(fe.getFile(), "resources");
        }

        public void fileDeleted(FileEvent fe) {
            ClasspathInfo info = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)this.sources);
            Set mods = info.getClassIndex().getDeclaredModules("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
            if (mods.isEmpty()) {
                this.resetOutsideWriteAccess(null, "resources");
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.resetOutsideWriteAccess(fe.getFile(), "resources");
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void rootsAdded(RootsEvent event) {
        }

        public void rootsRemoved(RootsEvent event) {
        }

        public void typesAdded(TypesEvent event) {
            this.handleModuleChange(event);
        }

        public void typesRemoved(TypesEvent event) {
            this.handleModuleChange(event);
        }

        public void typesChanged(TypesEvent event) {
            this.handleModuleChange(event);
        }

        private void resetOutsideWriteAccess(FileObject artifact, String ... propNames) {
            boolean hasDocExclusiveLock = Optional.ofNullable(artifact).map(fo -> {
                try {
                    return (EditorCookie)DataObject.find((FileObject)fo).getLookup().lookup(EditorCookie.class);
                }
                catch (DataObjectNotFoundException e) {
                    return null;
                }
            }).map(ec -> ec.getDocument()).map(DocumentUtilities::isWriteLocked).orElse(Boolean.FALSE);
            Runnable action = () -> this.resetCache(TOMBSTONE, propNames);
            if (hasDocExclusiveLock) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Firing under editor write lock: {0}", Arrays.toString(Thread.currentThread().getStackTrace()));
                }
                CLASS_INDEX_FIRER.execute(action);
            } else if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().postReadRequest(action);
            } else {
                action.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleModuleChange(@NonNull TypesEvent event) {
            if (event.getModule() != null) {
                ClasspathInfo info;
                ModuleInfoClassPathImplementation moduleInfoClassPathImplementation = this;
                synchronized (moduleInfoClassPathImplementation) {
                    info = this.activeProjectSourceRoots;
                    if (info != null) {
                        if (this.rootsChanging) {
                            info = null;
                        } else {
                            this.rootsChanging = true;
                        }
                    }
                }
                if (info != null) {
                    try {
                        JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]).runWhenScanFinished(cc -> {
                            LOG.log(Level.FINER, "{0} for {1} got class index event due to change of module {2} in {3}", new Object[]{ModuleInfoClassPathImplementation.class.getSimpleName(), this.base, event.getModule().getQualifiedName(), event.getRoot()});
                            this.rootsChanging = false;
                            CLASS_INDEX_FIRER.execute(() -> this.resetCache(TOMBSTONE, "flags", "resources"));
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        }

        @CheckForNull
        private CompilerOptionsQuery.Result getCompilerOptions() {
            CompilerOptionsQuery.Result res = this.compilerOptions.get();
            if (res == null) {
                FileObject[] roots = this.sources.getRoots();
                CompilerOptionsQuery.Result result = res = roots.length == 0 ? null : CompilerOptionsQuery.getOptions((FileObject)roots[0]);
                if (res != null) {
                    if (this.compilerOptions.compareAndSet(null, res)) {
                        res.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)res));
                    } else {
                        res = this.compilerOptions.get();
                        assert (res != null);
                    }
                }
            }
            return res;
        }

        private Set<String> getAddMods() {
            CompilerOptionsQuery.Result res = this.getCompilerOptions();
            return res == null ? new HashSet() : CommonModuleUtils.getAddModules(res);
        }

        @CheckForNull
        private String getXModule() {
            CompilerOptionsQuery.Result res = this.getCompilerOptions();
            return res == null ? null : CommonModuleUtils.getXModule(res);
        }

        @NonNull
        private Map<String, List<URL>> getPatches() {
            CompilerOptionsQuery.Result res = this.getCompilerOptions();
            return res == null ? Collections.emptyMap() : CommonModuleUtils.getPatches(res);
        }

        @NonNull
        private static Map<String, List<URL>> getModulesByName(@NonNull ClassPath cp, @NonNull Map<String, List<URL>> patches, @NonNull Function<URL, Stream<URL>> patchRootTrannsformer) {
            LinkedHashMap<String, List<URL>> res = new LinkedHashMap<String, List<URL>>();
            cp.entries().stream().map(entry -> entry.getURL()).forEach(url -> {
                String moduleName = SourceUtils.getModuleName((URL)url, (boolean)true);
                if (moduleName != null) {
                    ArrayList<URL> roots = new ArrayList<URL>();
                    List patchRoots = (List)patches.get(moduleName);
                    if (patchRoots != null) {
                        patchRoots.stream().flatMap(patchRootTrannsformer).forEach(roots::add);
                    }
                    roots.add((URL)url);
                    res.put(moduleName, roots);
                }
            });
            return res;
        }

        private static void collectProjectSourceRoots(@NonNull ClassPath cp, @NonNull Collection<? super URL> projectSourceRoots) {
            cp.entries().stream().map(e -> e.getURL()).forEach(url -> {
                SourceForBinaryQuery.Result2 sfbqRes = SourceForBinaryQuery.findSourceRoots2((URL)url);
                if (sfbqRes.preferSources()) {
                    Arrays.stream(sfbqRes.getRoots()).map(fo -> fo.toURL()).forEach(projectSourceRoots::add);
                }
            });
        }

        @NonNull
        private static List<PathResourceImplementation> findJavaBase(Map<String, List<URL>> modulesByName) {
            return Optional.ofNullable(modulesByName.get(MOD_JAVA_BASE)).map(urls -> urls.stream().map(ClassPathSupport::createResource).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }

        private static boolean dependsOnUnnamed(@NonNull ModuleElement module, boolean transitive) {
            return ModuleInfoClassPathImplementation.dependsOnUnnamed(module, transitive, true, new HashSet<ModuleElement>());
        }

        private static boolean dependsOnUnnamed(@NonNull ModuleElement module, boolean transitive, boolean topLevel, Set<ModuleElement> seen) {
            if (module.isUnnamed()) {
                return true;
            }
            if (seen.add(module)) {
                for (ModuleElement.Directive directive : module.getDirectives()) {
                    if (directive.getKind() != ModuleElement.DirectiveKind.REQUIRES) continue;
                    ModuleElement.RequiresDirective rd = (ModuleElement.RequiresDirective)directive;
                    if (!topLevel && (!transitive || !rd.isTransitive()) || !ModuleInfoClassPathImplementation.dependsOnUnnamed(rd.getDependency(), transitive, false, seen)) continue;
                    return true;
                }
            }
            return false;
        }

        @NonNull
        private static Set<URL> collectRequiredModules(@NonNull ModuleElement module, @NullAllowed ModuleTree moduleTree, boolean transitive, boolean includeTopLevel, @NonNull Map<String, List<URL>> modulesByName) {
            List<URL> moduleLocs;
            HashSet<URL> res = new HashSet<URL>();
            HashSet seen = new HashSet();
            if (includeTopLevel && (moduleLocs = modulesByName.get(module.getQualifiedName().toString())) != null) {
                res.addAll(moduleLocs);
            }
            ModuleInfoClassPathImplementation.collectRequiredModulesImpl(module, moduleTree, transitive, !includeTopLevel, modulesByName, seen, res);
            return res;
        }

        private static boolean collectRequiredModulesImpl(@NullAllowed ModuleElement module, @NullAllowed ModuleTree moduleTree, boolean transitive, boolean topLevel, final @NonNull Map<String, List<URL>> modulesByName, @NonNull Collection<? super ModuleElement> seen, final @NonNull Collection<? super URL> c) {
            if (module != null && seen.add(module) && !module.isUnnamed()) {
                for (ModuleElement.Directive directive : module.getDirectives()) {
                    List<URL> dependencyURLs;
                    if (directive.getKind() != ModuleElement.DirectiveKind.REQUIRES) continue;
                    ModuleElement.RequiresDirective req = (ModuleElement.RequiresDirective)directive;
                    if (!topLevel && !req.isTransitive() && !ModuleInfoClassPathImplementation.isMandated(req)) continue;
                    ModuleElement dependency = req.getDependency();
                    boolean add = true;
                    if (transitive) {
                        add = ModuleInfoClassPathImplementation.collectRequiredModulesImpl(dependency, null, transitive, false, modulesByName, seen, c);
                    }
                    if (!add || (dependencyURLs = modulesByName.get(dependency.getQualifiedName().toString())) == null) continue;
                    c.addAll(dependencyURLs);
                }
                if (moduleTree != null) {
                    moduleTree.accept(new ErrorAwareTreeScanner<Void, Void>(){

                        public Void visitRequires(RequiresTree node, Void p) {
                            String moduleName = node.getModuleName().toString();
                            Optional.ofNullable(modulesByName.get(moduleName)).ifPresent(c::addAll);
                            return (Void)super.visitRequires(node, (Object)p);
                        }
                    }, null);
                }
                return true;
            }
            return false;
        }

        @NonNull
        private static List<PathResourceImplementation> filterModules(@NonNull List<PathResourceImplementation> modules, @NonNull Set<URL> requires, @NonNull Function<URL, Boolean> filter) {
            ArrayList<PathResourceImplementation> res = new ArrayList<PathResourceImplementation>(modules.size());
            for (PathResourceImplementation pr : modules) {
                for (URL url : pr.getRoots()) {
                    Boolean vote = filter.apply(url);
                    if (vote != Boolean.TRUE && (vote != null || !requires.contains(url))) continue;
                    res.add(pr);
                }
            }
            return res;
        }

        private static boolean supportsModules(@NonNull ClassPath boot, @NonNull ClassPath compile, @NonNull ClassPath src) {
            if (boot.findResource("java/util/zip/CRC32C.class") != null) {
                return true;
            }
            if (compile.findResource("java/util/zip/CRC32C.class") != null) {
                return true;
            }
            return src.findResource("java/util/zip/CRC32C.java") != null;
        }

        private static boolean isMandated(@NonNull ModuleElement.RequiresDirective rd) {
            return Optional.ofNullable(rd.getDependency()).map(me -> MOD_JAVA_BASE.equals(me.getQualifiedName().toString())).orElse(Boolean.FALSE);
        }

        private static final class ModuleNames
        implements Predicate<ModuleElement> {
            private final Set<? extends String> moduleNames;

            private ModuleNames(@NonNull Set<? extends String> names) {
                this.moduleNames = names;
            }

            @Override
            public boolean test(ModuleElement t) {
                return this.moduleNames.contains(t.getQualifiedName().toString());
            }

            @NonNull
            static Predicate<ModuleElement> create(@NonNull Set<? extends String> name) {
                return new ModuleNames(name);
            }
        }
    }

    private static final class PropertyModulePath
    extends BaseClassPathImplementation
    implements PropertyChangeListener,
    FileChangeListener {
        private static final String MODULE_INFO_CLASS = "module-info.class";
        private final File projectDir;
        private final PropertyEvaluator eval;
        private final Function<URL, Boolean> filter;
        private final Set<String> props;
        private final Set<File> listensOn;

        PropertyModulePath(@NonNull File projectDir, @NonNull PropertyEvaluator eval, @NullAllowed Function<URL, Boolean> filter, String ... props) {
            Parameters.notNull((CharSequence)"projectDir", (Object)projectDir);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"props", (Object)props);
            this.projectDir = projectDir;
            this.eval = eval;
            this.filter = filter == null ? url -> true : filter;
            this.props = new LinkedHashSet<String>();
            this.listensOn = new HashSet<File>();
            Collections.addAll(this.props, props);
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<? extends PathResourceImplementation> getResources() {
            List<PathResourceImplementation> res = this.getCache();
            if (res == null) {
                res = new ArrayList<PathResourceImplementation>();
                ArrayList<PathResourceImplementation> collector = res;
                HashSet modulePathRoots = new HashSet();
                this.props.stream().map(prop -> this.eval.getProperty(prop)).flatMap(path -> path == null ? Collections.emptyList().stream() : Arrays.stream(PropertyUtils.tokenizePath((String)path))).map(part -> PropertyUtils.resolveFile((File)this.projectDir, (String)part)).flatMap(modulePathEntry -> {
                    if (PropertyModulePath.isArchiveFile(modulePathEntry) || PropertyModulePath.hasModuleInfo(modulePathEntry)) {
                        return Stream.of(modulePathEntry);
                    }
                    modulePathRoots.add(modulePathEntry);
                    return PropertyModulePath.findModules(modulePathEntry);
                }).forEach(file -> {
                    URL url = FileUtil.urlForArchiveOrDir((File)file);
                    if (url != null && this.filter.apply(url) != Boolean.FALSE) {
                        collector.add(ClassPathSupport.createResource((URL)url));
                    }
                });
                PropertyModulePath propertyModulePath = this;
                synchronized (propertyModulePath) {
                    List<PathResourceImplementation> cv = this.getCache();
                    if (cv == null) {
                        HashSet toAdd = new HashSet(modulePathRoots);
                        HashSet<File> toRemove = new HashSet<File>(this.listensOn);
                        toAdd.removeAll(this.listensOn);
                        toRemove.removeAll(modulePathRoots);
                        for (File f : toRemove) {
                            FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                            this.listensOn.remove(f);
                        }
                        for (File f : toAdd) {
                            FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                            this.listensOn.add(f);
                        }
                        LOG.log(Level.FINE, "{0} setting results: {1}, listening on: {2}", new Object[]{this.getClass().getSimpleName(), res, this.listensOn});
                        this.setCache(res);
                    } else {
                        res = cv;
                    }
                }
            }
            return res;
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || this.props.contains(propName)) {
                LOG.log(Level.FINER, "{0} propertyChange: {1}", new Object[]{this.getClass().getSimpleName(), propName});
                this.resetCache("resources");
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.handleFileEvent(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.handleFileEvent(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.handleFileEvent(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.handleFileEvent((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        private void handleFileEvent(@NonNull FileEvent fe) {
            LOG.log(Level.FINER, "{0} file event: {1}", new Object[]{this.getClass().getSimpleName(), fe.getFile()});
            this.resetCache("resources");
        }

        private static boolean isArchiveFile(@NonNull File file) {
            try {
                return FileUtil.isArchiveFile((URL)BaseUtilities.toURI((File)file).toURL());
            }
            catch (MalformedURLException mue) {
                LOG.log(Level.WARNING, "Invalid URL for: {0}", file);
                return false;
            }
        }

        private static boolean hasModuleInfo(@NonNull File file) {
            return SourceUtils.getModuleName((URL)FileUtil.urlForArchiveOrDir((File)file), (boolean)true) != null;
        }

        @NonNull
        private static Stream<File> findModules(@NonNull File modulesFolder) {
            File[] modules = modulesFolder.listFiles(f -> {
                try {
                    if (f.getName().startsWith(".")) {
                        return false;
                    }
                    return f.isFile() ? FileUtil.isArchiveFile((URL)BaseUtilities.toURI((File)f).toURL()) : new File(f, MODULE_INFO_CLASS).exists();
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return false;
                }
            });
            return modules == null ? Stream.empty() : Arrays.stream(modules);
        }
    }

    private static final class PlatformModulePath
    extends BaseClassPathImplementation
    implements PropertyChangeListener {
        private static final String PLATFORM_ANT_NAME = "platform.ant.name";
        private final PropertyEvaluator eval;
        private final String platformType;

        PlatformModulePath(@NonNull PropertyEvaluator eval, @NonNull String platformType) {
            Parameters.notNull((CharSequence)"evel", (Object)eval);
            Parameters.notNull((CharSequence)"platformType", (Object)platformType);
            this.eval = eval;
            this.platformType = platformType;
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            List<PathResourceImplementation> res = this.getCache();
            if (res != null) {
                return res;
            }
            res = this.createResources();
            PlatformModulePath platformModulePath = this;
            synchronized (platformModulePath) {
                assert (res != null);
                if (this.getCache() == null) {
                    this.setCache(res);
                } else {
                    res = this.getCache();
                }
            }
            return res;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || "platform.active".equals(propName) || "installedPlatforms".equals(propName) && this.isActivePlatformChange()) {
                this.resetCache("resources");
            }
        }

        private boolean isActivePlatformChange() {
            List<PathResourceImplementation> current = this.getCache();
            if (current == null) {
                return false;
            }
            Stream<JavaPlatform> platforms = this.getPlatforms();
            return platforms.findFirst().isPresent() ? current.isEmpty() : !current.isEmpty();
        }

        private List<PathResourceImplementation> createResources() {
            ArrayList<PathResourceImplementation> res = new ArrayList<PathResourceImplementation>();
            this.getPlatforms().flatMap(plat -> plat.getBootstrapLibraries().entries().stream()).map(entry -> entry.getURL()).forEach(root -> res.add(ClassPathSupport.createResource((URL)root)));
            return res;
        }

        @NonNull
        private Stream<JavaPlatform> getPlatforms() {
            String platformName = this.eval.getProperty("platform.active");
            return platformName != null && !platformName.isEmpty() ? Arrays.stream(JavaPlatformManager.getDefault().getInstalledPlatforms()).filter(plat -> platformName.equals(plat.getProperties().get(PLATFORM_ANT_NAME)) && this.platformType.equals(plat.getSpecification().getName())) : Stream.empty();
        }
    }

    private static final class MultiModuleBinaries
    extends BaseClassPathImplementation
    implements PropertyChangeListener,
    ChangeListener,
    FileChangeListener {
        private final MultiModule model;
        private final boolean archives;
        private final boolean requiresModuleInfo;
        private Collection<BinaryForSourceQuery.Result> currentResults;
        private Collection<ClassPath> currentSourcePaths;
        private final Set<File> currentModuleInfos;

        MultiModuleBinaries(@NonNull MultiModule model, boolean archives, boolean requiresModuleInfo) {
            Parameters.notNull((CharSequence)"model", (Object)model);
            this.model = model;
            this.archives = archives;
            this.requiresModuleInfo = requiresModuleInfo;
            this.currentModuleInfos = new HashSet<File>();
            this.model.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.model));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            List<PathResourceImplementation> res = this.getCache();
            if (res != null) {
                return res;
            }
            ArrayList<BinaryForSourceQuery.Result> results = new ArrayList<BinaryForSourceQuery.Result>();
            ArrayList<ClassPath> sourcePaths = new ArrayList<ClassPath>();
            HashSet moduleInfos = new HashSet();
            res = this.createResources(results, sourcePaths, moduleInfos);
            MultiModuleBinaries multiModuleBinaries = this;
            synchronized (multiModuleBinaries) {
                assert (res != null);
                if (this.getCache() == null) {
                    this.setCache(res);
                    if (this.currentResults != null) {
                        this.currentResults.forEach(r -> r.removeChangeListener((ChangeListener)this));
                    }
                    results.forEach(r -> r.addChangeListener((ChangeListener)this));
                    this.currentResults = results;
                    if (this.currentSourcePaths != null) {
                        this.currentSourcePaths.forEach(scp -> scp.removePropertyChangeListener((PropertyChangeListener)this));
                    }
                    sourcePaths.forEach(scp -> scp.addPropertyChangeListener((PropertyChangeListener)this));
                    this.currentSourcePaths = sourcePaths;
                    HashSet<File> toRemove = new HashSet<File>(this.currentModuleInfos);
                    toRemove.removeAll(moduleInfos);
                    moduleInfos.removeAll(this.currentModuleInfos);
                    for (File f : toRemove) {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                        this.currentModuleInfos.remove(f);
                    }
                    for (File f : moduleInfos) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                        this.currentModuleInfos.add(f);
                    }
                } else {
                    res = this.getCache();
                }
            }
            return res;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("modules".equals(propName) || "entries".equals(propName)) {
                this.resetCache("resources");
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.resetCache("resources");
        }

        public void fileDeleted(FileEvent fe) {
            this.resetCache("resources");
        }

        public void fileDataCreated(FileEvent fe) {
            this.resetCache("resources");
        }

        public void fileFolderCreated(FileEvent fe) {
            this.resetCache("resources");
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.resetCache("resources");
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private List<PathResourceImplementation> createResources(@NonNull Collection<? super BinaryForSourceQuery.Result> results, @NonNull Collection<? super ClassPath> sourcePaths, @NonNull Collection<? super File> moduleInfos) {
            LinkedHashSet binaries = new LinkedHashSet();
            for (String string : this.model.getModuleNames()) {
                ClassPath scp = this.model.getModuleSources(string);
                if (scp == null) continue;
                sourcePaths.add((ClassPath)scp);
                Consumer<URL> consummer = !this.requiresModuleInfo || scp.findResource(ModuleClassPaths.MODULE_INFO_JAVA) != null ? u -> {
                    BinaryForSourceQuery.Result r = BinaryForSourceQuery.findBinaryRoots((URL)u);
                    results.add(r);
                    binaries.addAll(MultiModuleBinaries.filterArtefact(this.archives, r.getRoots()));
                } : u -> {};
                for (ClassPath.Entry e : scp.entries()) {
                    try {
                        URL url2 = e.getURL();
                        consummer.accept(url2);
                        Optional.ofNullable(this.requiresModuleInfo ? BaseUtilities.toFile((URI)url2.toURI()) : null).map(root -> new File((File)root, ModuleClassPaths.MODULE_INFO_JAVA)).ifPresent(moduleInfos::add);
                    }
                    catch (URISyntaxException use) {
                        LOG.log(Level.WARNING, "Cannot convert to URI: {0}", e.getURL());
                    }
                }
            }
            return binaries.stream().map(url -> ClassPathSupport.createResource((URL)url)).collect(Collectors.toList());
        }

        private static Collection<? extends URL> filterArtefact(boolean archive, URL ... urls) {
            ArrayList<URL> res = new ArrayList<URL>(urls.length);
            for (URL url : urls) {
                if ((!archive || !FileUtil.isArchiveArtifact((URL)url)) && (archive || FileUtil.isArchiveArtifact((URL)url))) continue;
                res.add(url);
                break;
            }
            if (res.isEmpty()) {
                Collections.addAll(res, urls);
            }
            return res;
        }
    }
}

