/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.helper.JavaCompatibleProperties;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.utils.system.launchers.impl.ShLauncher;

public class CommandLauncher
extends ShLauncher {
    private static final String COMMAND_EXT = ".command";
    public static final String JAVA_APPLICATION_ICON_PROPERTY = "nbi.java.application.icon";
    public static final String JAVA_APPLICATION_NAME_LAUNCHER_PROPERTY = "nlu.java.application.name.macosx";
    public static final String JAVA_APPLICATION_ICON_DEFAULT_URI = "resource:org/netbeans/installer/utils/system/launchers/impl/dockicon.icns";
    public static final String NOTSET_DOCK_ICON_PROPERTY = "nbi.not.set.dock.icon";
    public static final String NOTSET_DOCK_NAME_PROPERTY = "nbi.not.set.dock.name";
    public static final String XDOCK_ICON_PROPERTY_NAME = "-Xdock:icon";
    public static final String XDOCK_NAME_PROPERTY_NAME = "-Xdock:name";
    private static final String[] JAVA_MACOSX_LOCATION = new String[0];
    public static final String MIN_JAVA_VERSION_MACOSX = "1.5.0_02";
    private static final String ERROR_CANNOT_GET_ICON_KEY = "CdL.error.cannot.get.icon";

    public CommandLauncher(LauncherProperties props) {
        super(props);
    }

    @Override
    protected String[] getCommonSystemJavaLocations() {
        return JAVA_MACOSX_LOCATION;
    }

    @Override
    public String getExtension() {
        return COMMAND_EXT;
    }

    @Override
    public List<JavaCompatibleProperties> getDefaultCompatibleJava(Version version) {
        if (version.equals(Version.getVersion("1.5"))) {
            ArrayList<JavaCompatibleProperties> list = new ArrayList<JavaCompatibleProperties>();
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_MACOSX, null, null, null, null));
            return list;
        }
        return super.getDefaultCompatibleJava(version);
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        boolean setDockIcon = true;
        boolean setDockName = true;
        for (String s : this.jvmArguments) {
            if (s.contains(XDOCK_NAME_PROPERTY_NAME)) {
                setDockName = false;
            }
            if (!s.contains(XDOCK_ICON_PROPERTY_NAME)) continue;
            setDockIcon = false;
        }
        if (setDockIcon && !Boolean.getBoolean(NOTSET_DOCK_ICON_PROPERTY)) {
            File iconFile = null;
            String uri = System.getProperty(JAVA_APPLICATION_ICON_PROPERTY);
            if (uri == null) {
                uri = JAVA_APPLICATION_ICON_DEFAULT_URI;
            }
            try {
                iconFile = FileProxy.getInstance().getFile(uri, true);
                LauncherResource iconResource = new LauncherResource(iconFile);
                this.jvmArguments.add("-Xdock:icon=" + iconResource.getAbsolutePath());
                this.otherResources.add(iconResource);
            }
            catch (DownloadException e) {
                ErrorManager.notify(ResourceUtils.getString(CommandLauncher.class, ERROR_CANNOT_GET_ICON_KEY, uri), (Throwable)e);
            }
        }
        if (setDockName && !Boolean.getBoolean(NOTSET_DOCK_NAME_PROPERTY)) {
            this.jvmArguments.add("-Xdock:name=$P{nlu.java.application.name.macosx}");
        }
    }
}

