/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.server.ClassBytesLoader;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.EventBufferManager;
import org.netbeans.lib.profiler.server.HeapHistogramManager;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerCalibrator;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUFullInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUSampledInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjAlloc;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.HeapDump;
import org.netbeans.lib.profiler.server.system.Histogram;
import org.netbeans.lib.profiler.server.system.Stacks;
import org.netbeans.lib.profiler.server.system.ThreadDump;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.ClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.InitiateProfilingCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupData;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodInvokedFirstTimeCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;

public class ProfilerInterface
implements CommonConstants {
    private static final int REDEFINE_CHUNK_SIZE = 500;
    static final char BOOLEAN = 'Z';
    static final char CHAR = 'C';
    static final char BYTE = 'B';
    static final char SHORT = 'S';
    static final char INT = 'I';
    static final char LONG = 'J';
    static final char FLOAT = 'F';
    static final char DOUBLE = 'D';
    static final char VOID = 'V';
    static final char REFERENCE = 'L';
    private static String INTERNAL_ERROR_MSG = "Internal error:\nExpected InstrumentMethodGroupResponse, got response of class {0},\nvalue = {1}\nAll instrumentation will be removed";
    private static String UNEXPECTED_EXCEPTION_MSG = "Unexpected exception caught when trying to instrument classes.\nOriginal exception:\n{0}\nStack trace:\n\n{1}";
    private static String INSTRUMENTATION_SUCCESSFUL_MSG = "Deferred instrumentation performed successfully";
    private static String HISTOGRAM_NOT_AVAILABLE_MSG = "Histogram is not available.";
    private static final boolean DEBUG;
    private static final boolean INSTRUMENT_JFLUID_CLASSES;
    private static final byte[] EMPTY;
    public static final TransactionalSupport serialClientOperationsLock;
    private static ProfilerServer profilerServer;
    private static ProfilingSessionStatus status;
    private static EventBufferManager evBufManager;
    private static WeakReference[] loadedClassesArray;
    private static int[] loadedClassesLoaders;
    private static WeakHashMap reflectMethods;
    private static boolean targetAppSuspended;
    private static boolean instrumentReflection;
    private static boolean instrSpawnedThreads;
    private static int[] packedArrayOffsets;
    private static int nSystemThreads;
    private static Thread initInstrumentationThread;
    private static String[] rootClassNames;
    private static boolean[] rootClassNameWildcard;
    private static boolean[] rootClassNamePackageWildcard;
    static int nClassLoads;
    static int nFirstMethodInvocations;
    static int nEmptyInstrMethodGroupResponses;
    static int nNonEmptyInstrMethodGroupResponses;
    static int nSingleMethodInstrMethodGroupResponses;
    static int nTotalInstrMethods;
    static long totalHotswappingTime;
    static long minHotswappingTime;
    static long maxHotswappingTime;
    static long clientInstrStartTime;
    static long clientInstrTime;
    static long clientDataProcStartTime;
    static long clientDataProcTime;
    private static boolean rootClassLoaded;
    private static volatile Thread instrumentMethodGroupCallThread;
    private static volatile boolean detachStarted;
    private static HeapHistogramManager heapHistgramManager;

    public static CodeRegionCPUResultsResponse getCodeRegionCPUResults() {
        CodeRegionCPUResultsResponse resp = new CodeRegionCPUResultsResponse(ProfilerRuntimeCPUCodeRegion.getProfilingResults());
        return resp;
    }

    public static void setCurrentInstrType(int type) {
        boolean isMemoryProfiling = type == 5 || type == 6;
        ProfilerInterface.status.currentInstrType = type;
        Classes.setVMObjectAllocEnabled((boolean)isMemoryProfiling);
    }

    public static int getCurrentInstrType() {
        return ProfilerInterface.status.currentInstrType;
    }

    public static ThreadLivenessStatusResponse getCurrentThreadLivenessStatus() {
        ThreadLivenessStatusResponse resp = new ThreadLivenessStatusResponse(ThreadInfo.getCurrentLivenessStatus());
        return resp;
    }

    public static void setInstrumentReflection(boolean v) {
        if (ProfilerInterface.status.targetAppRunning) {
            ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(v);
        } else {
            instrumentReflection = v;
        }
    }

    public static MethodNamesResponse getMethodNamesForJMethodIds(int[] methodIds) {
        int PACKEDARR_ITEMS = 4;
        int nMethods = methodIds.length;
        int len = nMethods * 4;
        packedArrayOffsets = new int[len];
        byte[] packedData = Stacks.getMethodNamesForJMethodIds(nMethods, methodIds, packedArrayOffsets);
        MethodNamesResponse resp = new MethodNamesResponse(packedData, packedArrayOffsets);
        return resp;
    }

    public static int getNPrerecordedSystemThreads() {
        return nSystemThreads;
    }

    public static ObjectAllocationResultsResponse getObjectAllocationResults() {
        status.beginTrans(false);
        try {
            ObjectAllocationResultsResponse resp;
            ObjectAllocationResultsResponse objectAllocationResultsResponse = resp = new ObjectAllocationResultsResponse(status.getAllocatedInstancesCount(), status.getNInstrClasses());
            return objectAllocationResultsResponse;
        }
        finally {
            status.endTrans();
        }
    }

    public static void setProfilerServer(ProfilerServer server) {
        profilerServer = server;
    }

    public static void clearProfilerDataStructures() {
        reflectMethods = null;
    }

    public static boolean cpuResultsExist() {
        return ProfilerRuntime.profiledTargetAppThreadsExist();
    }

    static void disableProfiling() {
        int instrType = ProfilerInterface.getCurrentInstrType();
        switch (instrType) {
            case 0: 
            case 7: {
                ProfilerRuntime.clearDataStructures();
                break;
            }
            case 2: {
                ProfilerRuntimeSampler.shutdown();
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.enableProfiling(false);
                if (rootClassNames == null) break;
                rootClassNames = null;
                break;
            }
            case 3: {
                ProfilerRuntimeCPUFullInstr.enableProfiling(false);
                ProfilerRuntimeCPU.setTimerTypes(false, false);
                break;
            }
            case 4: {
                ProfilerRuntimeCPUSampledInstr.enableProfiling(false);
                ProfilerRuntimeCPU.setTimerTypes(false, false);
                break;
            }
            case 5: {
                ProfilerRuntimeObjAlloc.enableProfiling(false);
                break;
            }
            case 6: {
                ProfilerRuntimeObjLiveness.enableProfiling(false);
            }
        }
    }

    public static void deactivateInjectedCode() {
        ProfilerInterface.disableProfilerHooks();
        ProfilerInterface.disableProfiling();
        status.resetInstrClassAndMethodInfo();
        ProfilerInterface.setCurrentInstrType(0);
    }

    public static void disableProfilerHooks() {
        Classes.setWaitTrackingEnabled((boolean)false);
        Classes.setParkTrackingEnabled((boolean)false);
        Classes.setSleepTrackingEnabled((boolean)false);
        Classes.setVMObjectAllocEnabled((boolean)false);
        Classes.disableClassLoadHook();
        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(false);
        ClassLoaderManager.setNotifyToolAboutUnloadedClasses(false);
    }

    public static void dumpExistingResults(boolean live) {
        if (!live && ProfilerInterface.getCurrentInstrType() == 6 && ProfilerRuntimeObjLiveness.getRunGCOnGetResults()) {
            GC.runGC();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProfilerRuntime.dumpEventBuffer();
    }

    public static void initProfilerInterface(ProfilingSessionStatus status, Thread specialThread) {
        boolean jdk15 = Platform.getJDKVersionNumber() == 2;
        Timers.initialize();
        Classes.initialize();
        GC.initialize();
        Stacks.initialize();
        Threads.initialize();
        HeapDump.initialize((boolean)jdk15);
        ThreadDump.initialize((boolean)jdk15);
        ClassLoaderManager.initialize(profilerServer);
        ClassLoaderManager.addLoader(ClassLoader.getSystemClassLoader());
        reflectMethods = new WeakHashMap();
        evBufManager = new EventBufferManager(profilerServer);
        heapHistgramManager = new HeapHistogramManager();
        ProfilerInterface.status = status;
        detachStarted = false;
        while (!Monitors.monitorThreadsStarted()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (status.runningInAttachedMode) {
            Threads.recordProfilerOwnThreads(false, specialThread);
            nSystemThreads = -1;
        } else {
            nSystemThreads = Threads.recordProfilerOwnThreads(true, specialThread);
        }
        ProfilerRuntime.init(new ProfilerRuntime.ExternalActionsHandler(){

            public void handleFirstTimeMethodInvoke(char methodId) {
                ProfilerInterface.firstTimeMethodInvokeHook(methodId);
            }

            public void handleReflectiveInvoke(Method method) {
                ProfilerInterface.reflectiveMethodInvokeHook(method);
            }

            public int handleFirstTimeVMObjectAlloc(String className, int definingClassLoaderId) {
                return ProfilerInterface.firstTimeVMObjectAlloc(className, definingClassLoaderId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEventBufferDump(byte[] eventBuffer, int startPos, int curPtrPos) {
                serialClientOperationsLock.beginTrans(true);
                try {
                    clientDataProcStartTime = Timers.getCurrentTimeInCounts();
                    evBufManager.eventBufferDumpHook(eventBuffer, startPos, curPtrPos);
                    clientDataProcTime += Timers.getCurrentTimeInCounts() - clientDataProcStartTime;
                }
                finally {
                    serialClientOperationsLock.endTrans();
                }
            }
        });
    }

    public static void initiateProfiling(InitiateProfilingCommand cmd, boolean targetAppRunning) throws Exception {
        int instrType = cmd.getInstrType();
        String instrClassName = cmd.getRootClassName();
        if (instrClassName.equals("*FAKE_CLASS_FOR_INTERNAL_TEST*")) {
            ProfilerInterface.handleFakeInitRecursiveInstrumentationCommand();
            return;
        }
        switch (instrType) {
            case 0: 
            case 7: {
                ProfilerInterface.createEventBuffer();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                ProfilerInterface.createEventBuffer();
                status.resetInstrClassAndMethodInfo();
                if (instrType == 5 || instrType == 6) {
                    ClassLoaderManager.setNotifyToolAboutUnloadedClasses(true);
                    break;
                }
                ClassLoaderManager.setNotifyToolAboutUnloadedClasses(false);
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
                break;
            }
            case 2: {
                ProfilerInterface.createEventBuffer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Instr. type: " + instrType);
            }
        }
        new InitiateProfilingThread(cmd, targetAppRunning).start();
    }

    public static void instrumentMethods(InstrumentMethodGroupCommand cmd) throws Exception {
        if (!cmd.isEmpty()) {
            try {
                ProfilerInterface.instrumentMethodGroupNow(cmd.getBase());
            }
            catch (Exception ex) {
                ProfilerInterface.deactivateInjectedCode();
                ProfilerInterface.setCurrentInstrType(0);
                throw ex;
            }
        }
        ProfilerInterface.setCurrentInstrType(cmd.getInstrType());
    }

    public static void resetProfilerCollectors() {
        ProfilerRuntime.resetProfilerCollectors(ProfilerInterface.getCurrentInstrType());
        reflectMethods = new WeakHashMap();
    }

    public static void resumeTargetApp() {
        if (ProfilerInterface.getCurrentInstrType() == 3) {
            ProfilerRuntimeCPUFullInstr.resumeActiveTimers();
        }
        Threads.resumeTargetAppThreads(null);
        targetAppSuspended = false;
    }

    public static void suspendTargetApp() {
        Threads.suspendTargetAppThreads(null);
        if (ProfilerInterface.getCurrentInstrType() == 3) {
            ProfilerRuntimeCPUFullInstr.suspendActiveTimers();
        }
        targetAppSuspended = true;
    }

    static void createEventBuffer() throws IOException {
        evBufManager.openBufferFile(1200000);
        ProfilerRuntime.createEventBuffer(1200000);
    }

    static String getBufferFileName() {
        if (evBufManager != null) {
            return evBufManager.getBufferFileName();
        }
        return "";
    }

    static void setDetachStarted(boolean detachStarted) {
        ProfilerInterface.detachStarted = detachStarted;
    }

    static boolean isDetachStarted() {
        return detachStarted;
    }

    static Response computeHistogram() {
        Response resp = null;
        if (Histogram.isAvailable()) {
            resp = heapHistgramManager.computeHistogram(Histogram.getRawHistogram());
        }
        if (resp == null) {
            resp = new Response(HISTOGRAM_NOT_AVAILABLE_MSG);
        }
        return resp;
    }

    static byte[][] getClassFileBytes(String[] classNames, int[] classLoaderIds) {
        int i;
        int MAX_CLASSES = 1000;
        Class[] nonSystemClasses = new Class[MAX_CLASSES + 1];
        int nonSystemIndex = 0;
        byte[][] bytes = new byte[classNames.length][];
        Class[] classes = new Class[classNames.length];
        for (i = 0; i < loadedClassesArray.length; ++i) {
            Class loadedClass = ProfilerInterface.getOrdinaryClass(loadedClassesArray[i]);
            if (loadedClass == null) continue;
            int classLoaderId = loadedClassesLoaders[i];
            String name = loadedClass.getName();
            if (classLoaderId == -1) {
                classLoaderId = 0;
            }
            for (int j = 0; j < classNames.length; ++j) {
                if (classLoaderIds[j] != classLoaderId || !classNames[j].equals(name)) continue;
                classes[j] = loadedClass;
                nonSystemClasses[nonSystemIndex++] = loadedClass;
                break;
            }
            if (nonSystemIndex != MAX_CLASSES) continue;
            ProfilerInterface.cacheLoadedClasses(nonSystemClasses, nonSystemIndex);
            nonSystemIndex = 0;
            profilerServer.sendSimpleCmdToClient(43);
        }
        if (nonSystemIndex > 0) {
            ProfilerInterface.cacheLoadedClasses(nonSystemClasses, nonSystemIndex);
        }
        for (i = 0; i < classes.length; ++i) {
            if (classes[i] == null) continue;
            bytes[i] = ProfilerInterface.getClassFileBytes(classes[i], classLoaderIds[i]);
        }
        return bytes;
    }

    private static boolean getAndInstrumentClasses(boolean rootClassInstrumentation) {
        Response r = profilerServer.getLastResponse();
        if (!(r instanceof InstrumentMethodGroupResponse)) {
            String msg = MessageFormat.format(INTERNAL_ERROR_MSG, r.getClass(), r);
            ProfilerInterface.deactivateInjectedCode();
            profilerServer.sendComplexCmdToClient(new AsyncMessageCommand(false, msg));
            return false;
        }
        InstrumentMethodGroupResponse imgr = (InstrumentMethodGroupResponse)r;
        clientInstrTime += Timers.getCurrentTimeInCounts() - clientInstrStartTime;
        if (!imgr.isOK()) {
            return false;
        }
        if (imgr.isEmpty()) {
            ++nEmptyInstrMethodGroupResponses;
        } else {
            ProfilerInterface.updateInstrClassAndMethodNames(imgr.getBase(), true);
            if (rootClassInstrumentation && ProfilerInterface.getCurrentInstrType() == 6) {
                ThreadInfo.getThreadInfo();
            }
            try {
                ProfilerInterface.instrumentMethodGroupNow(imgr.getBase());
            }
            catch (Exception ex) {
                profilerServer.sendComplexCmdToClient(new AsyncMessageCommand(false, ex.getMessage()));
                return true;
            }
        }
        if (rootClassInstrumentation) {
            switch (ProfilerInterface.getCurrentInstrType()) {
                case 3: {
                    if (instrumentReflection) {
                        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(true);
                    }
                    ProfilerRuntimeCPUFullInstr.enableProfiling(true);
                    break;
                }
                case 4: {
                    if (instrumentReflection) {
                        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(true);
                    }
                    ProfilerRuntimeCPUSampledInstr.enableProfiling(true);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.enableProfiling(true);
                    break;
                }
                case 5: {
                    ProfilerRuntimeObjAlloc.enableProfiling(true);
                    break;
                }
                case 6: {
                    ProfilerRuntimeObjLiveness.enableProfiling(true);
                }
            }
        }
        return true;
    }

    private static boolean isCoreClassName(String name) {
        return (name = name.replace('.', '/')).startsWith("java/") || name.startsWith("sun/") || name.startsWith("javax/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getLoadedClasses() {
        if (loadedClassesArray == null) {
            boolean nonSystemIndex = false;
            int MAX_CLASSES = 1000;
            Class[] nonSystemClasses = new Class[MAX_CLASSES + 1];
            boolean dynamic = profilerServer.isDynamic();
            Class[] allClasses = Classes.getAllLoadedClasses();
            loadedClassesArray = new WeakReference[allClasses.length];
            loadedClassesLoaders = new int[allClasses.length];
            Monitors.DeterminateProgress progress = Monitors.enterServerState(2, loadedClassesArray.length);
            try {
                for (int i = 0; i < loadedClassesArray.length; ++i) {
                    progress.next();
                    if (detachStarted) {
                        return;
                    }
                    Class clazz = allClasses[i];
                    ProfilerInterface.loadedClassesArray[i] = new WeakReference<Class>(clazz);
                    ProfilerInterface.loadedClassesLoaders[i] = ClassLoaderManager.registerLoader(clazz);
                }
            }
            finally {
                Monitors.exitServerState();
            }
        }
    }

    private static boolean isRootClass(String className) {
        for (int i = 0; i < rootClassNames.length; ++i) {
            String rootName = rootClassNames[i];
            if (rootClassNameWildcard[i]) {
                if (className.startsWith(rootName)) {
                    if (rootClassNamePackageWildcard[i]) {
                        return true;
                    }
                    if (className.indexOf(46, rootName.length()) != -1) continue;
                    return true;
                }
                if (!rootClassNamePackageWildcard[i] || !className.equals(rootName.substring(0, rootName.length() - 1))) continue;
                return true;
            }
            if (!rootName.equals(className)) continue;
            return true;
        }
        return false;
    }

    private static void appendTypeName(StringBuffer sb, Class type) {
        if (type.isArray()) {
            do {
                sb.append('[');
            } while ((type = type.getComponentType()).isArray());
        }
        if (type == Integer.TYPE) {
            sb.append('I');
        } else if (type == Boolean.TYPE) {
            sb.append('Z');
        } else if (type == Byte.TYPE) {
            sb.append('B');
        } else if (type == Character.TYPE) {
            sb.append('C');
        } else if (type == Long.TYPE) {
            sb.append('J');
        } else if (type == Float.TYPE) {
            sb.append('F');
        } else if (type == Double.TYPE) {
            sb.append('D');
        } else if (type == Void.TYPE) {
            sb.append('V');
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
    }

    private static boolean checkForLoadedRootClasses() {
        for (int i = 0; i < loadedClassesArray.length; ++i) {
            Class loadedClass = (Class)loadedClassesArray[i].get();
            if (loadedClass == null || !ProfilerInterface.isRootClass(loadedClass.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void classLoadHook(Class clazz) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        ++threadInfo.inProfilingRuntimeMethod;
        try {
            String className = clazz.getName();
            if (instrumentMethodGroupCallThread == Thread.currentThread() || ProfilerInterface.internalClassName(className)) {
                ClassLoaderManager.registerLoader(clazz);
                return;
            }
            Thread currentThread = Thread.currentThread();
            if ("*** Profiler Agent Communication Thread".equals(currentThread.getName())) {
                System.err.println("*** Profiler engine warning: class " + className + " loaded by " + "*** Profiler Agent Communication Thread");
                return;
            }
            if (initInstrumentationThread != null && currentThread == initInstrumentationThread) {
                System.err.println("*** Profiler engine warning: class load hook invoked at inappropriate time for " + className + ", loader = " + clazz.getClassLoader());
                System.err.println("*** This class will not be instrumented unless you re-run the instrumentation command");
                System.err.println("*** Please report this problem to feedback@profiler.netbeans.org");
                System.err.println("=============================== Stack trace =====================");
                Thread.dumpStack();
                System.err.println("=============================== End stack trace =================");
                return;
            }
            int classLoaderId = ClassLoaderManager.registerLoader(clazz);
            boolean resumeTimer = false;
            if (DEBUG) {
                System.err.println("ProfilerInterface.classLoadHook.DEBUG: " + className + ", classLoaderId: " + classLoaderId);
            }
            serialClientOperationsLock.beginTrans(true);
            try {
                boolean rootInstrumented = false;
                String excMessage = null;
                int instrType = ProfilerInterface.getCurrentInstrType();
                if (instrType == 0) {
                    return;
                }
                boolean resumeProfiling = false;
                if (ThreadInfo.profilingSuspended()) {
                    ThreadInfo.suspendProfiling();
                    resumeProfiling = true;
                }
                try {
                    if (rootClassLoaded) {
                        if (instrType != 3 && instrType != 4 && instrType != 5 && instrType != 6) {
                            if (instrType != 1) return;
                            if (!className.equals(rootClassNames[0])) {
                                return;
                            }
                        }
                        ThreadInfo ti = null;
                        if (instrType == 3 || instrType == 4) {
                            ++nClassLoads;
                            ti = ProfilerRuntimeCPU.suspendCurrentThreadTimer();
                            clientInstrStartTime = Timers.getCurrentTimeInCounts();
                            resumeTimer = true;
                        }
                        byte[] classFileBytes = ProfilerInterface.getClassFileBytes(clazz, classLoaderId);
                        ClassLoadedCommand cmd = new ClassLoadedCommand(className, ClassLoaderManager.getThisAndParentLoaderData(classLoaderId), classFileBytes, ti != null ? ti.isInCallGraph() : false);
                        profilerServer.sendComplexCmdToClient(cmd);
                        if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                            ProfilerInterface.disableProfilerHooks();
                            return;
                        }
                    } else {
                        boolean rootWasLoaded;
                        boolean bl = rootWasLoaded = (instrType == 3 || instrType == 4) && ProfilerInterface.status.instrScheme == 3;
                        if (!rootWasLoaded && !ProfilerInterface.isRootClass(className)) {
                            return;
                        }
                        ++nClassLoads;
                        clientInstrStartTime = Timers.getCurrentTimeInCounts();
                        ProfilerInterface.sendRootClassLoadedCommand(true);
                        if (!ProfilerInterface.getAndInstrumentClasses(true)) {
                            ProfilerInterface.disableProfilerHooks();
                            return;
                        }
                        rootInstrumented = true;
                        rootClassLoaded = true;
                        ProfilerCalibrator.resetInternalStatsCollectors();
                    }
                    if (rootInstrumented || excMessage != null) {
                        AsyncMessageCommand cmd = null;
                        cmd = excMessage == null ? new AsyncMessageCommand(true, INSTRUMENTATION_SUCCESSFUL_MSG) : new AsyncMessageCommand(false, excMessage);
                        profilerServer.sendComplexCmdToClient(cmd);
                    }
                }
                finally {
                    if (resumeProfiling) {
                        ThreadInfo.resumeProfiling();
                    }
                }
            }
            finally {
                serialClientOperationsLock.endTrans();
            }
            if (!resumeTimer) return;
            int instrType = ProfilerInterface.getCurrentInstrType();
            if (instrType != 3) {
                if (instrType != 4) return;
            }
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
            return;
        }
        finally {
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    private static void firstTimeMethodInvokeHook(char methodId) {
        serialClientOperationsLock.beginTrans(true);
        try {
            int instrType = ProfilerInterface.getCurrentInstrType();
            if (instrType != 3 && instrType != 4) {
                return;
            }
            clientInstrStartTime = Timers.getCurrentTimeInCounts();
            MethodInvokedFirstTimeCommand cmd = new MethodInvokedFirstTimeCommand(methodId);
            profilerServer.sendComplexCmdToClient(cmd);
            if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                ProfilerInterface.disableProfilerHooks();
                return;
            }
            if (nFirstMethodInvocations == 0) {
                ProfilerCalibrator.resetInternalStatsCollectors();
            }
            ++nFirstMethodInvocations;
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int firstTimeVMObjectAlloc(String className, int definingClassLoaderId) {
        GetClassIdResponse resp;
        if (ProfilerInterface.internalClassName(className)) {
            return -1;
        }
        serialClientOperationsLock.beginTrans(true);
        try {
            GetClassIdCommand cmd = new GetClassIdCommand(className, definingClassLoaderId);
            profilerServer.sendComplexCmdToClient(cmd);
            resp = (GetClassIdResponse)profilerServer.getLastResponse();
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
        if (resp.isOK()) {
            int classId = resp.getClassId();
            int instrClasses = classId + 1;
            if (instrClasses > status.getNInstrClasses()) {
                status.updateAllocatedInstancesCountInfoInServer(instrClasses);
                ProfilerRuntimeMemory.setAllocatedInstancesCountArray(status.getAllocatedInstancesCount());
            }
            return classId;
        }
        return -1;
    }

    private static void handleFakeInitRecursiveInstrumentationCommand() {
        new HFIRIThread().start();
    }

    private static boolean hasAnyCoreClassNames(String[] classes) {
        if (classes.length <= 0) {
            return false;
        }
        for (int i = 0; i < classes.length; ++i) {
            if (!ProfilerInterface.isCoreClassName(classes[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instrumentMethodGroupNow(InstrumentMethodGroupData imgb) throws Exception {
        Monitors.DeterminateProgress wholeProgress = Monitors.enterServerState(1, 2);
        try {
            instrumentMethodGroupCallThread = Thread.currentThread();
            boolean res = false;
            long time = Timers.getCurrentTimeInCounts();
            ++nNonEmptyInstrMethodGroupResponses;
            int nClasses = imgb.getNClasses();
            String[] instrClassNames = imgb.getMethodClasses();
            int[] instrClassLoaders = imgb.getClassLoaderIds();
            int nMethods = imgb.getNMethods();
            Class[] clazzes = new Class[nClasses];
            byte[][] b = imgb.getReplacementClassFileBytes();
            int k = 0;
            Monitors.DeterminateProgress progress = Monitors.enterServerState(2, nClasses);
            try {
                for (int i = 0; i < nClasses; ++i) {
                    progress.next();
                    clazzes[k] = ClassLoaderManager.getLoadedClass(instrClassNames[i], instrClassLoaders[i]);
                    if (clazzes[k] != null) {
                        if (b[k] == null) {
                            if (instrClassLoaders[i] == 0) {
                                b[k] = ClassBytesLoader.getClassFileBytes(instrClassNames[i]);
                            }
                            if (b[k] == null) {
                                b[k] = ProfilerInterface.getCachedClassFileBytes(clazzes[k]);
                            }
                        }
                        ++k;
                        continue;
                    }
                    ProfilerInterface.reportUnloadedClass(instrClassNames[i]);
                    int classesToMove = nClasses - k - 1;
                    System.arraycopy(clazzes, k + 1, clazzes, k, classesToMove);
                    System.arraycopy(b, k + 1, b, k, classesToMove);
                }
                if (k < nClasses) {
                    Class[] oldClazzes = clazzes;
                    clazzes = new Class[k];
                    System.arraycopy(oldClazzes, 0, clazzes, 0, k);
                }
            }
            finally {
                progress = null;
                Monitors.exitServerState();
            }
            wholeProgress.next();
            ProfilerInterface.redefineClasses(clazzes, imgb.getReplacementClassFileBytes());
            time = Timers.getCurrentTimeInCounts() - time;
            totalHotswappingTime += time;
            if (time < minHotswappingTime) {
                minHotswappingTime = time;
            } else if (time > maxHotswappingTime) {
                maxHotswappingTime = time;
            }
            instrumentMethodGroupCallThread = null;
        }
        catch (Throwable t) {
            if (t instanceof Classes.RedefineException) {
                int nClasses = imgb.getNClasses();
                String[] instrClassNames = imgb.getMethodClasses();
                System.err.println("Profiler Agent Error: Redefinition failed for classes:");
                for (int i = 0; i < nClasses; ++i) {
                    System.err.println(instrClassNames[i]);
                }
                System.err.println("Profiler Agent Error: with message: " + ((Classes.RedefineException)t).getMessage());
                byte[][] newBytes = imgb.getReplacementClassFileBytes();
                for (int i = 0; i < nClasses; ++i) {
                    String name = instrClassNames[i];
                    File outFile = new File(name + ".class");
                    System.err.println("Debug: writing class file: " + name + ", into file: " + outFile.getPath());
                    try {
                        FileOutputStream fos = new FileOutputStream(outFile);
                        fos.write(newBytes[i]);
                        fos.close();
                        continue;
                    }
                    catch (IOException exc) {
                        System.err.println("error: " + exc + " writing class file: " + outFile.getPath());
                    }
                }
                throw (Classes.RedefineException)t;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            throw new Exception(MessageFormat.format(UNEXPECTED_EXCEPTION_MSG, t, sw.toString()));
        }
        finally {
            instrumentMethodGroupCallThread = null;
            Monitors.exitServerState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void redefineClasses(Class[] classes, byte[][] bytecode) throws Classes.RedefineException {
        Monitors.DeterminateProgress progress = Monitors.enterServerState(3, (classes.length + 500 - 1) / 500);
        try {
            int size;
            Class[] chunkClasses = null;
            Object chunkBytecode = null;
            for (int index = 0; index < classes.length; index += size) {
                size = Math.min(classes.length - index, 500);
                if (chunkClasses == null || chunkClasses.length != size) {
                    chunkClasses = new Class[size];
                    chunkBytecode = new byte[size][];
                }
                System.arraycopy(classes, index, chunkClasses, 0, size);
                System.arraycopy(bytecode, index, chunkBytecode, 0, size);
                Classes.redefineClasses((Class[])chunkClasses, (byte[][])chunkBytecode);
                progress.next();
            }
        }
        finally {
            Monitors.exitServerState();
        }
    }

    private static boolean internalClassName(String name) {
        return ProfilerInterface.serverInternalClassName(name) || name.startsWith("sun.reflect.") && !name.startsWith("sun.reflect.GeneratedSerializationConstructorAccessor") && !name.startsWith("sun.reflect.GeneratedConstructorAccessor") || name.startsWith("sun.instrument.") || name.equals("com.sun.enterprise.J2EESecurityManager") || name.contains("/");
    }

    static boolean serverInternalClassName(String name) {
        if (INSTRUMENT_JFLUID_CLASSES) {
            return name.startsWith("org.netbeans.lib.profiler.server") || name.startsWith("org.netbeans.lib.profiler.global") || name.startsWith("org.netbeans.lib.profiler.wireprotocol");
        }
        return name.startsWith("org.netbeans.lib.profiler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reflectiveMethodInvokeHook(Method method) {
        serialClientOperationsLock.beginTrans(true);
        try {
            if (reflectMethods.containsKey(method)) {
                return;
            }
            ProfilerRuntimeCPU.suspendCurrentThreadTimer();
            reflectMethods.put(method, null);
            Class<?> clazz = method.getDeclaringClass();
            String className = clazz.getName();
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (int i = 0; i < paramTypes.length; ++i) {
                ProfilerInterface.appendTypeName(sb, paramTypes[i]);
            }
            sb.append(')');
            ProfilerInterface.appendTypeName(sb, method.getReturnType());
            String methodSignature = sb.toString();
            clientInstrStartTime = Timers.getCurrentTimeInCounts();
            MethodLoadedCommand cmd = new MethodLoadedCommand(className, ClassLoaderManager.registerLoader(clazz), methodName, methodSignature);
            profilerServer.sendComplexCmdToClient(cmd);
            if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                ProfilerInterface.disableProfilerHooks();
                return;
            }
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    private static void reportUnloadedClass(String className) {
        System.err.println("*** Profiler engine warning: target VM cannot load class to instrument " + className);
        System.err.println("*** probably it has been unloaded recently");
    }

    private static void reportCacheMiss(byte[] bytes, Class clazz) {
        if (bytes == null) {
            System.err.println("*** Profiler engine warning: Failed to lookup cached class " + clazz.getName());
        }
    }

    private static byte[] getCachedClassFileBytes(Class clazz) {
        byte[] bytes = Classes.getCachedClassFileBytes((Class)clazz);
        ProfilerInterface.reportCacheMiss(bytes, clazz);
        return bytes;
    }

    private static void cacheLoadedClass(Class clazz) {
        Class[] classes = new Class[2];
        classes[0] = clazz;
        ProfilerInterface.cacheLoadedClasses(classes, 1);
    }

    private static void cacheLoadedClasses(Class[] nonSystemClasses, int nonSystemIndex) {
        if (DEBUG) {
            System.out.println("Caching " + nonSystemIndex + " classes");
        }
        nonSystemClasses[nonSystemIndex++] = InitiateProfilingThread.class;
        Classes.cacheLoadedClasses((Class[])nonSystemClasses, (int)nonSystemIndex);
    }

    private static byte[] getClassFileBytes(Class clazz, int classLoaderId) {
        return ProfilerInterface.getClassFileBytes(clazz, classLoaderId, true);
    }

    private static byte[] getClassFileBytes(Class clazz, int classLoaderId, boolean force) {
        byte[] classFileBytes = null;
        URL classURL = null;
        if (classLoaderId > 0 || (classURL = ClassBytesLoader.getClassFileURL(clazz.getName())) == null) {
            classFileBytes = Classes.getCachedClassFileBytes((Class)clazz);
            if (classFileBytes == null) {
                if (DEBUG) {
                    System.err.println("Cannot get classbytes for " + clazz.getName() + " loader " + classLoaderId);
                }
                if (!force) {
                    return EMPTY;
                }
                ProfilerInterface.cacheLoadedClass(clazz);
                classFileBytes = ProfilerInterface.getCachedClassFileBytes(clazz);
                if (classFileBytes == null && Platform.getJDKVersionNumber() != 5) {
                    System.err.println("***Profiler agent warning: could not get .class file for a synthetic class " + clazz.getName() + " in ProfilerInterface.getClassFileBytes");
                }
            }
        } else if (ProfilerInterface.status.remoteProfiling || Platform.getJDKVersionNumber() == 7) {
            classFileBytes = ClassBytesLoader.getClassFileBytes(classURL);
        }
        return classFileBytes;
    }

    private static void sendRootClassLoadedCommand(boolean doGetLoadedClasses) {
        Class clazz;
        int i;
        if (doGetLoadedClasses) {
            ProfilerInterface.getLoadedClasses();
        }
        int len = loadedClassesArray.length;
        String[] loadedClassNames = new String[len];
        int[] loaders = new int[len];
        byte[][] cachedClassFileBytes = new byte[len][];
        int[] loadedClassesSuper = new int[len];
        int[][] loadedClassesInterfaces = new int[len][];
        int instrType = ProfilerInterface.getCurrentInstrType();
        boolean isLazyInstrType = profilerServer.isDynamic() && (instrType == 3 || instrType == 4) && ProfilerInterface.status.instrScheme == 1 && !instrSpawnedThreads;
        boolean isMemoryProfiling = profilerServer.isDynamic() && (instrType == 5 || instrType == 6);
        HashMap<Class, Integer> classIndex = new HashMap<Class, Integer>(loadedClassesArray.length * 4 / 3);
        Class[] classesArray = new Class[len];
        for (i = 0; i < len; ++i) {
            clazz = ProfilerInterface.getOrdinaryClass(loadedClassesArray[i]);
            if (clazz == null) continue;
            int index = classIndex.size();
            classesArray[index] = clazz;
            loaders[index] = loadedClassesLoaders[i];
            classIndex.put(clazz, new Integer(index));
        }
        for (i = 0; i < classIndex.size(); ++i) {
            Integer clsId;
            clazz = classesArray[i];
            String name = clazz.getName();
            boolean forceClassFile = !isLazyInstrType && !isMemoryProfiling || ProfilerInterface.isRootClass(name);
            loadedClassNames[i] = name;
            cachedClassFileBytes[i] = ProfilerInterface.getClassFileBytes(clazz, loaders[i], forceClassFile);
            if (forceClassFile) continue;
            Class superClass = clazz.getSuperclass();
            Class<?>[] interfaces = clazz.getInterfaces();
            loadedClassesSuper[i] = superClass != null ? ((clsId = (Integer)classIndex.get(superClass)) != null ? clsId : -1) : -1;
            loadedClassesInterfaces[i] = new int[interfaces.length];
            for (int j = 0; j < interfaces.length; ++j) {
                Integer clsId2 = (Integer)classIndex.get(interfaces[j]);
                if (clsId2 != null) {
                    loadedClassesInterfaces[i][j] = clsId2;
                    continue;
                }
                loadedClassesSuper[i] = -1;
            }
        }
        RootClassLoadedCommand cmd = new RootClassLoadedCommand(loadedClassNames, loaders, cachedClassFileBytes, loadedClassesSuper, loadedClassesInterfaces, classIndex.size(), ClassLoaderManager.getParentLoaderIdTable());
        profilerServer.sendComplexCmdToClient(cmd);
    }

    private static Class getOrdinaryClass(WeakReference classRef) {
        String name;
        Class clazz = (Class)classRef.get();
        if (clazz != null && !(name = clazz.getName()).startsWith("[") && !ProfilerInterface.internalClassName(name)) {
            return clazz;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateInstrClassAndMethodNames(InstrumentMethodGroupData imgb, boolean firstTime) {
        status.beginTrans(false);
        try {
            switch (ProfilerInterface.getCurrentInstrType()) {
                case 3: 
                case 4: {
                    status.updateInstrMethodsInfo(imgb.getNClasses(), imgb.getNMethods(), null, null, null, null, null, imgb.getInstrMethodLeaf());
                    ProfilerRuntimeCPU.setInstrMethodsInvoked(status.getInstrMethodInvoked());
                    return;
                }
                case 5: 
                case 6: {
                    status.updateAllocatedInstancesCountInfoInServer(imgb.getAddInfo());
                    ProfilerRuntimeMemory.setAllocatedInstancesCountArray(status.getAllocatedInstancesCount());
                    return;
                }
            }
            return;
        }
        finally {
            status.endTrans();
        }
    }

    static /* synthetic */ String[] access$202(String[] x0) {
        rootClassNames = x0;
        return x0;
    }

    static /* synthetic */ WeakReference[] access$502(WeakReference[] x0) {
        loadedClassesArray = x0;
        return x0;
    }

    static /* synthetic */ int[] access$602(int[] x0) {
        loadedClassesLoaders = x0;
        return x0;
    }

    static /* synthetic */ boolean[] access$1402(boolean[] x0) {
        rootClassNameWildcard = x0;
        return x0;
    }

    static /* synthetic */ boolean[] access$1502(boolean[] x0) {
        rootClassNamePackageWildcard = x0;
        return x0;
    }

    static {
        ResourceBundle messages = ProfilerServer.getProfilerServerResourceBundle();
        if (messages != null) {
            INTERNAL_ERROR_MSG = messages.getString("ProfilerInterface_InternalErrorMsg");
            UNEXPECTED_EXCEPTION_MSG = messages.getString("ProfilerInterface_UnexpectedExceptionMsg");
            INSTRUMENTATION_SUCCESSFUL_MSG = messages.getString("ProfilerInterface_InstrumentationSuccessfulMsg");
            HISTOGRAM_NOT_AVAILABLE_MSG = messages.getString("ProfilerInterface_HistogramNotAvailableMsg");
        }
        DEBUG = Boolean.getBoolean("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook");
        INSTRUMENT_JFLUID_CLASSES = Boolean.getBoolean("org.netbeans.lib.profiler.server.instrumentJFluidClasses");
        EMPTY = new byte[0];
        serialClientOperationsLock = new TransactionalSupport();
        targetAppSuspended = false;
        instrumentReflection = false;
        minHotswappingTime = 10000000000L;
    }

    private static class InitiateProfilingThread
    extends Thread {
        private InitiateProfilingCommand cmd;
        private boolean targetAppRunning;

        InitiateProfilingThread(InitiateProfilingCommand cmd, boolean targetAppRunning) {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 2");
            this.cmd = cmd;
            this.targetAppRunning = targetAppRunning;
        }

        public void run() {
            Monitors.enterServerState(1);
            serialClientOperationsLock.beginTrans(true);
            try {
                initInstrumentationThread = Thread.currentThread();
                int instrType = this.cmd.getInstrType();
                ProfilerInterface.setCurrentInstrType(instrType);
                switch (instrType) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        ProfilerRuntimeSampler.initialize();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.initiateInstrumentation(instrType);
                        break;
                    }
                    case 7: {
                        if (!Histogram.initialize((Platform.getJDKVersionNumber() >= 7 ? 1 : 0) != 0)) break;
                        profilerServer;
                        ProfilerServer.notifyClientOnResultsAvailability();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Instr. type: " + instrType);
                    }
                }
                initInstrumentationThread = null;
            }
            finally {
                serialClientOperationsLock.endTrans();
                Monitors.exitServerState();
            }
            ThreadInfo.removeProfilerServerThread(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initiateInstrumentation(int instrType) {
            Monitors.DeterminateProgress progress = Monitors.enterServerState(1, 2);
            int[] profilingPointIDs = this.cmd.getProfilingPointIDs();
            String[] handlers = this.cmd.getProfilingPointHandlers();
            String[] infos = this.cmd.getProfilingPointInfos();
            ProfilerInterface.access$202(this.cmd.getRootClassNames());
            status.startProfilingPointsActive = this.cmd.isStartProfilingPointsActive();
            ProfilingPointServerHandler.initInstances(profilingPointIDs, handlers, infos);
            InitiateProfilingThread.computeRootWildcard();
            rootClassLoaded = false;
            new LinkedHashMap().keySet().iterator();
            try {
                Class.forName("java.lang.reflect.InvocationTargetException");
                Class.forName("java.lang.InterruptedException");
                Class.forName("java.lang.ClassFormatError");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
            }
            if (Platform.getJDKVersionNumber() == 7) {
                try {
                    Class.forName("java.lang.reflect.WeakPairMap$Pair");
                    Class.forName("java.lang.reflect.WeakPairMap$WeakRefPeer");
                    Class.forName("java.lang.reflect.WeakPairMap$Pair$Weak");
                    Class.forName("java.lang.reflect.WeakPairMap$Pair$Weak$1");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace(System.err);
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            InitiateProfilingThread e = this;
            synchronized (e) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ProfilerInterface.access$502(null);
            ProfilerInterface.access$602(null);
            Classes.enableClassLoadHook();
            instrSpawnedThreads = this.cmd.getInstrSpawnedThreads();
            if (this.targetAppRunning || ProfilerInterface.hasAnyCoreClassNames(this.cmd.getRootClassNames()) || instrSpawnedThreads || instrType == 5 || instrType == 6) {
                ProfilerInterface.getLoadedClasses();
                boolean loadedRootClassesExist = false;
                if (!detachStarted) {
                    switch (instrType) {
                        case 3: 
                        case 4: {
                            loadedRootClassesExist = instrSpawnedThreads ? true : ProfilerInterface.checkForLoadedRootClasses();
                            break;
                        }
                        case 1: {
                            loadedRootClassesExist = ProfilerInterface.checkForLoadedRootClasses();
                            break;
                        }
                        case 5: 
                        case 6: {
                            loadedRootClassesExist = true;
                        }
                    }
                }
                progress.next();
                if (loadedRootClassesExist) {
                    ProfilerInterface.sendRootClassLoadedCommand(false);
                    if (!ProfilerInterface.getAndInstrumentClasses(true)) {
                        ProfilerInterface.disableProfilerHooks();
                    }
                    rootClassLoaded = true;
                } else {
                    ProfilerInterface.access$502(null);
                    ProfilerInterface.access$602(null);
                }
            }
            Monitors.exitServerState();
        }

        private static void computeRootWildcard() {
            ProfilerInterface.access$1402(new boolean[rootClassNames.length]);
            ProfilerInterface.access$1502(new boolean[rootClassNames.length]);
            for (int i = 0; i < rootClassNames.length; ++i) {
                int nameLen = rootClassNames[i].length();
                boolean bl = rootClassNameWildcard[i] = nameLen == 0 || rootClassNames[i].charAt(nameLen - 1) == '.';
                if (rootClassNameWildcard[i] || rootClassNames[i].charAt(nameLen - 1) != '*') continue;
                rootClassNames[i] = rootClassNames[i].substring(0, nameLen - 1);
                rootClassNameWildcard[i] = true;
                rootClassNamePackageWildcard[i] = true;
            }
        }
    }

    private static class HFIRIThread
    extends Thread {
        HFIRIThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 1");
            this.setDaemon(true);
        }

        public void run() {
            RootClassLoadedCommand cmd = new RootClassLoadedCommand(new String[]{"*FAKE_CLASS_1*", "*FAKE_CLASS_2*"}, new int[]{0, 0}, null, new int[]{0, 0}, new int[2][], 2, new int[]{-1});
            profilerServer.sendComplexCmdToClient(cmd);
            profilerServer;
            InstrumentMethodGroupResponse imgr = (InstrumentMethodGroupResponse)ProfilerServer.getLastResponse();
            ThreadInfo.removeProfilerServerThread(this);
        }
    }
}

