/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.jvnet.winp.Native;
import org.jvnet.winp.NotWindowsException;
import org.jvnet.winp.WinpException;

public class WinProcess {
    private final int pid;
    private String commandline;
    private TreeMap<String, String> envVars;
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string.toUpperCase().compareTo(string2.toUpperCase());
        }
    };

    public WinProcess(int n) {
        this.pid = n;
    }

    public WinProcess(Process process) {
        try {
            Field field = process.getClass().getDeclaredField("handle");
            field.setAccessible(true);
            int n = ((Number)field.get(process)).intValue();
            this.pid = Native.getProcessId(n);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NotWindowsException(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NotWindowsException(illegalAccessException);
        }
    }

    public int getPid() {
        return this.pid;
    }

    public void killRecursively() {
        Native.kill(this.pid, true);
    }

    public void kill() {
        Native.kill(this.pid, false);
    }

    public void setPriority(int n) {
        Native.setPriority(this.pid, n);
    }

    public synchronized String getCommandLine() {
        if (this.commandline == null) {
            this.parseCmdLineAndEnvVars();
        }
        return this.commandline;
    }

    public synchronized TreeMap<String, String> getEnvironmentVariables() {
        if (this.envVars == null) {
            this.parseCmdLineAndEnvVars();
        }
        return this.envVars;
    }

    private void parseCmdLineAndEnvVars() {
        String string = Native.getCmdLineAndEnvVars(this.pid);
        if (string == null) {
            throw new WinpException("Failed to obtain for PID=" + this.pid);
        }
        int n = string.indexOf(0);
        this.commandline = string.substring(0, n);
        this.envVars = new TreeMap(CASE_INSENSITIVE_COMPARATOR);
        string = string.substring(n + 1);
        while (string.length() > 0) {
            String string2;
            n = string.indexOf(0);
            if (n == 0) {
                return;
            }
            if (n == -1) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            if ((n = string2.indexOf(61)) == -1) continue;
            this.envVars.put(string2.substring(0, n), string2.substring(n + 1));
        }
    }

    public static Iterable<WinProcess> all() {
        return new Iterable<WinProcess>(){

            @Override
            public Iterator<WinProcess> iterator() {
                return new Iterator<WinProcess>(){
                    private int pos = 0;
                    private int[] pids = new int[256];
                    private int total;
                    {
                        while (true) {
                            this.total = Native.enumProcesses(this.pids);
                            if (this.total == 0) {
                                throw new WinpException("Failed to enumerate processes");
                            }
                            if (this.total < this.pids.length) break;
                            this.pids = new int[this.pids.length * 2];
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < this.total;
                    }

                    @Override
                    public WinProcess next() {
                        return new WinProcess(this.pids[this.pos++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void enableDebugPrivilege() {
        Native.enableDebugPrivilege();
    }
}

