/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

class Native {
    private static final Logger LOGGER = Logger.getLogger(Native.class.getName());
    private static final String DLL_TARGET = "winp.folder.preferred";

    Native() {
    }

    static native boolean kill(int var0, boolean var1);

    static native int setPriority(int var0, int var1);

    static native int getProcessId(int var0);

    static native boolean exitWindowsEx(int var0, int var1);

    static native String getCmdLineAndEnvVars(int var0);

    static native int enumProcesses(int[] var0);

    static native void enableDebugPrivilege();

    static native void noop();

    private static void load() {
        boolean bl = "64".equals(System.getProperty("sun.arch.data.model"));
        String string = bl ? "winp.x64" : "winp";
        URL uRL = Native.class.getClassLoader().getResource(string + ".dll");
        if (uRL != null) {
            String string2 = uRL.toExternalForm();
            if (string2.startsWith("jar:") || string2.startsWith("wsjar:")) {
                int n = string2.lastIndexOf(33);
                String string3 = string2.substring(string2.indexOf(58) + 1, n);
                while (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("file:/")) {
                    if ((string3 = string3.substring(6)).startsWith("//")) {
                        string3 = string3.substring(2);
                    }
                    string3 = URLDecoder.decode(string3);
                    String string4 = System.getProperty(DLL_TARGET);
                    File file = new File(string3);
                    File file2 = new File(string4 != null ? new File(string4) : file.getParentFile(), string + ".dll");
                    if (!file2.exists() || file.lastModified() > file2.lastModified()) {
                        try {
                            Native.copyStream(uRL.openStream(), new FileOutputStream(file2));
                            file2.setLastModified(file.lastModified());
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.WARNING, "Failed to write " + string + ".dll", iOException);
                        }
                    }
                    Native.loadDll(file2);
                    return;
                }
            }
            if (string2.startsWith("file:")) {
                File file;
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(uRL.getPath());
                }
                Native.loadDll(file);
                return;
            }
        }
        try {
            System.loadLibrary(string);
        }
        catch (Throwable throwable) {
            if (uRL != null) {
                File file = null;
                try {
                    file = File.createTempFile(string, "dll");
                    Native.copyStream(uRL.openStream(), new FileOutputStream(file));
                    Native.loadDll(file);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Failed to write " + string + ".dll", iOException);
                }
                catch (LinkageError linkageError) {
                    LOGGER.log(Level.WARNING, "Failed to load winp.dll from " + file, linkageError);
                }
            }
            UnsatisfiedLinkError unsatisfiedLinkError = new UnsatisfiedLinkError("Unable to load " + string + ".dll");
            unsatisfiedLinkError.initCause(throwable);
            throw unsatisfiedLinkError;
        }
    }

    private static void loadDll(File file) {
        try {
            System.load(file.getPath());
        }
        catch (LinkageError linkageError) {
            for (int i = 0; i < 5; ++i) {
                try {
                    System.gc();
                    System.gc();
                    Thread.sleep(1000L);
                    System.load(file.getPath());
                    return;
                }
                catch (InterruptedException interruptedException) {
                    throw linkageError;
                }
                catch (LinkageError linkageError2) {
                    continue;
                }
            }
            throw linkageError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    static {
        Native.load();
    }
}

