/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.client;

import java.io.Console;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.client.AbstractClient;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.TException;

public class WinClient
extends AbstractClient {
    private static CommandLine commandLine;

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Options options = WinClient.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(88);
        commandLine = null;
        if (args == null || args.length == 0) {
            WinClient.println("Require more params input, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            return;
        }
        WinClient.init();
        String[] newArgs = WinClient.removePasswordArgs(args);
        boolean continues = WinClient.parseCommandLine(options, newArgs, hf);
        if (!continues) {
            return;
        }
        WinClient.serve();
    }

    private static String readPassword() {
        Console c = System.console();
        if (c == null) {
            WinClient.print("IoTDB> please input password: ");
            Scanner scanner = new Scanner(System.in);
            return scanner.nextLine();
        }
        return new String(c.readPassword("IoTDB> please input password: ", new Object[0]));
    }

    private static boolean parseCommandLine(Options options, String[] newArgs, HelpFormatter hf) {
        try {
            DefaultParser parser = new DefaultParser();
            commandLine = parser.parse(options, newArgs);
            if (commandLine.hasOption("help")) {
                hf.printHelp("IoTDB", options, true);
                return false;
            }
            if (commandLine.hasOption("disableISO8601")) {
                WinClient.setTimeFormat("long");
            }
            if (commandLine.hasOption("maxPRC") && (maxPrintRowCount = Integer.valueOf(commandLine.getOptionValue("maxPRC")).intValue()) < 0) {
                maxPrintRowCount = Integer.MAX_VALUE;
            }
        }
        catch (ParseException e) {
            WinClient.println("Require more params input, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            WinClient.handleException((Exception)((Object)e));
            return false;
        }
        catch (NumberFormatException e) {
            WinClient.println("IoTDB> error format of max print row count, it should be number");
            WinClient.handleException(e);
            return false;
        }
        return true;
    }

    private static void serve() {
        try (Scanner scanner = new Scanner(System.in);){
            host = WinClient.checkRequiredArg("h", "host", commandLine, false, host);
            port = WinClient.checkRequiredArg("p", "port", commandLine, false, port);
            username = WinClient.checkRequiredArg("u", "username", commandLine, true, null);
            password = commandLine.getOptionValue("pw");
            if (password == null) {
                password = WinClient.readPassword();
            }
            WinClient.receiveCommands(scanner);
        }
        catch (ArgsErrorException e) {
            WinClient.println("IoTDB> input params error because" + e.getMessage());
            WinClient.handleException(e);
        }
        catch (Exception e) {
            WinClient.println("IoTDB> exit client with error " + e.getMessage());
            WinClient.handleException(e);
        }
    }

    private static void receiveCommands(Scanner scanner) throws TException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);){
            String s;
            boolean continues;
            properties = connection.getServerProperties();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            TIMESTAMP_PRECISION = properties.getTimestampPrecision();
            WinClient.displayLogo(properties.getVersion());
            WinClient.println("IoTDB> login successfully");
            do {
                WinClient.print("IoTDB> ");
            } while (continues = WinClient.processCommand(s = scanner.nextLine(), connection));
        }
        catch (SQLException e) {
            WinClient.println(String.format("%s> %s Host is %s, port is %s.", "IoTDB", e.getMessage(), host, port));
            WinClient.handleException(e);
        }
    }

    private static boolean processCommand(String s, IoTDBConnection connection) {
        if (s == null) {
            return true;
        }
        String[] cmds = s.trim().split(";");
        block4: for (int i = 0; i < cmds.length; ++i) {
            String cmd = cmds[i];
            if (cmd == null || "".equals(cmd.trim())) continue;
            AbstractClient.OperationResult result = WinClient.handleInputCmd(cmd, connection);
            switch (result) {
                case STOP_OPER: {
                    return false;
                }
                case CONTINUE_OPER: {
                    continue block4;
                }
            }
        }
        return true;
    }
}

