/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBQueryResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.rpc.IoTDBRPCException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSOperationHandle;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.service.rpc.thrift.TS_SessionHandle;
import org.apache.thrift.TException;

public class IoTDBStatement
implements Statement {
    private static final String SHOW_TIMESERIES_COMMAND_LOWERCASE = "show timeseries";
    private static final String SHOW_STORAGE_GROUP_COMMAND_LOWERCASE = "show storage group";
    private static final String SHOW_DEVICES_COMMAND_LOWERCASE = "show devices";
    private static final String SHOW_CHILD_PATHS_COMMAND_LOWERCASE = "show child paths";
    private static final String COUNT_TIMESERIES_COMMAND_LOWERCASE = "count timeseries";
    private static final String COUNT_NODES_COMMAND_LOWERCASE = "count nodes";
    private static final String METHOD_NOT_SUPPORTED_STRING = "Method not supported";
    private static final String SHOW_VERSION_COMMAND_LOWERCASE = "show version";
    ZoneId zoneId;
    private ResultSet resultSet = null;
    private IoTDBConnection connection;
    private int fetchSize;
    private int queryTimeout = 10;
    protected TSIService.Iface client;
    private TS_SessionHandle sessionHandle;
    private TSOperationHandle operationHandle = null;
    private List<String> batchSQLList;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    long stmtId = -1L;

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, int fetchSize, ZoneId zoneId) throws SQLException {
        this.connection = connection;
        this.client = client;
        this.sessionHandle = sessionHandle;
        this.fetchSize = fetchSize;
        this.batchSQLList = new ArrayList<String>();
        this.zoneId = zoneId;
        this.requestStmtId();
    }

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, ZoneId zoneId, long statementId) throws SQLException {
        this.connection = connection;
        this.client = client;
        this.sessionHandle = sessionHandle;
        this.fetchSize = Config.fetchSize;
        this.batchSQLList = new ArrayList<String>();
        this.zoneId = zoneId;
        this.stmtId = statementId;
    }

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, ZoneId zoneId) throws SQLException {
        this(connection, client, sessionHandle, Config.fetchSize, zoneId);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public void addBatch(String sql) {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.operationHandle != null) {
                TSCancelOperationReq closeReq = new TSCancelOperationReq(this.operationHandle);
                TSStatus closeResp = this.client.cancelOperation(closeReq);
                RpcUtils.verifySuccess((TSStatus)closeResp);
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when canceling statement.", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.clear();
    }

    @Override
    public void clearWarnings() {
        this.warningChain = null;
    }

    private void closeClientOperation() throws SQLException {
        try {
            if (this.operationHandle != null) {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.operationHandle, -1L);
                closeReq.setStmtId(this.stmtId);
                TSStatus closeResp = this.client.closeOperation(closeReq);
                RpcUtils.verifySuccess((TSStatus)closeResp);
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when closing statement.", e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkConnection("execute");
        this.isClosed = false;
        try {
            return this.executeSQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException(String.format("Fail to execute %s after reconnecting. please check server status", sql), e2);
                }
            }
            throw new SQLException(String.format("Fail to reconnect to server when executing %s. please check server status", sql), e);
        }
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    private boolean executeSQL(String sql) throws TException, SQLException {
        this.isCancelled = false;
        String sqlToLowerCase = sql.toLowerCase().trim();
        if (sqlToLowerCase.startsWith(SHOW_TIMESERIES_COMMAND_LOWERCASE)) {
            if (sqlToLowerCase.equals(SHOW_TIMESERIES_COMMAND_LOWERCASE)) {
                DatabaseMetaData databaseMetaData = this.connection.getMetaData();
                this.resultSet = databaseMetaData.getColumns("ts", "root", null, null);
                return true;
            }
            String[] cmdSplit = sql.split("\\s+");
            if (cmdSplit.length != 3) {
                throw new SQLException("Error format of 'SHOW TIMESERIES <PATH>'");
            }
            String path = cmdSplit[2];
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            this.resultSet = databaseMetaData.getColumns("ts", path, null, null);
            return true;
        }
        if (sqlToLowerCase.equals(SHOW_STORAGE_GROUP_COMMAND_LOWERCASE)) {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            this.resultSet = databaseMetaData.getColumns("sg", null, null, null);
            return true;
        }
        if (sqlToLowerCase.startsWith(SHOW_CHILD_PATHS_COMMAND_LOWERCASE)) {
            if (sqlToLowerCase.equals(SHOW_CHILD_PATHS_COMMAND_LOWERCASE)) {
                DatabaseMetaData databaseMetaData = this.connection.getMetaData();
                this.resultSet = databaseMetaData.getColumns("cp", "root", null, null);
                return true;
            }
            String[] cmdSplit = sql.split("\\s+");
            if (cmdSplit.length != 4) {
                throw new SQLException("Error format of 'SHOW CHILD PATHS <PATH>'");
            }
            String path = cmdSplit[3];
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            this.resultSet = databaseMetaData.getColumns("cp", path, null, null);
            return true;
        }
        if (sqlToLowerCase.equals(SHOW_DEVICES_COMMAND_LOWERCASE)) {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            this.resultSet = databaseMetaData.getColumns("devices", null, null, null);
            return true;
        }
        if (sqlToLowerCase.startsWith(COUNT_TIMESERIES_COMMAND_LOWERCASE)) {
            String[] cmdSplit = sqlToLowerCase.split("\\s+", 4);
            if (!(cmdSplit.length == 3 || cmdSplit.length == 4 && cmdSplit[3].startsWith("group by level"))) {
                throw new SQLException("Error format of 'COUNT TIMESERIES <PATH>' or 'COUNT TIMESERIES <PATH> GROUP BY LEVEL=<INTEGER>'");
            }
            if (cmdSplit.length == 3) {
                String path = cmdSplit[2];
                DatabaseMetaData databaseMetaData = this.connection.getMetaData();
                this.resultSet = databaseMetaData.getColumns("cntts", path, null, null);
                return true;
            }
            String path = cmdSplit[2];
            int level = Integer.parseInt(cmdSplit[3].replaceAll(" ", "").substring(13));
            IoTDBDatabaseMetadata databaseMetadata = (IoTDBDatabaseMetadata)this.connection.getMetaData();
            this.resultSet = databaseMetadata.getNodes("cntnodets", path, null, null, level);
            return true;
        }
        if (sqlToLowerCase.startsWith(COUNT_NODES_COMMAND_LOWERCASE)) {
            String[] cmdSplit = sqlToLowerCase.split("\\s+", 4);
            if (cmdSplit.length != 4 || !cmdSplit[3].startsWith("level")) {
                throw new SQLException("Error format of 'COUNT NODES <PATH> LEVEL=<INTEGER>'");
            }
            String path = cmdSplit[2];
            int level = Integer.parseInt(cmdSplit[3].replaceAll(" ", "").substring(6));
            IoTDBDatabaseMetadata databaseMetaData = (IoTDBDatabaseMetadata)this.connection.getMetaData();
            this.resultSet = databaseMetaData.getNodes("cntnode", path, null, null, level);
            return true;
        }
        if (sqlToLowerCase.equals(SHOW_VERSION_COMMAND_LOWERCASE)) {
            IoTDBDatabaseMetadata databaseMetadata = (IoTDBDatabaseMetadata)this.connection.getMetaData();
            this.resultSet = databaseMetadata.getColumns("version", null, null, null);
            return true;
        }
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionHandle, sql, this.stmtId);
        TSExecuteStatementResp execResp = this.client.executeStatement(execReq);
        this.operationHandle = execResp.getOperationHandle();
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (IoTDBRPCException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        if (execResp.getOperationHandle().hasResultSet) {
            this.resultSet = new IoTDBQueryResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.ignoreTimeStamp, this.client, this.operationHandle, sql, this.operationHandle.getOperationId().getQueryId());
            return true;
        }
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkConnection("executeBatch");
        this.isClosed = false;
        try {
            return this.executeBatchSQL();
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeBatchSQL();
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute batch sqls after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when executing batch sqls. please check server status", e);
        }
    }

    private int[] executeBatchSQL() throws TException, SQLException {
        BatchUpdateException exception;
        this.isCancelled = false;
        TSExecuteBatchStatementReq execReq = new TSExecuteBatchStatementReq(this.sessionHandle, this.batchSQLList);
        TSExecuteBatchStatementResp execResp = this.client.executeBatchStatement(execReq);
        if (execResp.getStatus().getStatusType().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (execResp.getResult() == null) {
                return new int[0];
            }
            List result = execResp.getResult();
            int len = result.size();
            int[] updateArray = new int[len];
            for (int i = 0; i < len; ++i) {
                updateArray[i] = (Integer)result.get(i);
            }
            return updateArray;
        }
        if (execResp.getResult() == null) {
            exception = new BatchUpdateException(execResp.getStatus().getStatusType().getMessage(), new int[0]);
        } else {
            List result = execResp.getResult();
            int len = result.size();
            int[] updateArray = new int[len];
            for (int i = 0; i < len; ++i) {
                updateArray[i] = (Integer)result.get(i);
            }
            exception = new BatchUpdateException(execResp.getStatus().getStatusType().getMessage(), updateArray);
        }
        throw exception;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkConnection("execute query");
        this.isClosed = false;
        try {
            return this.executeQuerySQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeQuerySQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to executeQuery " + sql + "after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when execute query " + sql + ". please check server status", e);
        }
    }

    private ResultSet executeQuerySQL(String sql) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionHandle, sql, this.stmtId);
        TSExecuteStatementResp execResp = this.client.executeQueryStatement(execReq);
        this.operationHandle = execResp.getOperationHandle();
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (IoTDBRPCException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        this.resultSet = new IoTDBQueryResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.ignoreTimeStamp, this.client, this.operationHandle, sql, this.operationHandle.getOperationId().getQueryId());
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkConnection("execute update");
        this.isClosed = false;
        try {
            return this.executeUpdateSQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeUpdateSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute update " + sql + "after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when execute update " + sql + ". please check server status", e);
        }
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    private int executeUpdateSQL(String sql) throws TException, IoTDBSQLException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionHandle, sql, this.stmtId);
        TSExecuteStatementResp execResp = this.client.executeUpdateStatement(execReq);
        this.operationHandle = execResp.getOperationHandle();
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (IoTDBRPCException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        return 0;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException(String.format("direction %d is not supported!", direction));
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.checkConnection("setFetchSize");
        if (fetchSize < 0) {
            throw new SQLException(String.format("fetchSize %d must be >= 0!", fetchSize));
        }
        this.fetchSize = fetchSize == 0 ? Config.fetchSize : fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int num) throws SQLException {
        this.checkConnection("setMaxRows");
        if (num < 0) {
            throw new SQLException(String.format("maxRows %d must be >= 0!", num));
        }
        this.maxRows = num;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkConnection("setQueryTimeout");
        if (seconds <= 0) {
            throw new SQLException(String.format("queryTimeout %d must be >= 0!", seconds));
        }
        this.queryTimeout = seconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    private void checkConnection(String action) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException(String.format("Cannot %s after connection has been closed!", action));
        }
    }

    private void reInit() {
        this.client = this.connection.client;
        this.sessionHandle = this.connection.sessionHandle;
    }

    private void requestStmtId() throws SQLException {
        try {
            this.stmtId = this.client.requestStatementId();
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    this.stmtId = this.client.requestStatementId();
                }
                catch (TException e2) {
                    throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e);
        }
    }

    private boolean reConnect() {
        boolean flag = this.connection.reconnect();
        this.reInit();
        return flag;
    }
}

