/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchLogReader
implements ILogReader {
    private static Logger logger = LoggerFactory.getLogger(BatchLogReader.class);
    private Iterator<PhysicalPlan> planIterator;
    private boolean fileCorrupted = false;

    BatchLogReader(ByteBuffer buffer) {
        List<PhysicalPlan> logs = this.readLogs(buffer);
        this.planIterator = logs.iterator();
    }

    private List<PhysicalPlan> readLogs(ByteBuffer buffer) {
        ArrayList<PhysicalPlan> plans = new ArrayList<PhysicalPlan>();
        while (buffer.position() != buffer.limit()) {
            try {
                plans.add(PhysicalPlan.Factory.create(buffer));
            }
            catch (IOException e) {
                logger.error("Cannot deserialize PhysicalPlans from ByteBuffer, ignore remaining logs", (Throwable)e);
                this.fileCorrupted = true;
                break;
            }
        }
        return plans;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.planIterator.hasNext();
    }

    @Override
    public PhysicalPlan next() {
        return this.planIterator.next();
    }

    public boolean isFileCorrupted() {
        return this.fileCorrupted;
    }
}

