/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtils {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeUtils.class);
    private static final String TMP_STRING = "tmp";
    private static final String UPGRADE_FILE_PREFIX = "upgrade_";
    private static final String COMMA_SEPERATOR = ",";
    private static final ReadWriteLock cntUpgradeFileLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock upgradeLogLock = new ReentrantReadWriteLock();

    public static ReadWriteLock getCntUpgradeFileLock() {
        return cntUpgradeFileLock;
    }

    public static ReadWriteLock getUpgradeLogLock() {
        return upgradeLogLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNeedUpgrade(TsFileResource tsFileResource) {
        tsFileResource.getWriteQueryLock().readLock().lock();
        try (TsFileSequenceReader tsFileSequenceReader = new TsFileSequenceReader(tsFileResource.getFile().getAbsolutePath());){
            if (tsFileSequenceReader.readVersionNumber().equals("v0.8.0")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("meet error when judge whether file needs to be upgraded, the file's path:{}", (Object)tsFileResource.getFile().getAbsolutePath(), (Object)e);
        }
        finally {
            tsFileResource.getWriteQueryLock().readLock().unlock();
        }
        return false;
    }

    public static String getUpgradeFileName(File upgradeResource) {
        return upgradeResource.getParentFile().getParent() + File.separator + TMP_STRING + File.separator + UPGRADE_FILE_PREFIX + upgradeResource.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverUpgrade() {
        if (FSFactoryProducer.getFSFactory().getFile(UpgradeLog.getUpgradeLogPath()).exists()) {
            try (BufferedReader upgradeLogReader = new BufferedReader(new FileReader(FSFactoryProducer.getFSFactory().getFile(UpgradeLog.getUpgradeLogPath())));){
                HashMap<String, Integer> upgradeRecoverMap = new HashMap<String, Integer>();
                String line = null;
                while ((line = upgradeLogReader.readLine()) != null) {
                    String upgradeFileName = line.split(COMMA_SEPERATOR)[0];
                    if (upgradeRecoverMap.containsKey(upgradeFileName)) {
                        upgradeRecoverMap.put(upgradeFileName, (Integer)upgradeRecoverMap.get(upgradeFileName) + 1);
                        continue;
                    }
                    upgradeRecoverMap.put(upgradeFileName, 1);
                }
                for (String key : upgradeRecoverMap.keySet()) {
                    String upgradeFileName = UpgradeUtils.getUpgradeFileName(FSFactoryProducer.getFSFactory().getFile(key));
                    if (((Integer)upgradeRecoverMap.get(key)).intValue() == UpgradeCheckStatus.BEGIN_UPGRADE_FILE.getCheckStatusCode()) {
                        if (!FSFactoryProducer.getFSFactory().getFile(upgradeFileName).exists()) continue;
                        FSFactoryProducer.getFSFactory().getFile(upgradeFileName).delete();
                        continue;
                    }
                    if (((Integer)upgradeRecoverMap.get(key)).intValue() != UpgradeCheckStatus.AFTER_UPGRADE_FILE.getCheckStatusCode()) continue;
                    if (FSFactoryProducer.getFSFactory().getFile(key).exists() && FSFactoryProducer.getFSFactory().getFile(upgradeFileName).exists()) {
                        FSFactoryProducer.getFSFactory().getFile(key).delete();
                        FSFactoryProducer.getFSFactory().moveFile(FSFactoryProducer.getFSFactory().getFile(upgradeFileName), FSFactoryProducer.getFSFactory().getFile(key));
                    } else if (!FSFactoryProducer.getFSFactory().getFile(key).exists()) {
                        FSFactoryProducer.getFSFactory().moveFile(FSFactoryProducer.getFSFactory().getFile(upgradeFileName), FSFactoryProducer.getFSFactory().getFile(key));
                    }
                    FSFactoryProducer.getFSFactory().getFile(upgradeFileName).getParentFile().delete();
                }
            }
            catch (IOException e) {
                logger.error("meet error when recover upgrade process, file path:{}", (Object)UpgradeLog.getUpgradeLogPath(), (Object)e);
            }
            finally {
                FSFactoryProducer.getFSFactory().getFile(UpgradeLog.getUpgradeLogPath()).delete();
            }
        }
    }
}

