/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;

public class QueryUtils {
    private QueryUtils() {
    }

    public static void modifyChunkMetaData(List<ChunkMetaData> chunkMetaData, List<Modification> modifications) {
        int modIndex = 0;
        for (int metaIndex = 0; metaIndex < chunkMetaData.size(); ++metaIndex) {
            ChunkMetaData metaData2 = chunkMetaData.get(metaIndex);
            for (int j = modIndex; j < modifications.size(); ++j) {
                Modification modification = modifications.get(j);
                if (modification.getVersionNum() > metaData2.getVersion()) {
                    modIndex = QueryUtils.doModifyChunkMetaData(modification, metaData2) ? j : modIndex;
                    continue;
                }
                ++modIndex;
            }
        }
        chunkMetaData.removeIf(metaData -> metaData.getDeletedAt() >= metaData.getEndTime());
    }

    private static boolean doModifyChunkMetaData(Modification modification, ChunkMetaData metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            if (metaData.getDeletedAt() < deletion.getTimestamp()) {
                metaData.setDeletedAt(deletion.getTimestamp());
                return true;
            }
        }
        return false;
    }
}

