/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual.gui;

import java.io.File;
import java.util.Properties;
import javax.swing.JPanel;
import org.apache.iotdb.db.tools.logvisual.LogVisualizer;
import org.apache.iotdb.db.tools.logvisual.conf.GuiPropertyKeys;
import org.apache.iotdb.db.tools.logvisual.gui.FileSelectionBox;
import org.apache.iotdb.db.tools.logvisual.gui.LoadLogBox;
import org.apache.iotdb.db.tools.logvisual.gui.LogVisualizationGui;
import org.apache.iotdb.db.tools.logvisual.gui.PlanBox;

class MainPanel
extends JPanel {
    private FileSelectionBox logFileSelectionBox;
    private FileSelectionBox parserPropertyBox;
    private LoadLogBox loadLogBox;
    private PlanBox planBox;
    private LogVisualizer visualizer;
    private LogVisualizationGui.PropertyChangeCallback propertyChangeCallback;

    MainPanel(LogVisualizer logVisualizer, PlanBox.ExecutePlanCallback executePlanCallback, Properties properties, LogVisualizationGui.PropertyChangeCallback propertyChangeCallback) {
        this.visualizer = logVisualizer;
        this.propertyChangeCallback = propertyChangeCallback;
        this.setLayout(null);
        this.logFileSelectionBox = new FileSelectionBox("LogFilePath", this::onLogFileSelected, properties.getProperty(GuiPropertyKeys.DEFAULT_LOG_FILE_PATH.getKey()), 2);
        this.logFileSelectionBox.setLocation(0, 0);
        this.logFileSelectionBox.setSize(380, 40);
        this.parserPropertyBox = new FileSelectionBox("ParserPropertyFilePath", this::onParserPropertySelected, properties.getProperty(GuiPropertyKeys.DEFAULT_PARSER_FILE_PATH.getKey()), 0);
        this.parserPropertyBox.setLocation(0, 45);
        this.parserPropertyBox.setSize(380, 40);
        this.loadLogBox = new LoadLogBox(logVisualizer);
        this.loadLogBox.setLocation(450, 0);
        this.loadLogBox.setSize(300, 50);
        this.planBox = new PlanBox(logVisualizer, executePlanCallback, properties.getProperty(GuiPropertyKeys.DEFAULT_PLAN_PATH.getKey()), propertyChangeCallback);
        this.planBox.setLocation(0, 100);
        this.planBox.setSize(750, 430);
        this.add(this.logFileSelectionBox);
        this.add(this.parserPropertyBox);
        this.add(this.loadLogBox);
        this.add(this.planBox);
    }

    private void onLogFileSelected(File logFile) {
        this.visualizer.setLogFile(logFile);
        this.propertyChangeCallback.call(GuiPropertyKeys.DEFAULT_LOG_FILE_PATH.getKey(), logFile.getPath());
    }

    private void onParserPropertySelected(File parserPropertyFile) {
        this.visualizer.setParserPropertyFile(parserPropertyFile);
        this.propertyChangeCallback.call(GuiPropertyKeys.DEFAULT_PARSER_FILE_PATH.getKey(), parserPropertyFile.getPath());
    }
}

