/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual.gui;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.apache.iotdb.db.tools.logvisual.LogVisualizer;
import org.apache.iotdb.db.tools.logvisual.TimeSeriesStatistics;
import org.apache.iotdb.db.tools.logvisual.gui.ClosableTab;
import org.apache.iotdb.db.tools.logvisual.gui.MainPanel;
import org.apache.iotdb.db.tools.logvisual.gui.ResultPlotTab;
import org.apache.iotdb.db.tools.logvisual.gui.ResultStatisticTab;
import org.jfree.chart.JFreeChart;

public class LogVisualizationGui {
    private final String DEFAULT_CONFIG = "visual.config";
    private final int DEFAULT_HEIGHT = 600;
    private final int DEFAULT_WIDTH = 800;
    private LogVisualizer visualizer;
    private JFrame mainFrame;
    private JTabbedPane tabbedPane;
    private MainPanel mainPanel;
    private Map<String, ResultPlotTab> resultPlotPanels = new HashMap<String, ResultPlotTab>();
    private Map<String, ResultStatisticTab> resultTablePanels = new HashMap<String, ResultStatisticTab>();
    private String propertyFilePath;
    private Properties properties = new Properties();

    private LogVisualizationGui(String propertyFilePath) throws IOException {
        if (propertyFilePath == null) {
            propertyFilePath = "visual.config";
        }
        this.propertyFilePath = propertyFilePath;
        File propertyFile = new File(propertyFilePath);
        if (propertyFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(propertyFilePath);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                this.properties.load(bufferedInputStream);
            }
        }
        this.visualizer = new LogVisualizer();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.mainFrame = new JFrame("Log Visualizer");
        this.mainFrame.setSize(800, 600);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setResizable(false);
        this.tabbedPane = new JTabbedPane();
        this.mainPanel = new MainPanel(this.visualizer, this::onPlanExecuted, this.properties, this::onPropertyChange);
        this.tabbedPane.add((Component)this.mainPanel, "Main");
        this.mainFrame.add(this.tabbedPane);
        this.mainFrame.setVisible(true);
    }

    private void onPlanExecuted(String planName, Map<String, JFreeChart> charts, Map<String, List<TimeSeriesStatistics>> statisticMap) {
        String tabName = planName + "-plot";
        ResultPlotTab resultPlotTab = new ResultPlotTab(tabName, charts, this::onTabClose);
        ResultPlotTab oldPlotTab = this.resultPlotPanels.get(tabName);
        if (oldPlotTab != null) {
            this.tabbedPane.remove(oldPlotTab);
        }
        this.resultPlotPanels.put(tabName, resultPlotTab);
        this.tabbedPane.add(resultPlotTab);
        tabName = planName + "-statistics";
        ResultStatisticTab resultStatisticTab = new ResultStatisticTab(tabName, statisticMap, this::onTabClose);
        ResultStatisticTab oldTableTab = this.resultTablePanels.get(tabName);
        if (oldTableTab != null) {
            this.tabbedPane.remove(oldTableTab);
        }
        this.resultTablePanels.put(tabName, resultStatisticTab);
        this.tabbedPane.add(resultStatisticTab);
    }

    private void onPropertyChange(String key, String value) {
        this.properties.put(key, value);
        try (FileWriter writer = new FileWriter(this.propertyFilePath);
             BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            this.properties.store(bufferedWriter, "");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainPanel, "Cannot save property files: " + e.getMessage());
        }
    }

    private void onTabClose(String tabName) {
        ClosableTab tab = this.resultTablePanels.remove(tabName);
        if (tab != null) {
            this.tabbedPane.remove(tab);
            return;
        }
        tab = this.resultPlotPanels.remove(tabName);
        if (tab != null) {
            this.tabbedPane.remove(tab);
        }
    }

    public static void main(String[] args) throws IOException {
        String propertyFilePath = null;
        if (args.length > 0) {
            propertyFilePath = args[0];
        }
        LogVisualizationGui gui = new LogVisualizationGui(propertyFilePath);
    }

    public static interface PropertyChangeCallback {
        public void call(String var1, String var2);
    }
}

