/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.tools.logvisual.LogEntry;
import org.apache.iotdb.db.tools.logvisual.LogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternLogParser
implements LogParser {
    private static final Logger logger = LoggerFactory.getLogger(LogParser.class);
    private Pattern pattern;
    private int dateIndex;
    private int threadNameIndex;
    private int levelIndex;
    private int codeLocationIndex;
    private int contentIndex;
    private int logFileIdx;
    private String[] logFilePaths;
    private BufferedReader reader;
    private DateFormat dateFormat;

    PatternLogParser(Properties properties, String[] logFilePaths) {
        this.pattern = Pattern.compile(properties.getProperty(PatternProperties.PATTERN.getPropertyName()));
        this.dateIndex = Integer.parseInt(properties.getProperty(PatternProperties.DATE_INDEX.getPropertyName()));
        this.threadNameIndex = Integer.parseInt(properties.getProperty(PatternProperties.THREAD_NAME_INDEX.getPropertyName(), String.valueOf(-1)));
        this.levelIndex = Integer.parseInt(properties.getProperty(PatternProperties.LEVEL_INDEX.getPropertyName(), String.valueOf(-1)));
        this.codeLocationIndex = Integer.parseInt(properties.getProperty(PatternProperties.CODE_LOCATION_INDEX.getPropertyName(), String.valueOf(-1)));
        this.contentIndex = Integer.parseInt(properties.getProperty(PatternProperties.CONTENT_INDEX.getPropertyName()));
        this.dateFormat = new SimpleDateFormat(properties.getProperty(PatternProperties.DATE_PATTERN.getPropertyName()));
        this.logFilePaths = logFilePaths;
        this.logFileIdx = -1;
    }

    private void nextFile() throws IOException {
        this.close();
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.logFilePaths[++this.logFileIdx])));
    }

    private String nextLine() throws IOException {
        String line = this.reader.readLine();
        while (line == null) {
            if (this.logFileIdx + 1 < this.logFilePaths.length) {
                this.nextFile();
                line = this.reader.readLine();
                continue;
            }
            return null;
        }
        return line;
    }

    private Matcher nextMatchedLineMatcher() throws IOException {
        String line = this.nextLine();
        if (line == null) {
            return null;
        }
        boolean matched = false;
        Matcher matcher = null;
        while (!matched) {
            matcher = this.pattern.matcher(line);
            if (!matcher.matches()) {
                logger.debug("Unrecognizable log: {}, pattern: {}", (Object)line, (Object)matcher.pattern().toString());
                line = this.nextLine();
                if (line != null) continue;
                return null;
            }
            matched = true;
        }
        return matcher;
    }

    @Override
    public LogEntry next() throws IOException {
        Matcher matcher;
        while ((matcher = this.nextMatchedLineMatcher()) != null) {
            try {
                Date date = this.dateFormat.parse(matcher.group(this.dateIndex));
                String threadName = null;
                if (this.threadNameIndex > 0) {
                    threadName = matcher.group(this.threadNameIndex).trim();
                }
                LogEntry.LogLevel logLevel = LogEntry.LogLevel.DEBUG;
                if (this.levelIndex > 0) {
                    logLevel = LogEntry.LogLevel.valueOf(matcher.group(this.levelIndex).trim());
                }
                LogEntry.CodeLocation codeLocation = null;
                if (this.codeLocationIndex > 0) {
                    String[] codeLocationStr = matcher.group(this.codeLocationIndex).split(":");
                    codeLocation = codeLocationStr.length > 1 ? new LogEntry.CodeLocation(codeLocationStr[0].trim(), Integer.parseInt(codeLocationStr[1])) : new LogEntry.CodeLocation(codeLocationStr[0].trim(), -1);
                }
                String content = matcher.group(this.contentIndex).trim();
                return new LogEntry(date, threadName, logLevel, codeLocation, content);
            }
            catch (Exception e) {
                logger.warn("Malformed log {}", (Object)matcher.group(0), (Object)e);
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public void reset() throws IOException {
        this.close();
        this.logFileIdx = 0;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.logFilePaths[0])));
    }

    static enum PatternProperties {
        PATTERN("pattern"),
        DATE_INDEX("date_index"),
        THREAD_NAME_INDEX("thread_name_index"),
        LEVEL_INDEX("level_index"),
        CODE_LOCATION_INDEX("code_location_index"),
        CONTENT_INDEX("content_index"),
        DATE_PATTERN("date_pattern");

        private String propertyName;

        private PatternProperties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

