/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.manage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.manage.ISyncFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFileManager
implements ISyncFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncFileManager.class);
    private Set<String> allSGs;
    private Map<String, Set<File>> currentSealedLocalFilesMap;
    private Map<String, Set<File>> lastLocalFilesMap;
    private Map<String, Set<File>> deletedFilesMap;
    private Map<String, Set<File>> toBeSyncedFilesMap;

    private SyncFileManager() {
    }

    public static final SyncFileManager getInstance() {
        return SyncFileManagerHolder.INSTANCE;
    }

    @Override
    public void getCurrentLocalFiles(String dataDir) {
        LOGGER.info("Start to get current local files in data folder {}", (Object)dataDir);
        this.currentSealedLocalFilesMap = new HashMap<String, Set<File>>();
        HashMap currentAllLocalFiles = new HashMap();
        if (!new File(dataDir + File.separatorChar + "sequence").exists()) {
            return;
        }
        File[] allSGFolders = new File(dataDir + File.separatorChar + "sequence").listFiles();
        for (File sgFolder : allSGFolders) {
            if (sgFolder.getName().equals("tmp")) continue;
            this.allSGs.add(sgFolder.getName());
            currentAllLocalFiles.putIfAbsent(sgFolder.getName(), new HashSet());
            File[] files = sgFolder.listFiles();
            if (files == null) continue;
            Arrays.stream(files).forEach(file -> ((Set)currentAllLocalFiles.get(sgFolder.getName())).add(new File(sgFolder.getAbsolutePath(), file.getName())));
        }
        for (Map.Entry entry : currentAllLocalFiles.entrySet()) {
            String sgName = (String)entry.getKey();
            this.currentSealedLocalFilesMap.putIfAbsent(sgName, new HashSet());
            for (File file2 : (Set)entry.getValue()) {
                if (!file2.getName().endsWith(".tsfile") || !new File(file2.getAbsolutePath() + ".resource").exists() || new File(file2.getAbsolutePath() + ".mods").exists() || new File(file2.getAbsolutePath() + ".merge").exists()) continue;
                this.currentSealedLocalFilesMap.get(sgName).add(file2);
            }
        }
    }

    @Override
    public void getLastLocalFiles(File lastLocalFileInfo) throws IOException {
        LOGGER.info("Start to get last local files from last local file info {}", (Object)lastLocalFileInfo.getAbsoluteFile());
        this.lastLocalFilesMap = new HashMap<String, Set<File>>();
        if (!lastLocalFileInfo.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(lastLocalFileInfo));){
            String fileName;
            while ((fileName = reader.readLine()) != null) {
                String sgName = new File(fileName).getParentFile().getName();
                this.allSGs.add(sgName);
                this.lastLocalFilesMap.putIfAbsent(sgName, new HashSet());
                this.lastLocalFilesMap.get(sgName).add(new File(fileName));
            }
        }
    }

    @Override
    public void getValidFiles(String dataDir) throws IOException {
        this.allSGs = new HashSet<String>();
        this.getCurrentLocalFiles(dataDir);
        this.getLastLocalFiles(new File(SyncSenderDescriptor.getInstance().getConfig().getLastFileInfoPath()));
        this.toBeSyncedFilesMap = new HashMap<String, Set<File>>();
        this.deletedFilesMap = new HashMap<String, Set<File>>();
        for (String sgName : this.allSGs) {
            this.toBeSyncedFilesMap.putIfAbsent(sgName, new HashSet());
            this.deletedFilesMap.putIfAbsent(sgName, new HashSet());
            for (File newFile : this.currentSealedLocalFilesMap.getOrDefault(sgName, Collections.emptySet())) {
                if (((Set)this.lastLocalFilesMap.getOrDefault(sgName, new HashSet())).contains(newFile)) continue;
                this.toBeSyncedFilesMap.get(sgName).add(newFile);
            }
            for (File oldFile : (Set)this.lastLocalFilesMap.getOrDefault(sgName, new HashSet())) {
                if (((Set)this.currentSealedLocalFilesMap.getOrDefault(sgName, new HashSet())).contains(oldFile)) continue;
                this.deletedFilesMap.get(sgName).add(oldFile);
            }
        }
    }

    @Override
    public Map<String, Set<File>> getCurrentSealedLocalFilesMap() {
        return this.currentSealedLocalFilesMap;
    }

    @Override
    public Map<String, Set<File>> getLastLocalFilesMap() {
        return this.lastLocalFilesMap;
    }

    @Override
    public Map<String, Set<File>> getDeletedFilesMap() {
        return this.deletedFilesMap;
    }

    @Override
    public Map<String, Set<File>> getToBeSyncedFilesMap() {
        return this.toBeSyncedFilesMap;
    }

    @Override
    public Set<String> getAllSGs() {
        return this.allSGs;
    }

    private static class SyncFileManagerHolder {
        private static final SyncFileManager INSTANCE = new SyncFileManager();

        private SyncFileManagerHolder() {
        }
    }
}

