/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JDBCServiceEventHandler;
import org.apache.iotdb.db.service.JDBCServiceMBean;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCService
implements JDBCServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(JDBCService.class);
    private static final String STATUS_UP = "UP";
    private static final String STATUS_DOWN = "DOWN";
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    private Thread jdbcServiceThread;
    private TProtocolFactory protocolFactory;
    private TSIService.Processor<TSIService.Iface> processor;
    private TThreadPoolServer.Args poolArgs;
    private TSServiceImpl impl;
    private CountDownLatch startLatch;
    private CountDownLatch stopLatch;

    private JDBCService() {
    }

    public static final JDBCService getInstance() {
        return JDBCServiceHolder.INSTANCE;
    }

    @Override
    public String getJDBCServiceStatus() {
        if (this.startLatch == null) {
            logger.info("Start latch is null when getting status");
        } else {
            logger.info("Start latch is {} when getting status", (Object)this.startLatch.getCount());
        }
        if (this.stopLatch == null) {
            logger.info("Stop latch is null when getting status");
        } else {
            logger.info("Stop latch is {} when getting status", (Object)this.stopLatch.getCount());
        }
        if (this.startLatch != null && this.startLatch.getCount() == 0L) {
            return STATUS_UP;
        }
        return STATUS_DOWN;
    }

    @Override
    public int getRPCPort() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        return config.getRpcPort();
    }

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(JDBCService.getInstance(), this.mbeanName);
            this.startService();
        }
        catch (Exception e) {
            logger.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
        this.stopService();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public ServiceType getID() {
        return ServiceType.JDBC_SERVICE;
    }

    @Override
    public synchronized void startService() throws StartupException {
        if (STATUS_UP.equals(this.getJDBCServiceStatus())) {
            logger.info("{}: {} has been already running now", (Object)"IoTDB", (Object)this.getID().getName());
            return;
        }
        logger.info("{}: start {}...", (Object)"IoTDB", (Object)this.getID().getName());
        try {
            this.reset();
            this.jdbcServiceThread = new JDBCServiceThread(this.startLatch, this.stopLatch);
            this.jdbcServiceThread.setName(ThreadName.JDBC_SERVICE.getName());
            this.jdbcServiceThread.start();
            this.startLatch.await();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
        logger.info("{}: start {} successfully, listening on ip {} port {}", new Object[]{"IoTDB", this.getID().getName(), IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), IoTDBDescriptor.getInstance().getConfig().getRpcPort()});
    }

    private void reset() {
        this.startLatch = new CountDownLatch(1);
        this.stopLatch = new CountDownLatch(1);
    }

    @Override
    public synchronized void restartService() throws StartupException {
        this.stopService();
        this.startService();
    }

    @Override
    public synchronized void stopService() {
        if (STATUS_DOWN.equals(this.getJDBCServiceStatus())) {
            logger.info("{}: {} isn't running now", (Object)"IoTDB", (Object)this.getID().getName());
            return;
        }
        logger.info("{}: closing {}...", (Object)"IoTDB", (Object)this.getID().getName());
        if (this.jdbcServiceThread != null) {
            ((JDBCServiceThread)this.jdbcServiceThread).close();
        }
        try {
            this.stopLatch.await();
            this.reset();
            logger.info("{}: close {} successfully", (Object)"IoTDB", (Object)this.getID().getName());
        }
        catch (InterruptedException e) {
            logger.error("{}: close {} failed because {}", new Object[]{"IoTDB", this.getID().getName(), e});
            Thread.currentThread().interrupt();
        }
    }

    private class JDBCServiceThread
    extends Thread {
        private TServerSocket serverTransport;
        private TServer poolServer;
        private CountDownLatch threadStartLatch;
        private CountDownLatch threadStopLatch;

        public JDBCServiceThread(CountDownLatch threadStartLatch, CountDownLatch threadStopLatch) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable()) {
                JDBCService.this.protocolFactory = (TProtocolFactory)new TCompactProtocol.Factory();
            } else {
                JDBCService.this.protocolFactory = (TProtocolFactory)new TBinaryProtocol.Factory();
            }
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            JDBCService.this.impl = (TSServiceImpl)Class.forName(config.getRpcImplClassName()).newInstance();
            JDBCService.this.processor = new TSIService.Processor((TSIService.Iface)JDBCService.this.impl);
            this.threadStartLatch = threadStartLatch;
            this.threadStopLatch = threadStopLatch;
        }

        @Override
        public void run() {
            try {
                IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
                this.serverTransport = new TServerSocket(new InetSocketAddress(config.getRpcAddress(), config.getRpcPort()));
                JDBCService.this.poolArgs = new TThreadPoolServer.Args((TServerTransport)this.serverTransport).maxWorkerThreads(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum()).minWorkerThreads(1);
                ((JDBCService)JDBCService.this).poolArgs.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(JDBCService.this.poolArgs, ThreadName.JDBC_CLIENT.getName());
                JDBCService.this.poolArgs.processor((TProcessor)JDBCService.this.processor);
                JDBCService.this.poolArgs.protocolFactory(JDBCService.this.protocolFactory);
                this.poolServer = new TThreadPoolServer(JDBCService.this.poolArgs);
                this.poolServer.setServerEventHandler((TServerEventHandler)new JDBCServiceEventHandler(JDBCService.this.impl, this.threadStartLatch));
                this.poolServer.serve();
            }
            catch (TTransportException e) {
                logger.error("{}: failed to start {}, because ", new Object[]{"IoTDB", JDBCService.this.getID().getName(), e});
            }
            catch (Exception e) {
                logger.error("{}: {} exit, because ", new Object[]{"IoTDB", JDBCService.this.getID().getName(), e});
            }
            finally {
                this.close();
                if (this.threadStopLatch == null) {
                    logger.info("Stop Count Down latch is null");
                } else {
                    logger.info("Stop Count Down latch is {}", (Object)this.threadStopLatch.getCount());
                }
                if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
                    this.threadStopLatch.countDown();
                }
                logger.info("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)JDBCService.this.getID().getName());
            }
        }

        private synchronized void close() {
            if (this.poolServer != null) {
                this.poolServer.stop();
                this.poolServer = null;
            }
            if (this.serverTransport != null) {
                this.serverTransport.close();
                this.serverTransport = null;
            }
        }
    }

    private static class JDBCServiceHolder {
        private static final JDBCService INSTANCE = new JDBCService();

        private JDBCServiceHolder() {
        }
    }
}

