/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.fill;

import java.io.IOException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;

public class PreviousFill
extends IFill {
    private long beforeRange;

    public PreviousFill(TSDataType dataType, long queryTime, long beforeRange) {
        super(dataType, queryTime);
        this.beforeRange = beforeRange;
    }

    public PreviousFill(long beforeRange) {
        this.beforeRange = beforeRange;
    }

    @Override
    public IFill copy(Path path) {
        return new PreviousFill(this.dataType, this.queryTime, this.beforeRange);
    }

    @Override
    public void constructReaders(Path path, QueryContext context) throws IOException, StorageEngineException {
        super.constructReaders(path, context, this.beforeRange);
    }

    public long getBeforeRange() {
        return this.beforeRange;
    }

    @Override
    public IPointReader getFillResult() throws IOException {
        TimeValuePair beforePair = null;
        TimeValuePair cachedPair = null;
        while (this.allDataReader.hasNext() && (cachedPair = this.allDataReader.next()).getTimestamp() <= this.queryTime) {
            beforePair = cachedPair;
        }
        if (beforePair != null) {
            beforePair.setTimestamp(this.queryTime);
        } else {
            beforePair = new TimeValuePair(this.queryTime, null);
        }
        return new IFill.TimeValuePairPointReader(beforePair);
    }
}

