/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.query.externalsort.ExternalSortJobPart;
import org.apache.iotdb.db.query.externalsort.LineMerger;
import org.apache.iotdb.db.query.reader.IPointReader;

public class MultiSourceExternalSortJobPart
extends ExternalSortJobPart {
    private String tmpFilePath;
    private List<ExternalSortJobPart> source;
    private long queryId;

    public MultiSourceExternalSortJobPart(long queryId, String tmpFilePath, List<ExternalSortJobPart> source) {
        super(ExternalSortJobPart.ExternalSortJobPartType.MULTIPLE_SOURCE);
        this.source = source;
        this.tmpFilePath = tmpFilePath;
        this.queryId = queryId;
    }

    public MultiSourceExternalSortJobPart(long queryId, String tmpFilePath, ExternalSortJobPart ... externalSortJobParts) {
        super(ExternalSortJobPart.ExternalSortJobPartType.MULTIPLE_SOURCE);
        this.source = new ArrayList<ExternalSortJobPart>();
        for (ExternalSortJobPart externalSortJobPart : externalSortJobParts) {
            this.source.add(externalSortJobPart);
        }
        this.tmpFilePath = tmpFilePath;
    }

    @Override
    public IPointReader executeForIPointReader() throws IOException {
        ArrayList<IPointReader> prioritySeriesReaders = new ArrayList<IPointReader>();
        for (ExternalSortJobPart part : this.source) {
            prioritySeriesReaders.add(part.executeForIPointReader());
        }
        LineMerger merger = new LineMerger(this.queryId, this.tmpFilePath);
        return merger.merge(prioritySeriesReaders);
    }
}

