/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.IEngineQueryRouter;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;

public class DeviceIterateDataSet
extends QueryDataSet {
    private DataSetType dataSetType;
    private IEngineQueryRouter queryRouter;
    private QueryContext context;
    private IExpression expression;
    private List<String> deduplicatedMeasurementColumns;
    private Map<String, Set<String>> measurementColumnsGroupByDevice;
    private long unit;
    private long origin;
    private List<Pair<Long, Long>> intervals;
    private long queryTime;
    private Map<TSDataType, IFill> fillType;
    private boolean curDataSetInitialized;
    private Iterator<String> deviceIterator;
    private String currentDevice;
    private QueryDataSet currentDataSet;
    private int[] currentColumnMapRelation;

    public DeviceIterateDataSet(QueryPlan queryPlan, QueryContext context, IEngineQueryRouter queryRouter) {
        super(null, queryPlan.getDataTypes());
        this.deduplicatedMeasurementColumns = queryPlan.getMeasurementColumnList();
        this.queryRouter = queryRouter;
        this.context = context;
        this.measurementColumnsGroupByDevice = queryPlan.getMeasurementColumnsGroupByDevice();
        if (queryPlan instanceof GroupByPlan) {
            this.dataSetType = DataSetType.GROUPBY;
            this.expression = queryPlan.getExpression();
            this.unit = ((GroupByPlan)queryPlan).getUnit();
            this.origin = ((GroupByPlan)queryPlan).getOrigin();
            this.intervals = ((GroupByPlan)queryPlan).getIntervals();
        } else if (queryPlan instanceof AggregationPlan) {
            this.dataSetType = DataSetType.AGGREGATE;
            this.expression = queryPlan.getExpression();
        } else if (queryPlan instanceof FillQueryPlan) {
            this.dataSetType = DataSetType.FILL;
            this.queryTime = ((FillQueryPlan)queryPlan).getQueryTime();
            this.fillType = ((FillQueryPlan)queryPlan).getFillType();
        } else {
            this.dataSetType = DataSetType.QUERY;
            this.expression = queryPlan.getExpression();
        }
        this.curDataSetInitialized = false;
        this.deviceIterator = this.measurementColumnsGroupByDevice.keySet().iterator();
        this.currentColumnMapRelation = new int[this.deduplicatedMeasurementColumns.size()];
    }

    public boolean hasNext() throws IOException {
        if (this.curDataSetInitialized && this.currentDataSet.hasNext()) {
            return true;
        }
        this.curDataSetInitialized = false;
        for (int i = 0; i < this.deduplicatedMeasurementColumns.size(); ++i) {
            this.currentColumnMapRelation[i] = -1;
        }
        while (this.deviceIterator.hasNext()) {
            this.currentDevice = this.deviceIterator.next();
            Set<String> measurementColumnsOfGivenDevice = this.measurementColumnsGroupByDevice.get(this.currentDevice);
            ArrayList<String> executeColumns = new ArrayList<String>();
            int indexInExecuteColumns = -1;
            block10: for (String column : measurementColumnsOfGivenDevice) {
                for (int i = 0; i < this.deduplicatedMeasurementColumns.size(); ++i) {
                    String columnToExecute = this.deduplicatedMeasurementColumns.get(i);
                    if (!columnToExecute.equals(column)) continue;
                    executeColumns.add(column);
                    this.currentColumnMapRelation[i] = ++indexInExecuteColumns;
                    continue block10;
                }
            }
            ArrayList<Path> executePaths = new ArrayList<Path>();
            ArrayList<String> executeAggregations = new ArrayList<String>();
            for (String column : executeColumns) {
                if (this.dataSetType == DataSetType.GROUPBY || this.dataSetType == DataSetType.AGGREGATE) {
                    executePaths.add(new Path(this.currentDevice, column.substring(column.indexOf("(") + 1, column.indexOf(")"))));
                    executeAggregations.add(column.substring(0, column.indexOf("(")));
                    continue;
                }
                executePaths.add(new Path(this.currentDevice, column));
            }
            try {
                switch (this.dataSetType) {
                    case GROUPBY: {
                        this.currentDataSet = this.queryRouter.groupBy(executePaths, executeAggregations, this.expression, this.unit, this.origin, this.intervals, this.context);
                        break;
                    }
                    case AGGREGATE: {
                        this.currentDataSet = this.queryRouter.aggregate(executePaths, executeAggregations, this.expression, this.context);
                        break;
                    }
                    case FILL: {
                        this.currentDataSet = this.queryRouter.fill(executePaths, this.queryTime, this.fillType, this.context);
                        break;
                    }
                    case QUERY: {
                        QueryExpression queryExpression = QueryExpression.create().setSelectSeries(executePaths).setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.query(queryExpression, this.context);
                        break;
                    }
                    default: {
                        throw new IOException("unsupported DataSetType");
                    }
                }
            }
            catch (IOException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException e) {
                throw new IOException(e);
            }
            if (!this.currentDataSet.hasNext()) continue;
            this.curDataSetInitialized = true;
            return true;
        }
        return false;
    }

    public RowRecord next() throws IOException {
        RowRecord originRowRecord = this.currentDataSet.next();
        RowRecord rowRecord = new RowRecord(originRowRecord.getTimestamp());
        Field deviceField = new Field(TSDataType.TEXT);
        deviceField.setBinaryV(new Binary(this.currentDevice));
        rowRecord.addField(deviceField);
        List measurementfields = originRowRecord.getFields();
        for (int mapPos : this.currentColumnMapRelation) {
            if (mapPos == -1) {
                rowRecord.addField(new Field(null));
                continue;
            }
            rowRecord.addField((Field)measurementfields.get(mapPos));
        }
        return rowRecord;
    }

    private static enum DataSetType {
        GROUPBY,
        AGGREGATE,
        FILL,
        QUERY;

    }
}

