/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MinTimeAggrFunc
extends AggregateFunction {
    public MinTimeAggrFunc() {
        super(TSDataType.INT64);
    }

    @Override
    public void init() {
        this.resultData.reset();
    }

    @Override
    public AggreResultData getResult() {
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        if (this.resultData.isSetValue()) {
            return;
        }
        long time = pageHeader.getMinTimestamp();
        this.resultData.putTimeAndValue(0L, time);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        if (this.resultData.isSetValue()) {
            return;
        }
        if (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            if (dataInThisPage.currentTime() < unsequenceReader.current().getTimestamp()) {
                this.resultData.setTimestamp(0L);
                this.resultData.setLongRet(dataInThisPage.currentTime());
            } else {
                this.resultData.setTimestamp(0L);
                this.resultData.setLongRet(unsequenceReader.current().getTimestamp());
            }
            return;
        }
        if (dataInThisPage.hasNext()) {
            this.resultData.setTimestamp(0L);
            this.resultData.setLongRet(dataInThisPage.currentTime());
        }
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        if (this.resultData.isSetValue()) {
            return;
        }
        if (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            if (dataInThisPage.currentTime() < unsequenceReader.current().getTimestamp()) {
                if (dataInThisPage.currentTime() >= bound) {
                    return;
                }
                this.resultData.setTimestamp(0L);
                this.resultData.setLongRet(dataInThisPage.currentTime());
            } else {
                if (unsequenceReader.current().getTimestamp() >= bound) {
                    return;
                }
                this.resultData.setTimestamp(0L);
                this.resultData.setLongRet(unsequenceReader.current().getTimestamp());
            }
            return;
        }
        if (dataInThisPage.hasNext() && dataInThisPage.currentTime() < bound) {
            this.resultData.setTimestamp(0L);
            this.resultData.setLongRet(dataInThisPage.currentTime());
            dataInThisPage.next();
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        if (this.resultData.isSetValue()) {
            return;
        }
        if (unsequenceReader.hasNext()) {
            this.resultData.setTimestamp(0L);
            this.resultData.setLongRet(unsequenceReader.current().getTimestamp());
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        if (this.resultData.isSetValue()) {
            return;
        }
        if (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            this.resultData.setTimestamp(0L);
            this.resultData.setLongRet(unsequenceReader.current().getTimestamp());
        }
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        if (this.resultData.isSetValue()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.resultData.setTimestamp(0L);
            this.resultData.setLongRet(timestamps[i]);
            return;
        }
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return this.resultData.isSetValue();
    }
}

