/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class FilterOperator
extends Operator
implements Comparable<FilterOperator> {
    protected String tokenSymbol;
    protected List<FilterOperator> childOperators;
    protected boolean isLeaf = false;
    protected boolean isSingle = false;
    protected Path singlePath = null;

    public FilterOperator(int tokenType) {
        super(tokenType);
        this.operatorType = Operator.OperatorType.FILTER;
        this.childOperators = new ArrayList<FilterOperator>();
        this.tokenIntType = tokenType;
        this.isLeaf = false;
        this.tokenSymbol = SQLConstant.tokenSymbol.get(tokenType);
    }

    public FilterOperator(int tokenType, boolean isSingle) {
        this(tokenType);
        this.isSingle = isSingle;
    }

    @Override
    public int getTokenIntType() {
        return this.tokenIntType;
    }

    public void setTokenIntType(int intType) {
        this.tokenIntType = intType;
        this.tokenName = SQLConstant.tokenNames.get(this.tokenIntType);
        this.tokenSymbol = SQLConstant.tokenSymbol.get(this.tokenIntType);
    }

    public List<FilterOperator> getChildren() {
        return this.childOperators;
    }

    public void setChildren(List<FilterOperator> children) {
        this.childOperators = children;
    }

    public void setIsSingle(boolean b) {
        this.isSingle = b;
    }

    public Path getSinglePath() {
        return this.singlePath;
    }

    public void setSinglePath(Path path) {
        this.singlePath = path;
    }

    public boolean addChildOperator(FilterOperator op) {
        this.childOperators.add(op);
        return true;
    }

    public IExpression transformToExpression(IQueryProcessExecutor executor) throws QueryProcessException, LogicalOperatorException {
        if (this.isSingle) {
            Pair<IUnaryExpression, String> ret = this.transformToSingleQueryFilter(executor);
            return (IExpression)ret.left;
        }
        if (this.childOperators.isEmpty()) {
            throw new LogicalOperatorException(String.valueOf(this.tokenIntType), "this filter is not leaf, but it's empty");
        }
        IExpression retFilter = this.childOperators.get(0).transformToExpression(executor);
        block4: for (int i = 1; i < this.childOperators.size(); ++i) {
            IExpression currentFilter = this.childOperators.get(i).transformToExpression(executor);
            switch (this.tokenIntType) {
                case 1: {
                    retFilter = BinaryExpression.and((IExpression)retFilter, (IExpression)currentFilter);
                    continue block4;
                }
                case 2: {
                    retFilter = BinaryExpression.or((IExpression)retFilter, (IExpression)currentFilter);
                    continue block4;
                }
                default: {
                    throw new LogicalOperatorException(String.valueOf(this.tokenIntType), "Maybe it means " + SQLConstant.tokenNames.get(this.tokenIntType));
                }
            }
        }
        return retFilter;
    }

    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(IQueryProcessExecutor executor) throws LogicalOperatorException, PathException {
        if (this.childOperators.isEmpty()) {
            throw new LogicalOperatorException(String.valueOf(this.tokenIntType), "TransformToSingleFilter: this filter is not a leaf, but it's empty.");
        }
        Pair<IUnaryExpression, String> currentPair = this.childOperators.get(0).transformToSingleQueryFilter(executor);
        IUnaryExpression retFilter = (IUnaryExpression)currentPair.left;
        String path = (String)currentPair.right;
        block4: for (int i = 1; i < this.childOperators.size(); ++i) {
            currentPair = this.childOperators.get(i).transformToSingleQueryFilter(executor);
            if (!path.equals(currentPair.right)) {
                throw new LogicalOperatorException("TransformToSingleFilter: paths among children are not inconsistent: one is: " + path + ", another is: " + (String)currentPair.right);
            }
            switch (this.tokenIntType) {
                case 1: {
                    retFilter.setFilter((Filter)FilterFactory.and((Filter)retFilter.getFilter(), (Filter)((IUnaryExpression)currentPair.left).getFilter()));
                    continue block4;
                }
                case 2: {
                    retFilter.setFilter((Filter)FilterFactory.or((Filter)retFilter.getFilter(), (Filter)((IUnaryExpression)currentPair.left).getFilter()));
                    continue block4;
                }
                default: {
                    throw new LogicalOperatorException(String.valueOf(this.tokenIntType), "Maybe it means " + SQLConstant.tokenNames.get(this.tokenIntType));
                }
            }
        }
        return new Pair((Object)retFilter, (Object)path);
    }

    @Override
    public int compareTo(FilterOperator fil) {
        if (this.singlePath == null && fil.singlePath == null) {
            return 0;
        }
        if (this.singlePath == null) {
            return 1;
        }
        if (fil.singlePath == null) {
            return -1;
        }
        return fil.singlePath.toString().compareTo(this.singlePath.toString());
    }

    public boolean equals(Object fil) {
        if (!(fil instanceof FilterOperator)) {
            return false;
        }
        FilterOperator operator = (FilterOperator)fil;
        return this.compareTo(operator) == 0;
    }

    public int hashCode() {
        return this.tokenSymbol.hashCode();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public String showTree() {
        return this.showTree(0);
    }

    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.tokenName});
        if (this.isSingle) {
            sc.addTail(new String[]{"[single:", this.getSinglePath().toString(), "]"});
        }
        sc.addTail(new String[]{"\n"});
        for (FilterOperator filter : this.childOperators) {
            sc.addTail(new String[]{filter.showTree(spaceNum + 1)});
        }
        return sc.toString();
    }

    @Override
    public String toString() {
        StringContainer sc = new StringContainer();
        sc.addTail(new String[]{"[", this.tokenName});
        if (this.isSingle) {
            sc.addTail(new String[]{"[single:", this.getSinglePath().toString(), "]"});
        }
        sc.addTail(new String[]{" "});
        for (FilterOperator filter : this.childOperators) {
            sc.addTail(new String[]{filter.toString()});
        }
        sc.addTail(new String[]{"]"});
        return sc.toString();
    }

    public FilterOperator clone() {
        FilterOperator ret = new FilterOperator(this.tokenIntType);
        ret.tokenSymbol = this.tokenSymbol;
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        if (this.singlePath != null) {
            ret.singlePath = this.singlePath.clone();
        }
        for (FilterOperator filterOperator : this.childOperators) {
            ret.addChildOperator(filterOperator.clone());
        }
        return ret;
    }
}

