/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp;

import java.time.ZoneId;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.IllegalASTFormatException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.DnfFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.MergeSingleFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.RemoveNotOptimizer;
import org.apache.iotdb.db.sql.ParseGenerator;
import org.apache.iotdb.db.sql.parse.AstNode;
import org.apache.iotdb.db.sql.parse.ParseException;
import org.apache.iotdb.db.sql.parse.ParseUtils;

public class QueryProcessor {
    private IQueryProcessExecutor executor;

    public QueryProcessor(IQueryProcessExecutor executor) {
        this.executor = executor;
    }

    public IQueryProcessExecutor getExecutor() {
        return this.executor;
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr) throws QueryProcessException, MetadataException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        return this.parseSQLToPhysicalPlan(sqlStr, config.getZoneID());
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId) throws MetadataException, QueryProcessException {
        AstNode astNode = this.parseSQLToAST(sqlStr);
        Operator operator = this.parseASTToOperator(astNode, zoneId);
        operator = this.logicalOptimize(operator, this.executor);
        PhysicalGenerator physicalGenerator = new PhysicalGenerator(this.executor);
        return physicalGenerator.transformToPhysicalPlan(operator);
    }

    private RootOperator parseASTToOperator(AstNode astNode, ZoneId zoneId) throws QueryProcessException, MetadataException {
        LogicalGenerator generator = new LogicalGenerator(zoneId);
        return generator.getLogicalPlan(astNode);
    }

    private AstNode parseSQLToAST(String sqlStr) throws IllegalASTFormatException {
        AstNode astTree;
        try {
            astTree = ParseGenerator.generateAST(sqlStr);
        }
        catch (ParseException e) {
            throw new IllegalASTFormatException(sqlStr, e.getMessage());
        }
        return ParseUtils.findRootNonNullToken(astTree);
    }

    private Operator logicalOptimize(Operator operator, IQueryProcessExecutor executor) throws LogicalOperatorException {
        switch (operator.getType()) {
            case AUTHOR: 
            case METADATA: 
            case SET_STORAGE_GROUP: 
            case DELETE_STORAGE_GROUP: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case PROPERTY: 
            case LOADDATA: 
            case INSERT: 
            case INDEX: 
            case INDEXQUERY: 
            case GRANT_WATERMARK_EMBEDDING: 
            case REVOKE_WATERMARK_EMBEDDING: 
            case TTL: {
                return operator;
            }
            case QUERY: 
            case UPDATE: 
            case DELETE: {
                SFWOperator root = (SFWOperator)operator;
                return this.optimizeSFWOperator(root, executor);
            }
        }
        throw new LogicalOperatorException(operator.getType().toString(), "");
    }

    private SFWOperator optimizeSFWOperator(SFWOperator root, IQueryProcessExecutor executor) throws LogicalOperatorException {
        ConcatPathOptimizer concatPathOptimizer = new ConcatPathOptimizer(executor);
        FilterOperator filter = (root = (SFWOperator)concatPathOptimizer.transform(root)).getFilterOperator();
        if (filter == null) {
            return root;
        }
        RemoveNotOptimizer removeNot = new RemoveNotOptimizer();
        filter = removeNot.optimize(filter);
        DnfFilterOptimizer dnf = new DnfFilterOptimizer();
        filter = dnf.optimize(filter);
        MergeSingleFilterOptimizer merge = new MergeSingleFilterOptimizer();
        filter = merge.optimize(filter);
        root.setFilterOperator(filter);
        return root;
    }
}

