/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.selector;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.engine.merge.selector.IMergePathSelector;
import org.apache.iotdb.tsfile.read.common.Path;

public class NaivePathSelector
implements IMergePathSelector {
    private List<Path> paths;
    private int idx;
    private int maxSeriesNum;

    public NaivePathSelector(List<Path> paths, int maxSeriesNum) {
        this.paths = paths;
        this.maxSeriesNum = maxSeriesNum;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.paths.size();
    }

    @Override
    public List<Path> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<Path> ret = this.idx + this.maxSeriesNum <= this.paths.size() ? this.paths.subList(this.idx, this.idx + this.maxSeriesNum) : this.paths.subList(this.idx, this.paths.size());
        this.idx += this.maxSeriesNum;
        return ret;
    }
}

