/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.selector;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.MaxFileMergeFileSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxSeriesMergeFileSelector
extends MaxFileMergeFileSelector {
    public static final int MAX_SERIES_NUM = 1024;
    private static final Logger logger = LoggerFactory.getLogger(MaxSeriesMergeFileSelector.class);
    private List<TsFileResource> lastSelectedSeqFiles = Collections.emptyList();
    private List<TsFileResource> lastSelectedUnseqFiles = Collections.emptyList();
    private long lastTotalMemoryCost;

    public MaxSeriesMergeFileSelector(MergeResource mergeResource, long memoryBudget) {
        super(mergeResource, memoryBudget);
    }

    @Override
    public List[] select() throws MergeException {
        long startTime = System.currentTimeMillis();
        try {
            logger.info("Selecting merge candidates from {} seqFile, {} unseqFiles", (Object)this.resource.getSeqFiles().size(), (Object)this.resource.getUnseqFiles().size());
            this.searchMaxSeriesNum();
            this.resource.setSeqFiles(this.selectedSeqFiles);
            this.resource.setUnseqFiles(this.selectedUnseqFiles);
            this.resource.removeOutdatedSeqReaders();
            if (this.selectedUnseqFiles.isEmpty()) {
                logger.info("No merge candidates are found");
                return new List[0];
            }
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Selected merge candidates, {} seqFiles, {} unseqFiles, total memory cost {}, concurrent merge num {}time consumption {}ms", new Object[]{this.selectedSeqFiles.size(), this.selectedUnseqFiles.size(), this.totalCost, this.concurrentMergeNum, System.currentTimeMillis() - startTime});
        }
        return new List[]{this.selectedSeqFiles, this.selectedUnseqFiles};
    }

    private void searchMaxSeriesNum() throws IOException {
        this.binSearch();
    }

    private void binSearch() throws IOException {
        int mid;
        int lb = 0;
        int ub = 1025;
        while ((mid = (lb + ub) / 2) != lb) {
            this.concurrentMergeNum = mid;
            this.select(false);
            if (this.selectedUnseqFiles.isEmpty()) {
                this.select(true);
            }
            if (this.selectedUnseqFiles.isEmpty()) {
                ub = mid;
                continue;
            }
            this.lastSelectedSeqFiles = this.selectedSeqFiles;
            this.lastSelectedUnseqFiles = this.selectedUnseqFiles;
            this.lastTotalMemoryCost = this.totalCost;
            lb = mid;
        }
        this.selectedUnseqFiles = this.lastSelectedUnseqFiles;
        this.selectedSeqFiles = this.lastSelectedSeqFiles;
        this.concurrentMergeNum = lb;
        this.totalCost = this.lastTotalMemoryCost;
    }
}

