/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush.pool;

import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.pool.AbstractPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushTaskPoolManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushTaskPoolManager.class);

    private FlushTaskPoolManager() {
        int threadCnt = IoTDBDescriptor.getInstance().getConfig().getConcurrentFlushThread();
        this.pool = IoTDBThreadPoolFactory.newFixedThreadPool(threadCnt, ThreadName.FLUSH_SERVICE.getName());
    }

    public static FlushTaskPoolManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "flush task";
    }

    @Override
    public void start() {
        if (this.pool == null) {
            int threadCnt = IoTDBDescriptor.getInstance().getConfig().getConcurrentFlushThread();
            this.pool = IoTDBThreadPoolFactory.newFixedThreadPool(threadCnt, ThreadName.FLUSH_SERVICE.getName());
        }
        LOGGER.info("Flush task manager started.");
    }

    @Override
    public void stop() {
        if (this.pool != null) {
            this.close();
            this.pool = null;
        }
        LOGGER.info("Flush task manager stopped");
    }

    private static class InstanceHolder {
        private static FlushTaskPoolManager instance = new FlushTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

