/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.iotdb.db.engine.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.exception.runtime.FlushRunTimeException;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemTableFlushTask {
    private static final Logger logger = LoggerFactory.getLogger(MemTableFlushTask.class);
    private static final FlushSubTaskPoolManager subTaskPoolManager = FlushSubTaskPoolManager.getInstance();
    private Future ioTaskFuture;
    private RestorableTsFileIOWriter writer;
    private ConcurrentLinkedQueue ioTaskQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue encodingTaskQueue = new ConcurrentLinkedQueue();
    private String storageGroup;
    private IMemTable memTable;
    private Schema schema;
    private volatile boolean noMoreEncodingTask = false;
    private volatile boolean noMoreIOTask = false;
    private Runnable encodingTask = new Runnable(){

        private void writeOneSeries(TVList tvPairs, IChunkWriter seriesWriterImpl, TSDataType dataType) {
            block8: for (int i = 0; i < tvPairs.size(); ++i) {
                long time = tvPairs.getTime(i);
                if (i + 1 < tvPairs.size() && time == tvPairs.getTime(i + 1)) continue;
                switch (dataType) {
                    case BOOLEAN: {
                        seriesWriterImpl.write(time, tvPairs.getBoolean(i));
                        continue block8;
                    }
                    case INT32: {
                        seriesWriterImpl.write(time, tvPairs.getInt(i));
                        continue block8;
                    }
                    case INT64: {
                        seriesWriterImpl.write(time, tvPairs.getLong(i));
                        continue block8;
                    }
                    case FLOAT: {
                        seriesWriterImpl.write(time, tvPairs.getFloat(i));
                        continue block8;
                    }
                    case DOUBLE: {
                        seriesWriterImpl.write(time, tvPairs.getDouble(i));
                        continue block8;
                    }
                    case TEXT: {
                        seriesWriterImpl.write(time, tvPairs.getBinary(i));
                        continue block8;
                    }
                    default: {
                        logger.error("Storage group {} does not support data type: {}", (Object)MemTableFlushTask.this.storageGroup, (Object)dataType);
                    }
                }
            }
        }

        @Override
        public void run() {
            long memSerializeTime = 0L;
            boolean noMoreMessages = false;
            logger.debug("Storage group {} memtable {}, starts to encoding data.", (Object)MemTableFlushTask.this.storageGroup, (Object)MemTableFlushTask.this.memTable.getVersion());
            while (true) {
                Object task;
                if (MemTableFlushTask.this.noMoreEncodingTask) {
                    noMoreMessages = true;
                }
                if ((task = MemTableFlushTask.this.encodingTaskQueue.poll()) == null) {
                    if (noMoreMessages) break;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Storage group {} memtable {}, encoding task is interrupted.", new Object[]{MemTableFlushTask.this.storageGroup, MemTableFlushTask.this.memTable.getVersion(), e});
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (task instanceof StartFlushGroupIOTask) {
                    MemTableFlushTask.this.ioTaskQueue.add(task);
                    continue;
                }
                if (task instanceof EndChunkGroupIoTask) {
                    MemTableFlushTask.this.ioTaskQueue.add(task);
                    continue;
                }
                long starTime = System.currentTimeMillis();
                Pair encodingMessage = (Pair)task;
                ChunkWriterImpl seriesWriter = new ChunkWriterImpl((MeasurementSchema)encodingMessage.right);
                this.writeOneSeries((TVList)encodingMessage.left, (IChunkWriter)seriesWriter, ((MeasurementSchema)encodingMessage.right).getType());
                MemTableFlushTask.this.ioTaskQueue.add(seriesWriter);
                memSerializeTime += System.currentTimeMillis() - starTime;
            }
            MemTableFlushTask.this.noMoreIOTask = true;
            logger.debug("Storage group {}, flushing memtable {} into disk: Encoding data cost {} ms.", new Object[]{MemTableFlushTask.this.storageGroup, MemTableFlushTask.this.memTable.getVersion(), memSerializeTime});
        }
    };
    private Runnable ioTask = () -> {
        long ioTime = 0L;
        boolean returnWhenNoTask = false;
        logger.debug("Storage group {} memtable {}, start io.", (Object)this.storageGroup, (Object)this.memTable.getVersion());
        while (true) {
            Object ioMessage;
            if (this.noMoreIOTask) {
                returnWhenNoTask = true;
            }
            if ((ioMessage = this.ioTaskQueue.poll()) == null) {
                if (returnWhenNoTask) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.error("Storage group {} memtable, io task is interrupted.", new Object[]{this.storageGroup, this.memTable.getVersion(), e});
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            long starTime = System.currentTimeMillis();
            try {
                if (ioMessage instanceof StartFlushGroupIOTask) {
                    this.writer.startChunkGroup(((StartFlushGroupIOTask)ioMessage).deviceId);
                } else if (ioMessage instanceof IChunkWriter) {
                    ChunkWriterImpl chunkWriter = (ChunkWriterImpl)ioMessage;
                    chunkWriter.writeToFileWriter((TsFileIOWriter)this.writer);
                } else {
                    EndChunkGroupIoTask endGroupTask = (EndChunkGroupIoTask)ioMessage;
                    this.writer.endChunkGroup(endGroupTask.version);
                }
            }
            catch (IOException e) {
                logger.error("Storage group {} memtable {}, io task meets error.", new Object[]{this.storageGroup, this.memTable.getVersion(), e});
                throw new FlushRunTimeException(e);
            }
            ioTime += System.currentTimeMillis() - starTime;
        }
        logger.debug("flushing a memtable {} in storage group {}, io cost {}ms", new Object[]{this.memTable.getVersion(), this.storageGroup, ioTime});
    };

    public MemTableFlushTask(IMemTable memTable, Schema schema, RestorableTsFileIOWriter writer, String storageGroup) {
        this.memTable = memTable;
        this.schema = schema;
        this.writer = writer;
        this.storageGroup = storageGroup;
        subTaskPoolManager.submit(this.encodingTask);
        this.ioTaskFuture = subTaskPoolManager.submit(this.ioTask);
        logger.debug("flush task of Storage group {} memtable {} is created ", (Object)storageGroup, (Object)memTable.getVersion());
    }

    public void syncFlushMemTable() throws ExecutionException, InterruptedException {
        long start = System.currentTimeMillis();
        long sortTime = 0L;
        for (String deviceId : this.memTable.getMemTableMap().keySet()) {
            this.encodingTaskQueue.add(new StartFlushGroupIOTask(deviceId));
            for (String measurementId : this.memTable.getMemTableMap().get(deviceId).keySet()) {
                long startTime = System.currentTimeMillis();
                IWritableMemChunk series = this.memTable.getMemTableMap().get(deviceId).get(measurementId);
                MeasurementSchema desc = this.schema.getMeasurementSchema(measurementId);
                TVList tvList = series.getSortedTVList();
                sortTime += System.currentTimeMillis() - startTime;
                this.encodingTaskQueue.add(new Pair((Object)tvList, (Object)desc));
            }
            this.encodingTaskQueue.add(new EndChunkGroupIoTask(this.memTable.getVersion()));
        }
        this.noMoreEncodingTask = true;
        logger.debug("Storage group {} memtable {}, flushing into disk: data sort time cost {} ms.", new Object[]{this.storageGroup, this.memTable.getVersion(), sortTime});
        this.ioTaskFuture.get();
        logger.info("Storage group {} memtable {} flushing a memtable has finished! Time consumption: {}ms", new Object[]{this.storageGroup, this.memTable, System.currentTimeMillis() - start});
    }

    static class StartFlushGroupIOTask {
        private String deviceId;

        StartFlushGroupIOTask(String deviceId) {
            this.deviceId = deviceId;
        }
    }

    static class EndChunkGroupIoTask {
        private long version;

        EndChunkGroupIoTask(long version) {
            this.version = version;
        }
    }
}

