/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.cache.LRULinkedHashMap;
import org.apache.iotdb.db.engine.cache.RamUsageEstimator;
import org.apache.iotdb.db.engine.cache.TsFileMetaDataCache;
import org.apache.iotdb.db.engine.cache.TsFileMetadataUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceMetaDataCache {
    private static final Logger logger = LoggerFactory.getLogger(DeviceMetaDataCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_B = config.getAllocateMemoryForChumkMetaDataCache();
    private static StorageEngine storageEngine = StorageEngine.getInstance();
    private static boolean cacheEnable = config.isMetaDataCacheEnable();
    private LRULinkedHashMap<String, List<ChunkMetaData>> lruCache;
    private AtomicLong cacheHitNum = new AtomicLong();
    private AtomicLong cacheRequestNum = new AtomicLong();
    private long chunkMetaDataSize = 0L;

    private DeviceMetaDataCache(long memoryThreshold) {
        this.lruCache = new LRULinkedHashMap<String, List<ChunkMetaData>>(memoryThreshold, true){

            @Override
            protected long calEntrySize(String key, List<ChunkMetaData> value) {
                if (DeviceMetaDataCache.this.chunkMetaDataSize == 0L && !value.isEmpty()) {
                    DeviceMetaDataCache.this.chunkMetaDataSize = RamUsageEstimator.sizeOf(value.get(0));
                }
                return (long)value.size() * DeviceMetaDataCache.this.chunkMetaDataSize + (long)(key.length() * 2);
            }
        };
    }

    public static DeviceMetaDataCache getInstance() {
        return RowGroupBlockMetaDataCacheSingleton.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChunkMetaData> get(TsFileResource resource, Path seriesPath) throws IOException {
        if (!cacheEnable) {
            TsFileMetaData fileMetaData = TsFileMetaDataCache.getInstance().get(resource);
            BloomFilter bloomFilter = fileMetaData.getBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(seriesPath.getFullPath())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("path not found by bloom filter, file is: " + resource.getFile() + " path is: " + seriesPath);
                }
                return new ArrayList<ChunkMetaData>();
            }
            TsDeviceMetadata deviceMetaData = TsFileMetadataUtils.getTsDeviceMetaData(resource, seriesPath, fileMetaData);
            if (deviceMetaData == null) {
                return new ArrayList<ChunkMetaData>();
            }
            return TsFileMetadataUtils.getChunkMetaDataList(seriesPath.getMeasurement(), deviceMetaData);
        }
        StringBuilder builder = new StringBuilder(resource.getFile().getPath()).append(".").append(seriesPath.getDevice());
        String pathDeviceStr = builder.toString();
        String key = builder.append(".").append(seriesPath.getMeasurement()).toString();
        String devicePathObject = pathDeviceStr.intern();
        Object object = this.lruCache;
        synchronized (object) {
            this.cacheRequestNum.incrementAndGet();
            if (this.lruCache.containsKey(key)) {
                this.cacheHitNum.incrementAndGet();
                this.printCacheLog(true);
                return new ArrayList<ChunkMetaData>((Collection)this.lruCache.get(key));
            }
        }
        object = devicePathObject;
        synchronized (object) {
            LRULinkedHashMap<String, List<ChunkMetaData>> lRULinkedHashMap = this.lruCache;
            synchronized (lRULinkedHashMap) {
                if (this.lruCache.containsKey(key)) {
                    this.printCacheLog(true);
                    this.cacheHitNum.incrementAndGet();
                    return new ArrayList<ChunkMetaData>((Collection)this.lruCache.get(key));
                }
            }
            this.printCacheLog(false);
            TsFileMetaData fileMetaData = TsFileMetaDataCache.getInstance().get(resource);
            BloomFilter bloomFilter = fileMetaData.getBloomFilter();
            if (bloomFilter != null && !bloomFilter.contains(seriesPath.getFullPath())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("path not found by bloom filter, file is: " + resource.getFile() + " path is: " + seriesPath);
                }
                return new ArrayList<ChunkMetaData>();
            }
            TsDeviceMetadata deviceMetaData = TsFileMetadataUtils.getTsDeviceMetaData(resource, seriesPath, fileMetaData);
            if (deviceMetaData == null) {
                return new ArrayList<ChunkMetaData>();
            }
            Map<Path, List<ChunkMetaData>> chunkMetaData = TsFileMetadataUtils.getChunkMetaDataList(this.calHotSensorSet(seriesPath), deviceMetaData);
            LRULinkedHashMap<String, List<ChunkMetaData>> lRULinkedHashMap2 = this.lruCache;
            synchronized (lRULinkedHashMap2) {
                chunkMetaData.forEach((path, chunkMetaDataList) -> {
                    String k = pathDeviceStr + "." + path.getMeasurement();
                    if (!this.lruCache.containsKey(k)) {
                        this.lruCache.put(k, (List<ChunkMetaData>)chunkMetaDataList);
                    }
                });
                if (chunkMetaData.containsKey(seriesPath)) {
                    return new ArrayList<ChunkMetaData>((Collection)chunkMetaData.get(seriesPath));
                }
                return new ArrayList<ChunkMetaData>();
            }
        }
    }

    private void printCacheLog(boolean isHit) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug("[ChunkMetaData cache {}hit] The number of requests for cache is {}, hit rate is {}.", new Object[]{isHit ? "" : "didn't ", this.cacheRequestNum.get(), (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get()});
    }

    public double calculateChunkMetaDataHitRatio() {
        if (this.cacheRequestNum.get() != 0L) {
            return (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get();
        }
        return 0.0;
    }

    private Set<String> calHotSensorSet(Path seriesPath) throws IOException {
        double usedMemProportion = this.lruCache.getUsedMemoryProportion();
        if (usedMemProportion < 0.6) {
            return new HashSet<String>();
        }
        double hotSensorProportion = usedMemProportion < 0.8 ? 0.1 : 0.05;
        try {
            return storageEngine.calTopKMeasurement(seriesPath.getDevice(), seriesPath.getMeasurement(), hotSensorProportion);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRULinkedHashMap<String, List<ChunkMetaData>> lRULinkedHashMap = this.lruCache;
        synchronized (lRULinkedHashMap) {
            if (this.lruCache != null) {
                this.lruCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TsFileResource resource) {
        LRULinkedHashMap<String, List<ChunkMetaData>> lRULinkedHashMap = this.lruCache;
        synchronized (lRULinkedHashMap) {
            this.lruCache.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(resource.getFile().getPath()));
        }
    }

    static /* synthetic */ long access$200() {
        return MEMORY_THRESHOLD_IN_B;
    }

    private static class RowGroupBlockMetaDataCacheSingleton {
        private static final DeviceMetaDataCache INSTANCE = new DeviceMetaDataCache(DeviceMetaDataCache.access$200());

        private RowGroupBlockMetaDataCacheSingleton() {
        }
    }
}

