/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.util.List;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(DirectoryStrategy.class);
    List<String> folders;

    public void init(List<String> folders) throws DiskSpaceInsufficientException {
        this.folders = folders;
        boolean hasSpace = false;
        for (String folder : folders) {
            if (!CommonUtils.hasSpace(folder)) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            throw new DiskSpaceInsufficientException(folders);
        }
    }

    public abstract int nextFolderIndex() throws DiskSpaceInsufficientException;
}

