/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private IoTDBConfig conf = new IoTDBConfig();

    private IoTDBDescriptor() {
        this.loadProps();
    }

    public static IoTDBDescriptor getInstance() {
        return IoTDBDescriptorHolder.INSTANCE;
    }

    public IoTDBConfig getConfig() {
        return this.conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPropsUrl() {
        String url = System.getProperty("IOTDB_CONF", null);
        if (url != null) return url + File.separatorChar + "iotdb-engine.properties";
        url = System.getProperty("IOTDB_HOME", null);
        if (url != null) {
            return url + File.separatorChar + "conf" + File.separatorChar + "iotdb-engine.properties";
        }
        logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-engine.properties");
        this.conf.updatePath();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        FileInputStream inputStream;
        String url = this.getPropsUrl();
        if (url == null) {
            return;
        }
        try {
            inputStream = new FileInputStream(new File(url));
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url, (Object)e);
            this.conf.updatePath();
            return;
        }
        logger.info("Start to read config file {}", (Object)url);
        Properties properties = new Properties();
        try {
            long memTableSizeThreshold;
            properties.load(inputStream);
            this.conf.setEnableStatMonitor(Boolean.parseBoolean(properties.getProperty("enable_stat_monitor", Boolean.toString(this.conf.isEnableStatMonitor()))));
            this.conf.setBackLoopPeriodSec(Integer.parseInt(properties.getProperty("back_loop_period_in_second", Integer.toString(this.conf.getBackLoopPeriodSec()))));
            int statMonitorDetectFreqSec = Integer.parseInt(properties.getProperty("stat_monitor_detect_freq_in_second", Integer.toString(this.conf.getStatMonitorDetectFreqSec())));
            int statMonitorRetainIntervalSec = Integer.parseInt(properties.getProperty("stat_monitor_retain_interval_in_second", Integer.toString(this.conf.getStatMonitorRetainIntervalSec())));
            if (this.conf.getStatMonitorDetectFreqSec() < statMonitorDetectFreqSec) {
                this.conf.setStatMonitorDetectFreqSec(statMonitorDetectFreqSec);
            } else {
                logger.info("The stat_monitor_detect_freq_sec value is smaller than default, use default value");
            }
            if (this.conf.getStatMonitorRetainIntervalSec() < statMonitorRetainIntervalSec) {
                this.conf.setStatMonitorRetainIntervalSec(statMonitorRetainIntervalSec);
            } else {
                logger.info("The stat_monitor_retain_interval_sec value is smaller than default, use default value");
            }
            this.conf.setMetricsPort(Integer.parseInt(properties.getProperty("metrics_port", Integer.toString(this.conf.getMetricsPort()))));
            this.conf.setRpcAddress(properties.getProperty("rpc_address", this.conf.getRpcAddress()));
            this.conf.setRpcThriftCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_thrift_compression_enable", Boolean.toString(this.conf.isRpcThriftCompressionEnable()))));
            this.conf.setRpcPort(Integer.parseInt(properties.getProperty("rpc_port", Integer.toString(this.conf.getRpcPort()))));
            this.conf.setTimestampPrecision(properties.getProperty("timestamp_precision", this.conf.getTimestampPrecision()));
            this.conf.setEnableParameterAdapter(Boolean.parseBoolean(properties.getProperty("enable_parameter_adapter", Boolean.toString(this.conf.isEnableParameterAdapter()))));
            this.conf.setMetaDataCacheEnable(Boolean.parseBoolean(properties.getProperty("meta_data_cache_enable", Boolean.toString(this.conf.isMetaDataCacheEnable()))));
            this.initMemoryAllocate(properties);
            this.conf.setEnableWal(Boolean.parseBoolean(properties.getProperty("enable_wal", Boolean.toString(this.conf.isEnableWal()))));
            this.conf.setBaseDir(properties.getProperty("base_dir", this.conf.getBaseDir()));
            this.conf.setSystemDir(FilePathUtils.regularizePath(this.conf.getBaseDir()) + "system");
            this.conf.setSchemaDir(FilePathUtils.regularizePath(this.conf.getSystemDir()) + "schema");
            this.conf.setQueryDir(FilePathUtils.regularizePath(this.conf.getBaseDir()) + "query");
            this.conf.setDataDirs(properties.getProperty("data_dirs", this.conf.getDataDirs()[0]).split(","));
            this.conf.setWalFolder(properties.getProperty("wal_dir", this.conf.getWalFolder()));
            this.conf.setFlushWalThreshold(Integer.parseInt(properties.getProperty("flush_wal_threshold", Integer.toString(this.conf.getFlushWalThreshold()))));
            this.conf.setForceWalPeriodInMs(Long.parseLong(properties.getProperty("force_wal_period_in_ms", Long.toString(this.conf.getForceWalPeriodInMs()))));
            int walBufferSize = Integer.parseInt(properties.getProperty("wal_buffer_size", Integer.toString(this.conf.getWalBufferSize())));
            if (walBufferSize > 0) {
                this.conf.setWalBufferSize(walBufferSize);
            }
            this.conf.setMultiDirStrategyClassName(properties.getProperty("multi_dir_strategy", this.conf.getMultiDirStrategyClassName()));
            this.conf.setFetchSize(Integer.parseInt(properties.getProperty("fetch_size", Integer.toString(this.conf.getFetchSize()))));
            long tsfileSizeThreshold = Long.parseLong(properties.getProperty("tsfile_size_threshold", Long.toString(this.conf.getTsFileSizeThreshold())).trim());
            if (tsfileSizeThreshold > 0L) {
                this.conf.setTsFileSizeThreshold(tsfileSizeThreshold);
            }
            if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.conf.setSyncEnable(Boolean.parseBoolean(properties.getProperty("is_sync_enable", Boolean.toString(this.conf.isSyncEnable()))));
            this.conf.setSyncServerPort(Integer.parseInt(properties.getProperty("sync_server_port", Integer.toString(this.conf.getSyncServerPort())).trim()));
            this.conf.setIpWhiteList(properties.getProperty("ip_white_list", this.conf.getIpWhiteList()));
            this.conf.setConcurrentFlushThread(Integer.parseInt(properties.getProperty("concurrent_flush_thread", Integer.toString(this.conf.getConcurrentFlushThread()))));
            if (this.conf.getConcurrentFlushThread() <= 0) {
                this.conf.setConcurrentFlushThread(Runtime.getRuntime().availableProcessors());
            }
            this.conf.setmManagerCacheSize(Integer.parseInt(properties.getProperty("schema_manager_cache_size", Integer.toString(this.conf.getmManagerCacheSize())).trim()));
            this.conf.setLanguageVersion(properties.getProperty("language_version", this.conf.getLanguageVersion()).trim());
            if (properties.containsKey("chunk_buffer_pool_enable")) {
                this.conf.setChunkBufferPoolEnable(Boolean.parseBoolean(properties.getProperty("chunk_buffer_pool_enable")));
            }
            String tmpTimeZone = properties.getProperty("time_zone", this.conf.getZoneID().toString());
            this.conf.setZoneID(ZoneId.of(tmpTimeZone.trim()));
            logger.info("Time zone has been set to {}", (Object)this.conf.getZoneID());
            this.conf.setEnableExternalSort(Boolean.parseBoolean(properties.getProperty("enable_external_sort", Boolean.toString(this.conf.isEnableExternalSort()))));
            this.conf.setExternalSortThreshold(Integer.parseInt(properties.getProperty("external_sort_threshold", Integer.toString(this.conf.getExternalSortThreshold()))));
            this.conf.setUpgradeThreadNum(Integer.parseInt(properties.getProperty("upgrade_thread_num", Integer.toString(this.conf.getUpgradeThreadNum()))));
            this.conf.setMergeMemoryBudget(Long.parseLong(properties.getProperty("merge_memory_budget", Long.toString(this.conf.getMergeMemoryBudget()))));
            this.conf.setMergeThreadNum(Integer.parseInt(properties.getProperty("merge_thread_num", Integer.toString(this.conf.getMergeThreadNum()))));
            this.conf.setMergeChunkSubThreadNum(Integer.parseInt(properties.getProperty("merge_chunk_subthread_num", Integer.toString(this.conf.getMergeChunkSubThreadNum()))));
            this.conf.setContinueMergeAfterReboot(Boolean.parseBoolean(properties.getProperty("continue_merge_after_reboot", Boolean.toString(this.conf.isContinueMergeAfterReboot()))));
            this.conf.setMergeFileSelectionTimeBudget(Long.parseLong(properties.getProperty("merge_fileSelection_time_budget", Long.toString(this.conf.getMergeFileSelectionTimeBudget()))));
            this.conf.setMergeIntervalSec(Long.parseLong(properties.getProperty("merge_interval_sec", Long.toString(this.conf.getMergeIntervalSec()))));
            this.conf.setForceFullMerge(Boolean.parseBoolean(properties.getProperty("force_full_merge", Boolean.toString(this.conf.isForceFullMerge()))));
            this.conf.setChunkMergePointThreshold(Integer.parseInt(properties.getProperty("chunk_merge_point_threshold", Integer.toString(this.conf.getChunkMergePointThreshold()))));
            this.conf.setEnablePerformanceStat(Boolean.parseBoolean(properties.getProperty("enable_performance_stat", Boolean.toString(this.conf.isEnablePerformanceStat())).trim()));
            this.conf.setPerformanceStatDisplayInterval(Long.parseLong(properties.getProperty("performance_stat_display_interval", Long.toString(this.conf.getPerformanceStatDisplayInterval())).trim()));
            this.conf.setPerformanceStatMemoryInKB(Integer.parseInt(properties.getProperty("performance_stat_memory_in_kb", Integer.toString(this.conf.getPerformanceStatMemoryInKB())).trim()));
            int maxConcurrentClientNum = Integer.parseInt(properties.getProperty("rpc_max_concurrent_client_num", Integer.toString(this.conf.getRpcMaxConcurrentClientNum()).trim()));
            if (maxConcurrentClientNum <= 0) {
                maxConcurrentClientNum = 65535;
            }
            this.conf.setEnableWatermark(Boolean.parseBoolean(properties.getProperty("watermark_module_opened", Boolean.toString(this.conf.isEnableWatermark()).trim())));
            this.conf.setWatermarkSecretKey(properties.getProperty("watermark_secret_key", this.conf.getWatermarkSecretKey()));
            this.conf.setWatermarkBitString(properties.getProperty("watermark_bit_string", this.conf.getWatermarkBitString()));
            this.conf.setWatermarkMethod(properties.getProperty("watermark_method", this.conf.getWatermarkMethod()));
            this.conf.setAutoCreateSchemaEnabled(Boolean.parseBoolean(properties.getProperty("enable_auto_create_schema", Boolean.toString(this.conf.isAutoCreateSchemaEnabled()).trim())));
            this.conf.setDefaultStorageGroupLevel(Integer.parseInt(properties.getProperty("default_storage_group_level", Integer.toString(this.conf.getDefaultStorageGroupLevel()))));
            this.conf.setDefaultBooleanEncoding(properties.getProperty("default_boolean_encoding", this.conf.getDefaultBooleanEncoding().toString()));
            this.conf.setDefaultInt32Encoding(properties.getProperty("default_int32_encoding", this.conf.getDefaultInt32Encoding().toString()));
            this.conf.setDefaultInt64Encoding(properties.getProperty("default_int64_encoding", this.conf.getDefaultInt64Encoding().toString()));
            this.conf.setDefaultFloatEncoding(properties.getProperty("default_float_encoding", this.conf.getDefaultFloatEncoding().toString()));
            this.conf.setDefaultDoubleEncoding(properties.getProperty("default_double_encoding", this.conf.getDefaultDoubleEncoding().toString()));
            this.conf.setDefaultTextEncoding(properties.getProperty("default_text_encoding", this.conf.getDefaultTextEncoding().toString()));
            this.conf.setRpcMaxConcurrentClientNum(maxConcurrentClientNum);
            this.conf.setTsFileStorageFs(properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().toString()));
            this.conf.setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
            this.conf.setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
            this.conf.setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
            this.conf.setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
            this.conf.setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
            this.conf.setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
            this.conf.setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
            this.conf.setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
            this.conf.setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
            this.conf.setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
            this.conf.setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
            this.conf.setDefaultTTL(Long.parseLong(properties.getProperty("default_ttl", String.valueOf(this.conf.getDefaultTTL()))));
            TSFileDescriptor.getInstance().getConfig().setTSFileStorageFs(properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().name()));
            TSFileDescriptor.getInstance().getConfig().setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
            TSFileDescriptor.getInstance().getConfig().setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
            TSFileDescriptor.getInstance().getConfig().setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
            TSFileDescriptor.getInstance().getConfig().setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
            TSFileDescriptor.getInstance().getConfig().setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
            TSFileDescriptor.getInstance().getConfig().setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
            TSFileDescriptor.getInstance().getConfig().setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
            TSFileDescriptor.getInstance().getConfig().setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
            TSFileDescriptor.getInstance().getConfig().setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
            TSFileDescriptor.getInstance().getConfig().setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
            TSFileDescriptor.getInstance().getConfig().setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()))));
            TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()))));
            if (TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() > TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()) {
                logger.warn("page_size is greater than group size, will set it as the same with group size");
                TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte());
            }
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage()))));
            TSFileDescriptor.getInstance().getConfig().setTimeSeriesDataType(properties.getProperty("time_series_data_type", TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType()));
            TSFileDescriptor.getInstance().getConfig().setMaxStringLength(Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxStringLength()))));
            TSFileDescriptor.getInstance().getConfig().setBloomFilterErrorRate(Double.parseDouble(properties.getProperty("bloom_filter_error_rate", Double.toString(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate()))));
            TSFileDescriptor.getInstance().getConfig().setFloatPrecision(Integer.parseInt(properties.getProperty("float_precision", Integer.toString(TSFileDescriptor.getInstance().getConfig().getFloatPrecision()))));
            TSFileDescriptor.getInstance().getConfig().setTimeEncoder(properties.getProperty("time_encoder", TSFileDescriptor.getInstance().getConfig().getTimeEncoder()));
            TSFileDescriptor.getInstance().getConfig().setValueEncoder(properties.getProperty("value_encoder", TSFileDescriptor.getInstance().getConfig().getValueEncoder()));
            TSFileDescriptor.getInstance().getConfig().setCompressor(properties.getProperty("compressor", TSFileDescriptor.getInstance().getConfig().getCompressor()));
        }
        catch (IOException e) {
            logger.warn("Cannot load config file because, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Incorrect format in config file, use default configuration", (Throwable)e);
        }
        finally {
            this.conf.updatePath();
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("Fail to close config file input stream because ", (Throwable)e);
            }
        }
    }

    private void initMemoryAllocate(Properties properties) {
        String memoryAllocateProportion = properties.getProperty("write_read_free_memory_proportion");
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            this.conf.setAllocateMemoryForWrite(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
            this.conf.setAllocateMemoryForRead(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
        }
        if (!this.conf.isMetaDataCacheEnable()) {
            return;
        }
        String queryMemoryAllocateProportion = properties.getProperty("filemeta_chunkmeta_free_memory_proportion");
        if (queryMemoryAllocateProportion != null) {
            String[] proportions = queryMemoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = this.conf.getAllocateMemoryForRead();
            try {
                this.conf.setAllocateMemoryForFileMetaDataCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForChumkMetaDataCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
            }
            catch (Exception e) {
                throw new RuntimeException("Each subsection of configuration item filemeta_chunkmeta_free_memory_proportion should be an integer, which is " + queryMemoryAllocateProportion);
            }
        }
    }

    private static class IoTDBDescriptorHolder {
        private static final IoTDBDescriptor INSTANCE = new IoTDBDescriptor();

        private IoTDBDescriptorHolder() {
        }
    }
}

