/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigCheck {
    public static final String PROPERTIES_FILE_NAME = "system.properties";
    public static final String SCHEMA_DIR = IoTDBDescriptor.getInstance().getConfig().getSchemaDir();
    private static final IoTDBConfigCheck INSTANCE = new IoTDBConfigCheck();
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private Properties properties = new Properties();
    private static String TIMESTAMP_PRECISION = "ms";

    public static final IoTDBConfigCheck getInstance() {
        return INSTANCE;
    }

    public void checkConfig() {
        TIMESTAMP_PRECISION = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision();
        this.createDir(SCHEMA_DIR);
        this.checkFile(SCHEMA_DIR);
        logger.info("System configuration is ok.");
    }

    public void createDir(String filepath) {
        File dir = SystemFileFactory.INSTANCE.getFile(filepath);
        if (!dir.exists()) {
            dir.mkdirs();
            logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
        }
    }

    public void checkFile(String filepath) {
        File file;
        block29: {
            file = SystemFileFactory.INSTANCE.getFile(filepath + File.separator + PROPERTIES_FILE_NAME);
            try {
                if (file.exists()) break block29;
                file.createNewFile();
                logger.info(" {} has been created.", (Object)file.getAbsolutePath());
                try (FileOutputStream outputStream = new FileOutputStream(file.toString());){
                    this.properties.setProperty("timestamp_precision", TIMESTAMP_PRECISION);
                    this.properties.store(outputStream, "System properties:");
                }
            }
            catch (IOException e) {
                logger.error("Can not create {}.", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        File inputFile = SystemFileFactory.INSTANCE.getFile(filepath + File.separator + PROPERTIES_FILE_NAME);
        try (FileInputStream inputStream = new FileInputStream(inputFile.toString());){
            this.properties.load(new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET));
            if (!this.properties.getProperty("timestamp_precision").equals(TIMESTAMP_PRECISION)) {
                logger.error("Wrong timestamp precision, please set as: " + this.properties.getProperty("timestamp_precision") + " !");
                System.exit(-1);
            }
        }
        catch (IOException e) {
            logger.error("Load system.properties from {} failed.", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

