/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestorableTsFileIOWriter
extends TsFileIOWriter {
    private static final Logger logger = LoggerFactory.getLogger(RestorableTsFileIOWriter.class);
    private long truncatedPosition = -1L;
    private Map<String, MeasurementSchema> knownSchemas = new HashMap<String, MeasurementSchema>();
    private int lastFlushedChunkGroupIndex = 0;
    private boolean crashed;
    private Map<String, Map<String, List<ChunkMetaData>>> metadatas = new HashMap<String, Map<String, List<ChunkMetaData>>>();

    long getTruncatedPosition() {
        return this.truncatedPosition;
    }

    public RestorableTsFileIOWriter(File file) throws IOException {
        this.file = file;
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), true);
        if (file.length() == 0L) {
            this.startFile();
            return;
        }
        if (file.exists()) {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                if (reader.isComplete()) {
                    this.crashed = false;
                    this.canWrite = false;
                    this.out.close();
                    return;
                }
                this.truncatedPosition = reader.selfCheck(this.knownSchemas, this.chunkGroupMetaDataList, true);
                this.totalChunkNum = reader.getTotalChunkNum();
                if (this.truncatedPosition == -3L) {
                    this.out.close();
                    throw new IOException(String.format("%s is not in TsFile format.", file.getAbsolutePath()));
                }
                if (this.truncatedPosition == -2L) {
                    this.crashed = true;
                    this.out.truncate("TsFile".getBytes().length + "000001".getBytes().length);
                } else {
                    this.crashed = true;
                    this.out.truncate(this.truncatedPosition);
                }
            }
        }
    }

    @Override
    public Map<String, MeasurementSchema> getKnownSchema() {
        return this.knownSchemas;
    }

    public List<ChunkMetaData> getVisibleMetadataList(String deviceId, String measurementId, TSDataType dataType) {
        ArrayList<ChunkMetaData> chunkMetaDataList = new ArrayList<ChunkMetaData>();
        if (this.metadatas.containsKey(deviceId) && this.metadatas.get(deviceId).containsKey(measurementId)) {
            for (ChunkMetaData chunkMetaData : this.metadatas.get(deviceId).get(measurementId)) {
                if (dataType != null && !dataType.equals((Object)chunkMetaData.getTsDataType())) continue;
                chunkMetaDataList.add(chunkMetaData);
            }
        }
        return chunkMetaDataList;
    }

    public void makeMetadataVisible() {
        List<ChunkGroupMetaData> newlyFlushedMetadataList = this.getAppendedRowGroupMetadata();
        if (!newlyFlushedMetadataList.isEmpty()) {
            for (ChunkGroupMetaData rowGroupMetaData : newlyFlushedMetadataList) {
                String deviceId = rowGroupMetaData.getDeviceID();
                for (ChunkMetaData chunkMetaData : rowGroupMetaData.getChunkMetaDataList()) {
                    String measurementId = chunkMetaData.getMeasurementUid();
                    if (!this.metadatas.containsKey(deviceId)) {
                        this.metadatas.put(deviceId, new HashMap());
                    }
                    if (!this.metadatas.get(deviceId).containsKey(measurementId)) {
                        this.metadatas.get(deviceId).put(measurementId, new ArrayList());
                    }
                    this.metadatas.get(deviceId).get(measurementId).add(chunkMetaData);
                }
            }
        }
    }

    public boolean hasCrashed() {
        return this.crashed;
    }

    private List<ChunkGroupMetaData> getAppendedRowGroupMetadata() {
        ArrayList<ChunkGroupMetaData> append = new ArrayList<ChunkGroupMetaData>();
        if (this.lastFlushedChunkGroupIndex < this.chunkGroupMetaDataList.size()) {
            append.addAll(this.chunkGroupMetaDataList.subList(this.lastFlushedChunkGroupIndex, this.chunkGroupMetaDataList.size()));
            this.lastFlushedChunkGroupIndex = this.chunkGroupMetaDataList.size();
        }
        return append;
    }

    public static RestorableTsFileIOWriter getWriterForAppendingDataOnCompletedTsFile(File file) throws IOException {
        long position = file.length();
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
            if (reader.isComplete()) {
                reader.loadMetadataSize();
                TsFileMetaData metaData = reader.readFileMetadata();
                for (TsDeviceMetadataIndex deviceMetadata : metaData.getDeviceMap().values()) {
                    if (position <= deviceMetadata.getOffset()) continue;
                    position = deviceMetadata.getOffset();
                }
            }
        }
        if (position != file.length()) {
            var4_3 = null;
            try (FileChannel channel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);){
                channel.truncate(position - 1L);
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
        }
        return new RestorableTsFileIOWriter(file);
    }

    public void addSchema(MeasurementSchema schema) {
        this.knownSchemas.put(schema.getMeasurementId(), schema);
    }
}

