/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.DefaultTsFileOutput;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class ForceAppendTsFileWriter
extends TsFileIOWriter {
    private Map<String, MeasurementSchema> knownSchemas;
    private long truncatePosition;

    public ForceAppendTsFileWriter(File file) throws IOException {
        this.out = new DefaultTsFileOutput(file, true);
        this.file = file;
        if (file.length() == 0L || !file.exists()) {
            throw new TsFileNotCompleteException("File " + file.getPath() + " is not a complete TsFile");
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), true);){
            if (!reader.isComplete()) {
                throw new TsFileNotCompleteException("File " + file.getPath() + " is not a complete TsFile");
            }
            TsFileMetaData fileMetaData = reader.readFileMetadata();
            Map<String, TsDeviceMetadataIndex> deviceMap = fileMetaData.getDeviceMap();
            long firstDeviceMetaPos = Long.MAX_VALUE;
            for (TsDeviceMetadataIndex deviceMetadataIndex : deviceMap.values()) {
                TsDeviceMetadata tsDeviceMetadata = reader.readTsDeviceMetaData(deviceMetadataIndex);
                this.chunkGroupMetaDataList.addAll(tsDeviceMetadata.getChunkGroupMetaDataList());
                firstDeviceMetaPos = firstDeviceMetaPos > deviceMetadataIndex.getOffset() ? deviceMetadataIndex.getOffset() : firstDeviceMetaPos;
            }
            this.truncatePosition = firstDeviceMetaPos - 1L;
            this.knownSchemas = fileMetaData.getMeasurementSchema();
        }
    }

    public void doTruncate() throws IOException {
        this.out.truncate(this.truncatePosition);
    }

    public long getTruncatePosition() {
        return this.truncatePosition;
    }

    @Override
    public Map<String, MeasurementSchema> getKnownSchema() {
        return this.knownSchemas;
    }
}

