/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.page;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class PageWriter {
    private Encoder timeEncoder;
    private PublicBAOS timeOut = new PublicBAOS();
    private Encoder valueEncoder;
    private PublicBAOS valueOut = new PublicBAOS();

    public PageWriter() {
        this(null, null);
    }

    public PageWriter(MeasurementSchema measurementSchema) {
        this(measurementSchema.getTimeEncoder(), measurementSchema.getValueEncoder());
    }

    public PageWriter(Encoder timeEncoder, Encoder valueEncoder) {
        this.timeEncoder = timeEncoder;
        this.valueEncoder = valueEncoder;
    }

    public void write(long time, boolean value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, short value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, int value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, long value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, float value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, double value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, BigDecimal value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long time, Binary value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
    }

    public void write(long[] timestamps, boolean[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    public void write(long[] timestamps, int[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    public void write(long[] timestamps, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    public void write(long[] timestamps, float[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    public void write(long[] timestamps, double[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    public void write(long[] timestamps, BigDecimal[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    public void write(long[] timestamps, Binary[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
    }

    private void prepareEndWriteOnePage() throws IOException {
        this.timeEncoder.flush(this.timeOut);
        this.valueEncoder.flush(this.valueOut);
    }

    public ByteBuffer getUncompressedBytes() throws IOException {
        this.prepareEndWriteOnePage();
        ByteBuffer buffer = ByteBuffer.allocate(this.timeOut.size() + this.valueOut.size() + 4);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(this.timeOut.size(), buffer);
        buffer.put(this.timeOut.getBuf(), 0, this.timeOut.size());
        buffer.put(this.valueOut.getBuf(), 0, this.valueOut.size());
        buffer.flip();
        return buffer;
    }

    public long estimateMaxMemSize() {
        return (long)(this.timeOut.size() + this.valueOut.size()) + this.timeEncoder.getMaxByteSize() + this.valueEncoder.getMaxByteSize();
    }

    public void reset() {
        this.timeOut.reset();
        this.valueOut.reset();
    }

    public void setTimeEncoder(Encoder encoder) {
        this.timeEncoder = encoder;
    }

    public void setValueEncoder(Encoder encoder) {
        this.valueEncoder = encoder;
    }
}

