/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.ChunkBuffer;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.page.PageWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkWriterImpl
implements IChunkWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkWriterImpl.class);
    private MeasurementSchema measurementSchema;
    private final ChunkBuffer chunkBuffer;
    private PageWriter pageWriter;
    private final long pageSizeThreshold;
    private final int maxNumberOfPointsInPage;
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 1500;
    private int valueCountInOnePage;
    private int valueCountInOnePageForNextCheck;
    private Statistics<?> chunkStatistics;
    private Statistics<?> pageStatistics;
    private long maxTimestamp;
    private long minTimestamp = Long.MIN_VALUE;

    public ChunkWriterImpl(MeasurementSchema schema) {
        this.measurementSchema = schema;
        this.chunkBuffer = new ChunkBuffer(this.measurementSchema);
        this.pageSizeThreshold = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.maxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        this.valueCountInOnePageForNextCheck = 1500;
        this.chunkStatistics = Statistics.getStatsByType(this.measurementSchema.getType());
        this.pageStatistics = Statistics.getStatsByType(this.measurementSchema.getType());
        this.pageWriter = new PageWriter();
        this.pageWriter.setTimeEncoder(this.measurementSchema.getTimeEncoder());
        this.pageWriter.setValueEncoder(this.measurementSchema.getValueEncoder());
    }

    @Override
    public void write(long time, long value) {
        this.maxTimestamp = time;
        ++this.valueCountInOnePage;
        this.pageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, int value) {
        this.maxTimestamp = time;
        ++this.valueCountInOnePage;
        this.pageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, boolean value) {
        this.maxTimestamp = time;
        ++this.valueCountInOnePage;
        this.pageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, float value) {
        this.maxTimestamp = time;
        ++this.valueCountInOnePage;
        this.pageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, double value) {
        this.maxTimestamp = time;
        ++this.valueCountInOnePage;
        this.pageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, Binary value) {
        this.maxTimestamp = time;
        ++this.valueCountInOnePage;
        this.pageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, int[] values, int batchSize) {
        this.maxTimestamp = timestamps[batchSize - 1];
        this.valueCountInOnePage += batchSize;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = timestamps[0];
        }
        this.pageWriter.write(timestamps, values, batchSize);
        this.pageStatistics.updateStats(values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, long[] values, int batchSize) {
        this.maxTimestamp = timestamps[batchSize - 1];
        this.valueCountInOnePage += batchSize;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = timestamps[0];
        }
        this.pageWriter.write(timestamps, values, batchSize);
        this.pageStatistics.updateStats(values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, boolean[] values, int batchSize) {
        this.maxTimestamp = timestamps[batchSize - 1];
        this.valueCountInOnePage += batchSize;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = timestamps[0];
        }
        this.pageWriter.write(timestamps, values, batchSize);
        this.pageStatistics.updateStats(values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, float[] values, int batchSize) {
        this.maxTimestamp = timestamps[batchSize - 1];
        this.valueCountInOnePage += batchSize;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = timestamps[0];
        }
        this.pageWriter.write(timestamps, values, batchSize);
        this.pageStatistics.updateStats(values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, double[] values, int batchSize) {
        this.maxTimestamp = timestamps[batchSize - 1];
        this.valueCountInOnePage += batchSize;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = timestamps[0];
        }
        this.pageWriter.write(timestamps, values, batchSize);
        this.pageStatistics.updateStats(values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long[] timestamps, Binary[] values, int batchSize) {
        this.maxTimestamp = timestamps[batchSize - 1];
        this.valueCountInOnePage += batchSize;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = timestamps[0];
        }
        this.pageWriter.write(timestamps, values, batchSize);
        this.pageStatistics.updateStats(values, batchSize);
        this.checkPageSizeAndMayOpenANewPage();
    }

    private void checkPageSizeAndMayOpenANewPage() {
        if (this.valueCountInOnePage == this.maxNumberOfPointsInPage) {
            LOG.debug("current line count reaches the upper bound, write page {}", (Object)this.measurementSchema);
            this.writePage();
        } else if (this.valueCountInOnePage >= this.valueCountInOnePageForNextCheck) {
            long currentPageSize = this.pageWriter.estimateMaxMemSize();
            if (currentPageSize > this.pageSizeThreshold) {
                LOG.debug("enough size, write page {}, pageSizeThreshold:{}, currentPateSize:{}, valueCountInOnePage:{}", new Object[]{this.measurementSchema.getMeasurementId(), this.pageSizeThreshold, currentPageSize, this.valueCountInOnePage});
                this.writePage();
                this.valueCountInOnePageForNextCheck = 1500;
            } else {
                this.valueCountInOnePageForNextCheck = (int)((float)this.pageSizeThreshold / (float)currentPageSize * (float)this.valueCountInOnePage);
            }
        }
    }

    private void writePage() {
        try {
            this.chunkBuffer.writePageHeaderAndDataIntoBuff(this.pageWriter.getUncompressedBytes(), this.valueCountInOnePage, this.pageStatistics, this.maxTimestamp, this.minTimestamp);
            this.chunkStatistics.mergeStatistics(this.pageStatistics);
        }
        catch (IOException e) {
            LOG.error("meet error in pageWriter.getUncompressedBytes(),ignore this page:", (Throwable)e);
        }
        catch (PageException e) {
            LOG.error("meet error in chunkBuffer.writePageHeaderAndDataIntoBuff, ignore this page:", (Throwable)e);
        }
        finally {
            this.minTimestamp = Long.MIN_VALUE;
            this.valueCountInOnePage = 0;
            this.pageWriter.reset();
            this.pageStatistics = Statistics.getStatsByType(this.measurementSchema.getType());
        }
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.sealCurrentPage();
        this.chunkBuffer.writeAllPagesOfSeriesToTsFile(tsfileWriter, this.chunkStatistics);
        this.chunkBuffer.reset();
        this.chunkStatistics = Statistics.getStatsByType(this.measurementSchema.getType());
    }

    @Override
    public long estimateMaxSeriesMemSize() {
        return this.pageWriter.estimateMaxMemSize() + this.chunkBuffer.estimateMaxPageMemSize();
    }

    @Override
    public long getCurrentChunkSize() {
        return (long)ChunkHeader.getSerializedSize(this.measurementSchema.getMeasurementId()) + this.chunkBuffer.getCurrentDataSize();
    }

    @Override
    public void sealCurrentPage() {
        if (this.valueCountInOnePage > 0) {
            this.writePage();
        }
    }

    @Override
    public int getNumOfPages() {
        return this.chunkBuffer.getNumOfPages();
    }

    public ChunkBuffer getChunkBuffer() {
        return this.chunkBuffer;
    }

    @Override
    public TSDataType getDataType() {
        return this.measurementSchema.getType();
    }
}

