/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.NoMeasurementException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.record.RowBatch;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkGroupWriterImpl.class);
    private final String deviceId;
    private Map<String, IChunkWriter> chunkWriters = new HashMap<String, IChunkWriter>();

    public ChunkGroupWriterImpl(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public void tryToAddSeriesWriter(MeasurementSchema schema, int pageSizeThreshold) {
        if (!this.chunkWriters.containsKey(schema.getMeasurementId())) {
            ChunkWriterImpl seriesWriter = new ChunkWriterImpl(schema);
            this.chunkWriters.put(schema.getMeasurementId(), seriesWriter);
        }
    }

    @Override
    public void write(long time, List<DataPoint> data) throws WriteProcessException, IOException {
        for (DataPoint point : data) {
            String measurementId = point.getMeasurementId();
            if (!this.chunkWriters.containsKey(measurementId)) {
                throw new NoMeasurementException("time " + time + ", measurement id " + measurementId + " not found!");
            }
            point.writeTo(time, this.chunkWriters.get(measurementId));
        }
    }

    @Override
    public void write(RowBatch rowBatch) throws WriteProcessException, IOException {
        List<MeasurementSchema> measurements = rowBatch.measurements;
        for (int i = 0; i < measurements.size(); ++i) {
            String measurementId = measurements.get(i).getMeasurementId();
            TSDataType dataType = measurements.get(i).getType();
            if (!this.chunkWriters.containsKey(measurementId)) {
                throw new NoMeasurementException("measurement id" + measurementId + " not found!");
            }
            this.writeByDataType(rowBatch, measurementId, dataType, i);
        }
    }

    private void writeByDataType(RowBatch rowBatch, String measurementId, TSDataType dataType, int index) throws IOException {
        int batchSize = rowBatch.batchSize;
        switch (dataType) {
            case INT32: {
                this.chunkWriters.get(measurementId).write(rowBatch.timestamps, (int[])rowBatch.values[index], batchSize);
                break;
            }
            case INT64: {
                this.chunkWriters.get(measurementId).write(rowBatch.timestamps, (long[])rowBatch.values[index], batchSize);
                break;
            }
            case FLOAT: {
                this.chunkWriters.get(measurementId).write(rowBatch.timestamps, (float[])rowBatch.values[index], batchSize);
                break;
            }
            case DOUBLE: {
                this.chunkWriters.get(measurementId).write(rowBatch.timestamps, (double[])rowBatch.values[index], batchSize);
                break;
            }
            case BOOLEAN: {
                this.chunkWriters.get(measurementId).write(rowBatch.timestamps, (boolean[])rowBatch.values[index], batchSize);
                break;
            }
            case TEXT: {
                this.chunkWriters.get(measurementId).write(rowBatch.timestamps, (Binary[])rowBatch.values[index], batchSize);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
            }
        }
    }

    @Override
    public long flushToFileWriter(TsFileIOWriter fileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        long currentChunkGroupSize = this.getCurrentChunkGroupSize();
        for (IChunkWriter seriesWriter : this.chunkWriters.values()) {
            seriesWriter.writeToFileWriter(fileWriter);
        }
        return currentChunkGroupSize;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = 0L;
        for (IChunkWriter seriesWriter : this.chunkWriters.values()) {
            bufferSize += seriesWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = 0L;
        for (IChunkWriter writer : this.chunkWriters.values()) {
            size += writer.getCurrentChunkSize();
        }
        return size;
    }

    private void sealAllChunks() {
        for (IChunkWriter writer : this.chunkWriters.values()) {
            writer.sealCurrentPage();
        }
    }

    @Override
    public int getSeriesNumber() {
        return this.chunkWriters.size();
    }
}

