/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.nio.ByteBuffer;

public class Murmur128Hash {
    public static int hash(String value, int seed) {
        return (int)Murmur128Hash.hash3_x64_128(ByteBuffer.wrap(value.getBytes()), 0, value.length(), seed);
    }

    private static long getBlock(ByteBuffer key, int offset, int index) {
        int i_8 = index << 3;
        int blockOffset = offset + i_8;
        return ((long)key.get(blockOffset) & 0xFFL) + (((long)key.get(blockOffset + 1) & 0xFFL) << 8) + (((long)key.get(blockOffset + 2) & 0xFFL) << 16) + (((long)key.get(blockOffset + 3) & 0xFFL) << 24) + (((long)key.get(blockOffset + 4) & 0xFFL) << 32) + (((long)key.get(blockOffset + 5) & 0xFFL) << 40) + (((long)key.get(blockOffset + 6) & 0xFFL) << 48) + (((long)key.get(blockOffset + 7) & 0xFFL) << 56);
    }

    private static long rotl64(long v, int n) {
        return v << n | v >>> 64 - n;
    }

    private static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long hash3_x64_128(ByteBuffer key, int offset, int length, long seed) {
        int nblocks = length >> 4;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = Murmur128Hash.getBlock(key, offset, i * 2 + 0);
            long k2 = Murmur128Hash.getBlock(key, offset, i * 2 + 1);
            k1 *= c1;
            k1 = Murmur128Hash.rotl64(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = Murmur128Hash.rotl64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = Murmur128Hash.rotl64(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = Murmur128Hash.rotl64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset += nblocks * 16;
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)key.get(offset + 14) << 48;
            }
            case 14: {
                k2 ^= (long)key.get(offset + 13) << 40;
            }
            case 13: {
                k2 ^= (long)key.get(offset + 12) << 32;
            }
            case 12: {
                k2 ^= (long)key.get(offset + 11) << 24;
            }
            case 11: {
                k2 ^= (long)key.get(offset + 10) << 16;
            }
            case 10: {
                k2 ^= (long)key.get(offset + 9) << 8;
            }
            case 9: {
                k2 ^= (long)key.get(offset + 8);
                k2 *= c2;
                k2 = Murmur128Hash.rotl64(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)key.get(offset + 7) << 56;
            }
            case 7: {
                k1 ^= (long)key.get(offset + 6) << 48;
            }
            case 6: {
                k1 ^= (long)key.get(offset + 5) << 40;
            }
            case 5: {
                k1 ^= (long)key.get(offset + 4) << 32;
            }
            case 4: {
                k1 ^= (long)key.get(offset + 3) << 24;
            }
            case 3: {
                k1 ^= (long)key.get(offset + 2) << 16;
            }
            case 2: {
                k1 ^= (long)key.get(offset + 1) << 8;
            }
            case 1: {
                k1 ^= (long)key.get(offset);
                k1 *= c1;
                k1 = Murmur128Hash.rotl64(k1, 31);
                h1 ^= (k1 *= c2);
                break;
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = Murmur128Hash.fmix(h1);
        h2 = Murmur128Hash.fmix(h2);
        h1 += h2;
        return h1 + (h2 += h1);
    }
}

