/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class Binary
implements Comparable<Binary>,
Serializable {
    private static final long serialVersionUID = 6394197743397020735L;
    private byte[] values;

    public Binary(byte[] v) {
        this.values = v;
    }

    public Binary(String s) {
        this.values = s == null ? null : s.getBytes(TSFileConfig.STRING_CHARSET);
    }

    public static Binary valueOf(String value) {
        return new Binary(BytesUtils.stringToBytes(value));
    }

    @Override
    public int compareTo(Binary other) {
        if (other == null) {
            if (this.values == null) {
                return 0;
            }
            return 1;
        }
        for (int i = 0; i < this.getLength() && i < other.getLength(); ++i) {
            if (this.values[i] == other.values[i]) {
                continue;
            }
            return this.values[i] - other.values[i];
        }
        return this.getLength() - other.getLength();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((Binary)other) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public int getLength() {
        if (this.values == null) {
            return -1;
        }
        return this.values.length;
    }

    public String getStringValue() {
        return new String(this.values, TSFileConfig.STRING_CHARSET);
    }

    public String getTextEncodingType() {
        return "UTF-8";
    }

    public String toString() {
        return this.getStringValue();
    }

    public byte[] getValues() {
        return this.values;
    }
}

