/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public abstract class FileSeriesReader {
    protected IChunkLoader chunkLoader;
    protected List<ChunkMetaData> chunkMetaDataList;
    protected ChunkReader chunkReader;
    private int chunkToRead;
    private BatchData data;

    public FileSeriesReader(IChunkLoader chunkLoader, List<ChunkMetaData> chunkMetaDataList) {
        this.chunkLoader = chunkLoader;
        this.chunkMetaDataList = chunkMetaDataList;
        this.chunkToRead = 0;
    }

    public boolean hasNextBatch() throws IOException {
        if (this.chunkReader != null && this.chunkReader.hasNextBatch()) {
            return true;
        }
        while (this.chunkToRead < this.chunkMetaDataList.size()) {
            ChunkMetaData chunkMetaData = this.nextChunkMeta();
            if (!this.chunkSatisfied(chunkMetaData)) continue;
            this.initChunkReader(chunkMetaData);
            if (!this.chunkReader.hasNextBatch()) continue;
            return true;
        }
        return false;
    }

    public BatchData nextBatch() throws IOException {
        this.data = this.chunkReader.nextBatch();
        return this.data;
    }

    public BatchData currentBatch() {
        return this.data;
    }

    public PageHeader nextPageHeader() throws IOException {
        return this.chunkReader.nextPageHeader();
    }

    public void skipPageData() {
        this.chunkReader.skipPageData();
    }

    protected abstract void initChunkReader(ChunkMetaData var1) throws IOException;

    protected abstract boolean chunkSatisfied(ChunkMetaData var1);

    public void close() throws IOException {
        this.chunkLoader.close();
    }

    private ChunkMetaData nextChunkMeta() {
        return this.chunkMetaDataList.get(this.chunkToRead++);
    }
}

