/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.AndNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.LeafNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.OrNode;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithFilter;

public class TimeGeneratorImpl
implements TimeGenerator {
    private IChunkLoader chunkLoader;
    private IMetadataQuerier metadataQuerier;
    private Node operatorNode;
    private HashMap<Path, List<LeafNode>> leafCache;

    public TimeGeneratorImpl(IExpression iexpression, IChunkLoader chunkLoader, IMetadataQuerier metadataQuerier) throws IOException {
        this.chunkLoader = chunkLoader;
        this.metadataQuerier = metadataQuerier;
        this.leafCache = new HashMap();
        this.operatorNode = this.construct(iexpression);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.operatorNode.hasNext();
    }

    @Override
    public long next() throws IOException {
        return this.operatorNode.next();
    }

    @Override
    public Object getValue(Path path, long time) {
        for (LeafNode leafNode : this.leafCache.get(path)) {
            if (!leafNode.currentTimeIs(time)) continue;
            return leafNode.currentValue(time);
        }
        return null;
    }

    private Node construct(IExpression expression) throws IOException {
        if (expression.getType() == ExpressionType.SERIES) {
            SingleSeriesExpression singleSeriesExp = (SingleSeriesExpression)expression;
            FileSeriesReader seriesReader = this.generateSeriesReader(singleSeriesExp);
            Path path = singleSeriesExp.getSeriesPath();
            if (!this.leafCache.containsKey(path)) {
                this.leafCache.put(path, new ArrayList());
            }
            LeafNode leafNode = new LeafNode(seriesReader);
            this.leafCache.get(path).add(leafNode);
            return leafNode;
        }
        if (expression.getType() == ExpressionType.OR) {
            Node leftChild = this.construct(((IBinaryExpression)expression).getLeft());
            Node rightChild = this.construct(((IBinaryExpression)expression).getRight());
            return new OrNode(leftChild, rightChild);
        }
        if (expression.getType() == ExpressionType.AND) {
            Node leftChild = this.construct(((IBinaryExpression)expression).getLeft());
            Node rightChild = this.construct(((IBinaryExpression)expression).getRight());
            return new AndNode(leftChild, rightChild);
        }
        throw new UnSupportedDataTypeException("Unsupported ExpressionType when construct OperatorNode: " + (Object)((Object)expression.getType()));
    }

    private FileSeriesReader generateSeriesReader(SingleSeriesExpression singleSeriesExp) throws IOException {
        List<ChunkMetaData> chunkMetaDataList = this.metadataQuerier.getChunkMetaDataList(singleSeriesExp.getSeriesPath());
        return new FileSeriesReaderWithFilter(this.chunkLoader, chunkMetaDataList, singleSeriesExp.getFilter());
    }
}

