/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.exception.NotCompatibleException;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSequenceReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSequenceReader.class);
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    protected String file;
    private TsFileInput tsFileInput;
    private long fileMetadataPos;
    private int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    private int totalChunkNum;
    private TsFileMetaData tsFileMetaData;
    private EndianType endianType = EndianType.BIG_ENDIAN;
    private boolean isOldVersion = false;
    private boolean cacheDeviceMetadata = false;
    private Map<TsDeviceMetadataIndex, TsDeviceMetadata> deviceMetadataMap;

    public TsFileSequenceReader(String file) throws IOException {
        this(file, true);
    }

    public TsFileSequenceReader(String file, boolean loadMetadataSize) throws IOException {
        this.file = file;
        this.tsFileInput = FSFactoryProducer.getFileInputFactory().getTsFileInput(file);
        this.endianType = this.readVersionNumber().startsWith("v") ? EndianType.LITTLE_ENDIAN : EndianType.BIG_ENDIAN;
        this.isOldVersion = this.readVersionNumber().startsWith("v");
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(String file, boolean loadMetadata, boolean cacheDeviceMetadata) throws IOException {
        this(file, loadMetadata);
        this.cacheDeviceMetadata = cacheDeviceMetadata;
        if (cacheDeviceMetadata) {
            this.deviceMetadataMap = new HashMap<TsDeviceMetadataIndex, TsDeviceMetadata>();
        }
    }

    public TsFileSequenceReader(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReader(TsFileInput input, boolean loadMetadataSize) throws IOException {
        this.tsFileInput = input;
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        this.tsFileInput = input;
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    public void loadMetadataSize() throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        if (this.readTailMagic().equals("TsFile")) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        } else if (this.readTailMagic().equals("v0.8.0")) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFilev0.8.0".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFilev0.8.0".getBytes().length - 4L - (long)this.fileMetadataSize;
        }
    }

    public long getFileMetadataPos() {
        return this.fileMetadataPos;
    }

    public int getFileMetadataSize() {
        return this.fileMetadataSize;
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFile".getBytes().length);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        return this.tsFileInput.size() >= (long)("TsFile".getBytes().length * 2 + "000001".getBytes().length) && (this.readTailMagic().equals(this.readHeadMagic()) || this.readTailMagic().equals("v0.8.0"));
    }

    public String readHeadMagic() throws IOException {
        return this.readHeadMagic(false);
    }

    public String readHeadMagic(boolean movePosition) throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        if (movePosition) {
            this.tsFileInput.position(0L);
            this.tsFileInput.read(magicStringBytes);
        } else {
            this.tsFileInput.read(magicStringBytes, 0L);
        }
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public String readVersionNumber() throws IOException, NotCompatibleException {
        ByteBuffer versionNumberBytes = ByteBuffer.allocate("000001".getBytes().length);
        this.tsFileInput.read(versionNumberBytes, "TsFile".getBytes().length);
        versionNumberBytes.flip();
        return new String(versionNumberBytes.array());
    }

    public EndianType getEndianType() {
        return this.endianType;
    }

    public TsFileMetaData readFileMetadata() throws IOException {
        if (this.tsFileMetaData == null) {
            this.tsFileMetaData = TsFileMetaData.deserializeFrom(this.readData(this.fileMetadataPos, this.fileMetadataSize), this.isOldVersion);
        }
        if (this.isOldVersion) {
            this.tsFileMetaData.setTotalChunkNum(this.countTotalChunkNum());
        }
        return this.tsFileMetaData;
    }

    private int countTotalChunkNum() throws IOException {
        int count = 0;
        for (TsDeviceMetadataIndex deviceIndex : this.tsFileMetaData.getDeviceMap().values()) {
            TsDeviceMetadata deviceMetadata = this.readTsDeviceMetaData(deviceIndex);
            for (ChunkGroupMetaData chunkGroupMetaData : deviceMetadata.getChunkGroupMetaDataList()) {
                count += chunkGroupMetaData.getChunkMetaDataList().size();
            }
        }
        return count;
    }

    public long getPositionOfFirstDeviceMetaIndex() throws IOException {
        TsFileMetaData metaData = this.readFileMetadata();
        Optional<Long> data = metaData.getDeviceMap().values().stream().map(TsDeviceMetadataIndex::getOffset).min(Comparator.comparing(Long::valueOf));
        if (data.isPresent()) {
            return data.get();
        }
        return "TsFile".getBytes().length + "000001".getBytes().length;
    }

    public TsDeviceMetadata readTsDeviceMetaData(TsDeviceMetadataIndex index) throws IOException {
        if (index == null) {
            return null;
        }
        TsDeviceMetadata deviceMetadata = null;
        if (this.cacheDeviceMetadata) {
            deviceMetadata = this.deviceMetadataMap.get(index);
        }
        if (deviceMetadata == null) {
            deviceMetadata = TsDeviceMetadata.deserializeFrom(this.readData(index.getOffset(), index.getLen()));
            if (this.cacheDeviceMetadata) {
                this.deviceMetadataMap.put(index, deviceMetadata);
            }
        }
        return deviceMetadata;
    }

    public ChunkGroupFooter readChunkGroupFooter() throws IOException {
        return ChunkGroupFooter.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public ChunkGroupFooter readChunkGroupFooter(long position, boolean markerRead) throws IOException {
        return ChunkGroupFooter.deserializeFrom(this.tsFileInput, position, markerRead);
    }

    public void setPositionToAChunkGroup(ChunkGroupFooter footer) throws IOException {
        this.tsFileInput.position(this.tsFileInput.position() - footer.getDataSize() - (long)footer.getSerializedSize());
    }

    public ChunkHeader readChunkHeader() throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    private ChunkHeader readChunkHeader(long position, int chunkHeaderSize, boolean markerRead) throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput, position, chunkHeaderSize, markerRead);
    }

    public ByteBuffer readChunk(ChunkHeader header) throws IOException {
        return this.readData(-1L, header.getDataSize());
    }

    public ByteBuffer readChunk(ChunkHeader header, long position) throws IOException {
        return this.readData(position, header.getDataSize());
    }

    private ByteBuffer readChunk(long position, int dataSize) throws IOException {
        return this.readData(position, dataSize);
    }

    public Chunk readMemChunk(ChunkMetaData metaData) throws IOException {
        int chunkHeadSize = ChunkHeader.getSerializedSize(metaData.getMeasurementUid());
        ChunkHeader header = this.readChunkHeader(metaData.getOffsetOfChunkHeader(), chunkHeadSize, false);
        ByteBuffer buffer = this.readChunk(metaData.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
        return new Chunk(header, buffer, metaData.getDeletedAt(), this.endianType);
    }

    public PageHeader readPageHeader(TSDataType type) throws IOException {
        return PageHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type);
    }

    private PageHeader readPageHeader(TSDataType dataType, long position, boolean markerRead) throws IOException {
        return PageHeader.deserializeFrom(dataType, this.tsFileInput, position, markerRead);
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public void skipPageData(PageHeader header) throws IOException {
        this.tsFileInput.position(this.tsFileInput.position() + (long)header.getCompressedSize());
    }

    public long skipPageData(PageHeader header, long position) throws IOException {
        return position + (long)header.getCompressedSize();
    }

    public ByteBuffer readPage(PageHeader header, CompressionType type) throws IOException {
        return this.readPage(header, type, -1L);
    }

    private ByteBuffer readPage(PageHeader header, CompressionType type, long position) throws IOException {
        ByteBuffer buffer = this.readData(position, header.getCompressedSize());
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(type);
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(header.getUncompressedSize());
        switch (type) {
            case UNCOMPRESSED: {
                return buffer;
            }
        }
        unCompressor.uncompress(buffer.array(), buffer.position(), buffer.remaining(), uncompressedBuffer.array(), 0);
        return uncompressedBuffer;
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    public byte readMarker(long position) throws IOException {
        return this.readData(position, 1).get();
    }

    @Override
    public void close() throws IOException {
        this.tsFileInput.close();
        this.deviceMetadataMap = null;
    }

    public String getFileName() {
        return this.file;
    }

    public long fileSize() throws IOException {
        return this.tsFileInput.size();
    }

    private ByteBuffer readData(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (position == -1L ? ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) != size : ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, size) != size) {
            throw new IOException("reach the end of the data");
        }
        buffer.flip();
        return buffer;
    }

    public int readRaw(long position, int length, ByteBuffer target) throws IOException {
        return ReadWriteIOUtils.readAsPossible(this.tsFileInput, target, position, length);
    }

    public long selfCheck(Map<String, MeasurementSchema> newSchema, List<ChunkGroupMetaData> newMetaData, boolean fastFinish) throws IOException {
        File checkFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!checkFile.exists()) {
            return -4L;
        }
        long fileSize = checkFile.length();
        long startTimeOfChunk = 0L;
        long endTimeOfChunk = 0L;
        long numOfPoints = 0L;
        ArrayList<ChunkMetaData> chunks = null;
        long startOffsetOfChunkGroup = 0L;
        long versionOfChunkGroup = 0L;
        if (fileSize < (long)("TsFile".getBytes().length + "000001".getBytes().length)) {
            return -3L;
        }
        String magic = this.readHeadMagic(true);
        this.tsFileInput.position("TsFile".getBytes().length + "000001".getBytes().length);
        if (!magic.equals("TsFile")) {
            return -3L;
        }
        if (fileSize == (long)("TsFile".getBytes().length + "000001".getBytes().length)) {
            return -2L;
        }
        if (this.readTailMagic().equals(magic)) {
            this.loadMetadataSize();
            if (fastFinish) {
                return -1L;
            }
        }
        boolean newChunkGroup = true;
        long truncatedPosition = TsFileIOWriter.magicStringBytes.length;
        boolean goon = true;
        int chunkCnt = 0;
        try {
            byte marker;
            block6: while (goon && (marker = this.readMarker()) != 2) {
                switch (marker) {
                    case 1: {
                        if (newChunkGroup) {
                            newChunkGroup = false;
                            chunks = new ArrayList<ChunkMetaData>();
                            startOffsetOfChunkGroup = this.position() - 1L;
                        }
                        long fileOffsetOfChunk = this.position() - 1L;
                        ChunkHeader header = this.readChunkHeader();
                        String measurementID = header.getMeasurementID();
                        if (newSchema != null) {
                            newSchema.putIfAbsent(measurementID, new MeasurementSchema(measurementID, header.getDataType(), header.getEncodingType(), header.getCompressionType()));
                        }
                        TSDataType dataType = header.getDataType();
                        Statistics<?> chunkStatistics = Statistics.getStatsByType(dataType);
                        if (header.getNumOfPages() > 0) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            numOfPoints += (long)pageHeader.getNumOfValues();
                            startTimeOfChunk = pageHeader.getMinTimestamp();
                            endTimeOfChunk = pageHeader.getMaxTimestamp();
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            this.skipPageData(pageHeader);
                        }
                        for (int j = 1; j < header.getNumOfPages() - 1; ++j) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            numOfPoints += (long)pageHeader.getNumOfValues();
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            this.skipPageData(pageHeader);
                        }
                        if (header.getNumOfPages() > 1) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            numOfPoints += (long)pageHeader.getNumOfValues();
                            endTimeOfChunk = pageHeader.getMaxTimestamp();
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            this.skipPageData(pageHeader);
                        }
                        ChunkMetaData currentChunk = new ChunkMetaData(measurementID, dataType, fileOffsetOfChunk, startTimeOfChunk, endTimeOfChunk);
                        currentChunk.setNumOfPoints(numOfPoints);
                        ByteBuffer[] statisticsArray = new ByteBuffer[TsDigest.StatisticType.getTotalTypeNum()];
                        statisticsArray[TsDigest.StatisticType.min_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getMinBytes());
                        statisticsArray[TsDigest.StatisticType.max_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getMaxBytes());
                        statisticsArray[TsDigest.StatisticType.first_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getFirstBytes());
                        statisticsArray[TsDigest.StatisticType.last_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getLastBytes());
                        statisticsArray[TsDigest.StatisticType.sum_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getSumBytes());
                        TsDigest tsDigest = new TsDigest();
                        tsDigest.setStatistics(statisticsArray);
                        currentChunk.setDigest(tsDigest);
                        chunks.add(currentChunk);
                        numOfPoints = 0L;
                        ++chunkCnt;
                        continue block6;
                    }
                    case 0: {
                        ChunkGroupFooter chunkGroupFooter = this.readChunkGroupFooter();
                        String deviceID = chunkGroupFooter.getDeviceID();
                        long endOffsetOfChunkGroup = this.position();
                        ChunkGroupMetaData currentChunkGroup = new ChunkGroupMetaData(deviceID, chunks, startOffsetOfChunkGroup);
                        currentChunkGroup.setEndOffsetOfChunkGroup(endOffsetOfChunkGroup);
                        currentChunkGroup.setVersion(versionOfChunkGroup++);
                        newMetaData.add(currentChunkGroup);
                        newChunkGroup = true;
                        truncatedPosition = this.position();
                        this.totalChunkNum += chunkCnt;
                        chunkCnt = 0;
                        continue block6;
                    }
                }
                MetaMarker.handleUnexpectedMarker(marker);
                goon = false;
                logger.error(String.format("Unrecognized marker detected, this file {%s} may be corrupted", this.file));
            }
            truncatedPosition = this.position() - 1L;
        }
        catch (Exception e2) {
            logger.info("TsFile {} self-check cannot proceed at position {} after {} chunk groups recovered, because : {}", new Object[]{this.file, this.position(), newMetaData.size(), e2.getMessage()});
        }
        return truncatedPosition;
    }

    public int getTotalChunkNum() {
        return this.totalChunkNum;
    }

    public List<ChunkMetaData> getChunkMetadataList(Path path) throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        if (!this.tsFileMetaData.containsDevice(path.getDevice())) {
            return new ArrayList<ChunkMetaData>();
        }
        TsDeviceMetadataIndex index = this.tsFileMetaData.getDeviceMetadataIndex(path.getDevice());
        TsDeviceMetadata tsDeviceMetadata = this.readTsDeviceMetaData(index);
        ArrayList<ChunkMetaData> chunkMetaDataList = new ArrayList<ChunkMetaData>();
        for (ChunkGroupMetaData chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
            List<ChunkMetaData> chunkMetaDataListInOneChunkGroup = chunkGroupMetaData.getChunkMetaDataList();
            for (ChunkMetaData chunkMetaData : chunkMetaDataListInOneChunkGroup) {
                if (!path.getMeasurement().equals(chunkMetaData.getMeasurementUid())) continue;
                chunkMetaData.setVersion(chunkGroupMetaData.getVersion());
                chunkMetaDataList.add(chunkMetaData);
            }
        }
        chunkMetaDataList.sort(Comparator.comparingLong(ChunkMetaData::getStartTime));
        return chunkMetaDataList;
    }

    public List<ChunkGroupMetaData> getSortedChunkGroupMetaDataListByDeviceIds() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        ArrayList<ChunkGroupMetaData> result = new ArrayList<ChunkGroupMetaData>();
        for (Map.Entry<String, TsDeviceMetadataIndex> entry : this.tsFileMetaData.getDeviceMap().entrySet()) {
            TsDeviceMetadata tsDeviceMetadata = this.readTsDeviceMetaData(entry.getValue());
            result.addAll(tsDeviceMetadata.getChunkGroupMetaDataList());
        }
        result.sort(Comparator.comparingLong(ChunkGroupMetaData::getStartOffsetOfChunkGroup));
        return result;
    }

    public List<String> getDeviceNameInRange(long start, long end) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            TsFileMetaData tsFileMetaData = this.readFileMetadata();
            block2: for (Map.Entry<String, TsDeviceMetadataIndex> entry : tsFileMetaData.getDeviceMap().entrySet()) {
                TsDeviceMetadata tsDeviceMetadata = this.readTsDeviceMetaData(entry.getValue());
                for (ChunkGroupMetaData chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
                    LocateStatus mode = this.checkLocateStatus(chunkGroupMetaData, start, end);
                    if (mode != LocateStatus.in) continue;
                    res.add(entry.getKey());
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private LocateStatus checkLocateStatus(ChunkGroupMetaData chunkGroupMetaData, long spacePartitionStartPos, long spacePartitionEndPos) {
        long endOffsetOfChunkGroup;
        long startOffsetOfChunkGroup = chunkGroupMetaData.getStartOffsetOfChunkGroup();
        long middleOffsetOfChunkGroup = (startOffsetOfChunkGroup + (endOffsetOfChunkGroup = chunkGroupMetaData.getEndOffsetOfChunkGroup())) / 2L;
        if (spacePartitionStartPos <= middleOffsetOfChunkGroup && middleOffsetOfChunkGroup < spacePartitionEndPos) {
            return LocateStatus.in;
        }
        if (middleOffsetOfChunkGroup < spacePartitionStartPos) {
            return LocateStatus.before;
        }
        return LocateStatus.after;
    }

    private static enum LocateStatus {
        in,
        before,
        after;

    }
}

