/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class IntegerStatistics
extends Statistics<Integer> {
    private int min;
    private int max;
    private int first;
    private int last;
    private double sum;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.min = BytesUtils.bytesToInt(minBytes);
        this.max = BytesUtils.bytesToInt(maxBytes);
    }

    @Override
    public void updateStats(int value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value, value);
            this.isEmpty = false;
        }
    }

    @Override
    public void updateStats(int[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (this.isEmpty) {
                this.initializeStats(values[i], values[i], values[i], values[i], values[i]);
                this.isEmpty = false;
                continue;
            }
            this.updateStats(values[i], values[i], values[i], values[i], values[i]);
        }
    }

    private void updateStats(int minValue, int maxValue, int firstValue, int lastValue, double sumValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
        this.sum += sumValue;
        this.last = lastValue;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public Integer getFirst() {
        return this.first;
    }

    @Override
    public Integer getLast() {
        return this.last;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        IntegerStatistics intStats = (IntegerStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(intStats.getMin(), intStats.getMax(), intStats.getFirst(), intStats.getLast(), intStats.getSum());
            this.isEmpty = false;
        } else {
            this.updateStats(intStats.getMin(), intStats.getMax(), intStats.getFirst(), intStats.getLast(), intStats.getSum());
        }
    }

    private void initializeStats(int min, int max, int first, int last, double sum) {
        this.min = min;
        this.max = max;
        this.first = first;
        this.last = last;
        this.sum = sum;
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.intToBytes(this.min);
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.intToBytes(this.max);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.intToBytes(this.first);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.intToBytes(this.last);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public int sizeOfDatum() {
        return 4;
    }

    public String toString() {
        return "[min:" + this.min + ",max:" + this.max + ",first:" + this.first + ",last:" + this.last + ",sum:" + this.sum + "]";
    }

    @Override
    void deserialize(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readInt(inputStream);
        this.max = ReadWriteIOUtils.readInt(inputStream);
        this.first = ReadWriteIOUtils.readInt(inputStream);
        this.last = ReadWriteIOUtils.readInt(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void deserialize(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readInt(byteBuffer);
        this.max = ReadWriteIOUtils.readInt(byteBuffer);
        this.first = ReadWriteIOUtils.readInt(byteBuffer);
        this.last = ReadWriteIOUtils.readInt(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

