/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.NoStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PageHeader {
    private int uncompressedSize;
    private int compressedSize;
    private int numOfValues;
    private Statistics statistics;
    private long maxTimestamp;
    private long minTimestamp;
    private int serializedSize;

    public PageHeader(int uncompressedSize, int compressedSize, int numOfValues, Statistics statistics, long maxTimestamp, long minTimestamp) {
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
        this.numOfValues = numOfValues;
        this.statistics = statistics == null ? new NoStatistics() : statistics;
        this.maxTimestamp = maxTimestamp;
        this.minTimestamp = minTimestamp;
        this.serializedSize = this.calculatePageHeaderSize();
    }

    public static int calculatePageHeaderSize(TSDataType type) {
        return PageHeader.calculatePageHeaderSizeWithoutStatistics() + Statistics.getStatsByType(type).getSerializedSize();
    }

    public static int calculatePageHeaderSizeWithoutStatistics() {
        return 28;
    }

    public static PageHeader deserializeFrom(InputStream inputStream, TSDataType dataType) throws IOException {
        int uncompressedSize = ReadWriteIOUtils.readInt(inputStream);
        int compressedSize = ReadWriteIOUtils.readInt(inputStream);
        int numOfValues = ReadWriteIOUtils.readInt(inputStream);
        long maxTimestamp = ReadWriteIOUtils.readLong(inputStream);
        long minTimestamp = ReadWriteIOUtils.readLong(inputStream);
        Statistics statistics = Statistics.deserialize(inputStream, dataType);
        return new PageHeader(uncompressedSize, compressedSize, numOfValues, statistics, maxTimestamp, minTimestamp);
    }

    public static PageHeader deserializeFrom(ByteBuffer buffer, TSDataType dataType) throws IOException {
        int uncompressedSize = ReadWriteIOUtils.readInt(buffer);
        int compressedSize = ReadWriteIOUtils.readInt(buffer);
        int numOfValues = ReadWriteIOUtils.readInt(buffer);
        long maxTimestamp = ReadWriteIOUtils.readLong(buffer);
        long minTimestamp = ReadWriteIOUtils.readLong(buffer);
        Statistics statistics = Statistics.deserialize(buffer, dataType);
        return new PageHeader(uncompressedSize, compressedSize, numOfValues, statistics, maxTimestamp, minTimestamp);
    }

    public static PageHeader deserializeFrom(TSDataType dataType, TsFileInput input, long offset, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        if (dataType == TSDataType.TEXT) {
            int sizeWithoutStatistics = PageHeader.calculatePageHeaderSizeWithoutStatistics();
            ByteBuffer bufferWithoutStatistics = ByteBuffer.allocate(sizeWithoutStatistics);
            ReadWriteIOUtils.readAsPossible(input, offsetVar, bufferWithoutStatistics);
            bufferWithoutStatistics.flip();
            Statistics statistics = Statistics.deserialize(input, offsetVar += (long)sizeWithoutStatistics, dataType);
            return PageHeader.deserializePartFrom(statistics, bufferWithoutStatistics);
        }
        int size = PageHeader.calculatePageHeaderSize(dataType);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        ReadWriteIOUtils.readAsPossible(input, offsetVar, buffer);
        buffer.flip();
        return PageHeader.deserializeFrom(buffer, dataType);
    }

    private static PageHeader deserializePartFrom(Statistics statistics, ByteBuffer buffer) {
        int uncompressedSize = ReadWriteIOUtils.readInt(buffer);
        int compressedSize = ReadWriteIOUtils.readInt(buffer);
        int numOfValues = ReadWriteIOUtils.readInt(buffer);
        long maxTimestamp = ReadWriteIOUtils.readLong(buffer);
        long minTimestamp = ReadWriteIOUtils.readLong(buffer);
        return new PageHeader(uncompressedSize, compressedSize, numOfValues, statistics, maxTimestamp, minTimestamp);
    }

    public int calculatePageHeaderSize() {
        return 28 + this.statistics.getSerializedSize();
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(int uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(int compressedSize) {
        this.compressedSize = compressedSize;
    }

    public int getNumOfValues() {
        return this.numOfValues;
    }

    public void setNumOfValues(int numOfValues) {
        this.numOfValues = numOfValues;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public void setMaxTimestamp(long maxTimestamp) {
        this.maxTimestamp = maxTimestamp;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public void setMinTimestamp(long minTimestamp) {
        this.minTimestamp = minTimestamp;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write(this.uncompressedSize, outputStream);
        length += ReadWriteIOUtils.write(this.compressedSize, outputStream);
        length += ReadWriteIOUtils.write(this.numOfValues, outputStream);
        length += ReadWriteIOUtils.write(this.maxTimestamp, outputStream);
        length += ReadWriteIOUtils.write(this.minTimestamp, outputStream);
        return length += this.statistics.serialize(outputStream);
    }

    public String toString() {
        return "PageHeader{uncompressedSize=" + this.uncompressedSize + ", compressedSize=" + this.compressedSize + ", numOfValues=" + this.numOfValues + ", statistics=" + this.statistics + ", maxTimestamp=" + this.maxTimestamp + ", minTimestamp=" + this.minTimestamp + ", serializedSize=" + this.serializedSize + '}';
    }
}

