/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainDecoder
extends Decoder {
    private static final Logger logger = LoggerFactory.getLogger(PlainDecoder.class);
    private EndianType endianType;

    @Override
    public EndianType getEndianType() {
        return this.endianType;
    }

    @Override
    public void setEndianType(EndianType endianType) {
        this.endianType = endianType;
    }

    public PlainDecoder(EndianType endianType) {
        super(TSEncoding.PLAIN);
        this.endianType = endianType;
    }

    @Override
    public boolean readBoolean(ByteBuffer buffer) {
        if (this.getEndianType() == EndianType.LITTLE_ENDIAN) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer.get() != 0;
    }

    @Override
    public short readShort(ByteBuffer buffer) {
        if (this.getEndianType() == EndianType.LITTLE_ENDIAN) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer.getShort();
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        if (this.getEndianType() == EndianType.LITTLE_ENDIAN) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer.getInt();
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        if (this.getEndianType() == EndianType.LITTLE_ENDIAN) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer.getLong();
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        if (this.getEndianType() == EndianType.LITTLE_ENDIAN) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer.getFloat();
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        if (this.getEndianType() == EndianType.LITTLE_ENDIAN) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer.getDouble();
    }

    @Override
    public Binary readBinary(ByteBuffer buffer) {
        int length = this.readInt(buffer);
        byte[] buf = new byte[length];
        buffer.get(buf, 0, buf.length);
        return new Binary(buf);
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return buffer.remaining() > 0;
    }

    @Override
    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supproted by PlainDecoder");
    }

    @Override
    public void reset() {
    }
}

